/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.regionserver;

import io.hops.hudi.org.apache.hadoop.hbase.regionserver.HStoreFile;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
final class StoreFileComparators {
    public static final Comparator<HStoreFile> SEQ_ID = Comparator.comparingLong(HStoreFile::getMaxSequenceId).thenComparing(Comparator.comparingLong(new GetFileSize()).reversed()).thenComparingLong(new GetBulkTime()).thenComparing(new GetPathName());
    public static final Comparator<HStoreFile> SEQ_ID_MAX_TIMESTAMP = Comparator.comparingLong(HStoreFile::getMaxSequenceId).thenComparingLong(new GetMaxTimestamp()).thenComparing(Comparator.comparingLong(new GetFileSize()).reversed()).thenComparingLong(new GetBulkTime()).thenComparing(new GetPathName());

    StoreFileComparators() {
    }

    private static class GetMaxTimestamp
    implements ToLongFunction<HStoreFile> {
        private GetMaxTimestamp() {
        }

        @Override
        public long applyAsLong(HStoreFile sf) {
            return sf.getMaximumTimestamp().orElse(Long.MAX_VALUE);
        }
    }

    private static class GetPathName
    implements Function<HStoreFile, String> {
        private GetPathName() {
        }

        @Override
        public String apply(HStoreFile sf) {
            return sf.getPath().getName();
        }
    }

    private static class GetBulkTime
    implements ToLongFunction<HStoreFile> {
        private GetBulkTime() {
        }

        @Override
        public long applyAsLong(HStoreFile sf) {
            return sf.getBulkLoadTimestamp().orElse(Long.MAX_VALUE);
        }
    }

    private static class GetFileSize
    implements ToLongFunction<HStoreFile> {
        private GetFileSize() {
        }

        @Override
        public long applyAsLong(HStoreFile sf) {
            if (sf.getReader() != null) {
                return sf.getReader().length();
            }
            return -1L;
        }
    }
}

