/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.regionserver.throttle;

import io.hops.hudi.org.apache.hadoop.hbase.regionserver.RegionServerServices;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.throttle.NoLimitThroughputController;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public final class FlushThroughputControllerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(FlushThroughputControllerFactory.class);
    public static final String HBASE_FLUSH_THROUGHPUT_CONTROLLER_KEY = "hbase.regionserver.flush.throughput.controller";
    private static final Class<? extends ThroughputController> DEFAULT_FLUSH_THROUGHPUT_CONTROLLER_CLASS = NoLimitThroughputController.class;

    private FlushThroughputControllerFactory() {
    }

    public static ThroughputController create(RegionServerServices server, Configuration conf) {
        Class<? extends ThroughputController> clazz = FlushThroughputControllerFactory.getThroughputControllerClass(conf);
        ThroughputController controller = (ThroughputController)ReflectionUtils.newInstance(clazz, (Configuration)conf);
        controller.setup(server);
        return controller;
    }

    public static Class<? extends ThroughputController> getThroughputControllerClass(Configuration conf) {
        String className = conf.get(HBASE_FLUSH_THROUGHPUT_CONTROLLER_KEY, DEFAULT_FLUSH_THROUGHPUT_CONTROLLER_CLASS.getName());
        try {
            return Class.forName(className).asSubclass(ThroughputController.class);
        }
        catch (Exception e) {
            LOG.warn("Unable to load configured flush throughput controller '" + className + "', load default throughput controller " + DEFAULT_FLUSH_THROUGHPUT_CONTROLLER_CLASS.getName() + " instead", (Throwable)e);
            return DEFAULT_FLUSH_THROUGHPUT_CONTROLLER_CLASS;
        }
    }
}

