/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.regionserver.wal;

import io.hops.hudi.org.apache.hadoop.hbase.io.TagCompressionContext;
import io.hops.hudi.org.apache.hadoop.hbase.io.util.Dictionary;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.EnumMap;
import java.util.Map;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor", "Phoenix"})
public class CompressionContext {
    static final String ENABLE_WAL_TAGS_COMPRESSION = "hbase.regionserver.wal.tags.enablecompression";
    private final Map<DictionaryIndex, Dictionary> dictionaries = new EnumMap<DictionaryIndex, Dictionary>(DictionaryIndex.class);
    TagCompressionContext tagCompressionContext = null;

    public CompressionContext(Class<? extends Dictionary> dictType, boolean recoveredEdits, boolean hasTagCompression) throws SecurityException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<? extends Dictionary> dictConstructor = dictType.getConstructor(new Class[0]);
        for (DictionaryIndex dictionaryIndex : DictionaryIndex.values()) {
            Dictionary newDictionary = dictConstructor.newInstance(new Object[0]);
            this.dictionaries.put(dictionaryIndex, newDictionary);
        }
        if (recoveredEdits) {
            this.getDictionary(DictionaryIndex.REGION).init(1);
            this.getDictionary(DictionaryIndex.TABLE).init(1);
        } else {
            this.getDictionary(DictionaryIndex.REGION).init(Short.MAX_VALUE);
            this.getDictionary(DictionaryIndex.TABLE).init(Short.MAX_VALUE);
        }
        this.getDictionary(DictionaryIndex.ROW).init(Short.MAX_VALUE);
        this.getDictionary(DictionaryIndex.FAMILY).init(127);
        this.getDictionary(DictionaryIndex.QUALIFIER).init(127);
        if (hasTagCompression) {
            this.tagCompressionContext = new TagCompressionContext(dictType, Short.MAX_VALUE);
        }
    }

    public Dictionary getDictionary(Enum dictIndex) {
        return this.dictionaries.get(dictIndex);
    }

    void clear() {
        for (Dictionary dictionary : this.dictionaries.values()) {
            dictionary.clear();
        }
        if (this.tagCompressionContext != null) {
            this.tagCompressionContext.clear();
        }
    }

    public static enum DictionaryIndex {
        REGION,
        TABLE,
        FAMILY,
        QUALIFIER,
        ROW;

    }
}

