/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.replication.regionserver;

import io.hops.hudi.org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import io.hops.hudi.org.apache.hadoop.hbase.replication.ReplicationUtils;
import io.hops.hudi.org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import io.hops.hudi.org.apache.hadoop.hbase.wal.WALEdit;
import io.hops.hudi.org.apache.hadoop.hbase.wal.WALKey;
import io.hops.hudi.org.apache.hadoop.hbase.wal.WALKeyImpl;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class ReplicationSourceWALActionListener
implements WALActionsListener {
    private final Configuration conf;
    private final ReplicationSourceManager manager;

    public ReplicationSourceWALActionListener(Configuration conf, ReplicationSourceManager manager) {
        this.conf = conf;
        this.manager = manager;
    }

    @Override
    public void preLogRoll(Path oldPath, Path newPath) throws IOException {
        this.manager.preLogRoll(newPath);
    }

    @Override
    public void postLogRoll(Path oldPath, Path newPath) throws IOException {
        this.manager.postLogRoll(newPath);
    }

    @Override
    public void visitLogEntryBeforeWrite(WALKey logKey, WALEdit logEdit) throws IOException {
        ReplicationSourceWALActionListener.scopeWALEdits(logKey, logEdit, this.conf);
    }

    static void scopeWALEdits(WALKey logKey, WALEdit logEdit, Configuration conf) {
        if (ReplicationUtils.isReplicationForBulkLoadDataEnabled((Configuration)conf)) {
            return;
        }
        if (logEdit.isReplay() || logEdit.getCells().stream().allMatch(c -> WALEdit.isMetaEditFamily(c))) {
            ((WALKeyImpl)logKey).clearReplicationScope();
        }
    }
}

