/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.security.token;

import io.hops.hudi.org.apache.hadoop.hbase.client.Connection;
import io.hops.hudi.org.apache.hadoop.hbase.client.ConnectionFactory;
import io.hops.hudi.org.apache.hadoop.hbase.protobuf.generated.AuthenticationProtos;
import io.hops.hudi.org.apache.hadoop.hbase.security.User;
import io.hops.hudi.org.apache.hadoop.hbase.security.token.AuthenticationTokenIdentifier;
import io.hops.hudi.org.apache.hadoop.hbase.security.token.AuthenticationTokenSelector;
import io.hops.hudi.org.apache.hadoop.hbase.security.token.ClientTokenUtil;
import io.hops.hudi.org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import io.hops.hudi.org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.security.token.Token;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class TokenUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TokenUtil.class);

    @Deprecated
    public static Token<AuthenticationTokenIdentifier> obtainToken(Configuration conf) throws IOException {
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            Token<AuthenticationTokenIdentifier> token = TokenUtil.obtainToken(connection);
            return token;
        }
    }

    @Deprecated
    public static Token<AuthenticationTokenIdentifier> obtainToken(Connection conn) throws IOException {
        return ClientTokenUtil.obtainToken(conn);
    }

    @Deprecated
    public static AuthenticationProtos.Token toToken(Token<AuthenticationTokenIdentifier> token) {
        return ClientTokenUtil.toToken(token);
    }

    @Deprecated
    public static Token<AuthenticationTokenIdentifier> obtainToken(Connection conn, User user) throws IOException, InterruptedException {
        return ClientTokenUtil.obtainToken(conn, user);
    }

    public static void obtainAndCacheToken(Connection conn, User user) throws IOException, InterruptedException {
        ClientTokenUtil.obtainAndCacheToken(conn, user);
    }

    @Deprecated
    public static Token<AuthenticationTokenIdentifier> toToken(AuthenticationProtos.Token proto) {
        return ClientTokenUtil.toToken(proto);
    }

    private static Text getClusterId(Token<AuthenticationTokenIdentifier> token) throws IOException {
        return token.getService() != null ? token.getService() : new Text("default");
    }

    public static void obtainTokenForJob(Connection conn, User user, Job job) throws IOException, InterruptedException {
        try {
            Token<AuthenticationTokenIdentifier> token = ClientTokenUtil.obtainToken(conn, user);
            if (token == null) {
                throw new IOException("No token returned for user " + user.getName());
            }
            Text clusterId = TokenUtil.getClusterId(token);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Obtained token " + token.getKind().toString() + " for user " + user.getName() + " on cluster " + clusterId.toString());
            }
            job.getCredentials().addToken(clusterId, token);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e, "Unexpected exception obtaining token for user " + user.getName());
        }
    }

    public static void obtainTokenForJob(Connection conn, JobConf job, User user) throws IOException, InterruptedException {
        try {
            Token<AuthenticationTokenIdentifier> token = ClientTokenUtil.obtainToken(conn, user);
            if (token == null) {
                throw new IOException("No token returned for user " + user.getName());
            }
            Text clusterId = TokenUtil.getClusterId(token);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Obtained token " + token.getKind().toString() + " for user " + user.getName() + " on cluster " + clusterId.toString());
            }
            job.getCredentials().addToken(clusterId, token);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e, "Unexpected exception obtaining token for user " + user.getName());
        }
    }

    public static void addTokenForJob(Connection conn, JobConf job, User user) throws IOException, InterruptedException {
        Token<AuthenticationTokenIdentifier> token = TokenUtil.getAuthToken(conn.getConfiguration(), user);
        if (token == null) {
            token = ClientTokenUtil.obtainToken(conn, user);
        }
        job.getCredentials().addToken(token.getService(), token);
    }

    public static void addTokenForJob(Connection conn, User user, Job job) throws IOException, InterruptedException {
        Token<AuthenticationTokenIdentifier> token = TokenUtil.getAuthToken(conn.getConfiguration(), user);
        if (token == null) {
            token = ClientTokenUtil.obtainToken(conn, user);
        }
        job.getCredentials().addToken(token.getService(), token);
    }

    public static boolean addTokenIfMissing(Connection conn, User user) throws IOException, InterruptedException {
        Token<AuthenticationTokenIdentifier> token = TokenUtil.getAuthToken(conn.getConfiguration(), user);
        if (token == null) {
            token = ClientTokenUtil.obtainToken(conn, user);
            user.getUGI().addToken(token.getService(), token);
            return true;
        }
        return false;
    }

    private static Token<AuthenticationTokenIdentifier> getAuthToken(Configuration conf, User user) throws IOException, InterruptedException {
        try (ZKWatcher zkw = new ZKWatcher(conf, "TokenUtil-getAuthToken", null);){
            String clusterId = ZKClusterId.readClusterIdZNode((ZKWatcher)zkw);
            if (clusterId == null) {
                throw new IOException("Failed to get cluster ID");
            }
            Token<AuthenticationTokenIdentifier> token = new AuthenticationTokenSelector().selectToken(new Text(clusterId), user.getTokens());
            return token;
        }
    }
}

