/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.tool.coprocessor;

import io.hops.hudi.org.apache.hadoop.hbase.tool.coprocessor.CoprocessorMethod;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CoprocessorMethods {
    private final Set<CoprocessorMethod> methods = new HashSet<CoprocessorMethod>();

    public void addMethod(String name, String ... parameters) {
        CoprocessorMethod cpMethod = new CoprocessorMethod(name).withParameters(parameters);
        this.methods.add(cpMethod);
    }

    public void addMethod(String name, Class<?> ... parameters) {
        CoprocessorMethod cpMethod = new CoprocessorMethod(name).withParameters(parameters);
        this.methods.add(cpMethod);
    }

    public void addMethod(Method method) {
        CoprocessorMethod cpMethod = new CoprocessorMethod(method.getName()).withParameters(method.getParameterTypes());
        this.methods.add(cpMethod);
    }

    public boolean hasMethod(String name, String ... parameters) {
        CoprocessorMethod method = new CoprocessorMethod(name).withParameters(parameters);
        return this.methods.contains(method);
    }

    public boolean hasMethod(String name, Class<?> ... parameters) {
        CoprocessorMethod method = new CoprocessorMethod(name).withParameters(parameters);
        return this.methods.contains(method);
    }

    public boolean hasMethod(Method method) {
        CoprocessorMethod cpMethod = new CoprocessorMethod(method.getName()).withParameters(method.getParameterTypes());
        return this.methods.contains(cpMethod);
    }
}

