/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.wal;

import io.hops.hudi.org.apache.hadoop.hbase.Abortable;
import io.hops.hudi.org.apache.hadoop.hbase.FailedCloseWALAfterInitializedErrorException;
import io.hops.hudi.org.apache.hadoop.hbase.ServerName;
import io.hops.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.wal.AbstractFSWAL;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import io.hops.hudi.org.apache.hadoop.hbase.util.CancelableProgressable;
import io.hops.hudi.org.apache.hadoop.hbase.util.CommonFSUtils;
import io.hops.hudi.org.apache.hadoop.hbase.util.LeaseNotRecoveredException;
import io.hops.hudi.org.apache.hadoop.hbase.util.RecoverLeaseFSUtils;
import io.hops.hudi.org.apache.hadoop.hbase.wal.WAL;
import io.hops.hudi.org.apache.hadoop.hbase.wal.WALFactory;
import io.hops.hudi.org.apache.hadoop.hbase.wal.WALProvider;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class AbstractFSWALProvider<T extends AbstractFSWAL<?>>
implements WALProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFSWALProvider.class);
    public static final String SEPARATE_OLDLOGDIR = "hbase.separate.oldlogdir.by.regionserver";
    public static final boolean DEFAULT_SEPARATE_OLDLOGDIR = false;
    protected volatile T wal;
    protected WALFactory factory;
    protected Configuration conf;
    protected List<WALActionsListener> listeners = new ArrayList<WALActionsListener>();
    protected String providerId;
    protected AtomicBoolean initialized = new AtomicBoolean(false);
    protected String logPrefix;
    protected Abortable abortable;
    private final ReadWriteLock walCreateLock = new ReentrantReadWriteLock();
    public static final String WAL_FILE_NAME_DELIMITER = ".";
    public static final String META_WAL_PROVIDER_ID = ".meta";
    static final String DEFAULT_PROVIDER_ID = "default";
    public static final String SPLITTING_EXT = "-splitting";
    private static final Pattern pattern = Pattern.compile(".*\\.\\d*(.meta)*");

    @Override
    public void init(WALFactory factory, Configuration conf, String providerId, Abortable abortable) throws IOException {
        if (!this.initialized.compareAndSet(false, true)) {
            throw new IllegalStateException("WALProvider.init should only be called once.");
        }
        this.factory = factory;
        this.conf = conf;
        this.providerId = providerId;
        StringBuilder sb = new StringBuilder().append(factory.factoryId);
        if (providerId != null) {
            if (providerId.startsWith(WAL_FILE_NAME_DELIMITER)) {
                sb.append(providerId);
            } else {
                sb.append(WAL_FILE_NAME_DELIMITER).append(providerId);
            }
        }
        this.logPrefix = sb.toString();
        this.abortable = abortable;
        this.doInit(conf);
    }

    @Override
    public List<WAL> getWALs() {
        if (this.wal != null) {
            return Lists.newArrayList(this.wal);
        }
        this.walCreateLock.readLock().lock();
        try {
            if (this.wal == null) {
                List<WAL> list = Collections.emptyList();
                return list;
            }
            ArrayList<WAL> arrayList = Lists.newArrayList(this.wal);
            return arrayList;
        }
        finally {
            this.walCreateLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getWAL(RegionInfo region) throws IOException {
        T walCopy = this.wal;
        if (walCopy != null) {
            return walCopy;
        }
        this.walCreateLock.writeLock().lock();
        try {
            walCopy = this.wal;
            if (walCopy != null) {
                T t = walCopy;
                return t;
            }
            walCopy = this.createWAL();
            boolean succ = false;
            try {
                ((AbstractFSWAL)walCopy).init();
                succ = true;
            }
            finally {
                if (!succ) {
                    try {
                        ((AbstractFSWAL)walCopy).close();
                    }
                    catch (Throwable t) {
                        throw new FailedCloseWALAfterInitializedErrorException("Failed close after init wal failed.", t);
                    }
                }
            }
            this.wal = walCopy;
            T t = walCopy;
            return t;
        }
        finally {
            this.walCreateLock.writeLock().unlock();
        }
    }

    protected abstract T createWAL() throws IOException;

    protected abstract void doInit(Configuration var1) throws IOException;

    @Override
    public void shutdown() throws IOException {
        T log = this.wal;
        if (log != null) {
            ((AbstractFSWAL)log).shutdown();
        }
    }

    @Override
    public void close() throws IOException {
        T log = this.wal;
        if (log != null) {
            ((AbstractFSWAL)log).close();
        }
    }

    @Override
    public long getNumLogFiles() {
        T log = this.wal;
        return log == null ? 0L : (long)((AbstractFSWAL)log).getNumLogFiles();
    }

    @Override
    public long getLogFileSize() {
        T log = this.wal;
        return log == null ? 0L : ((AbstractFSWAL)log).getLogFileSize();
    }

    public static int getNumRolledLogFiles(WAL wal) {
        return ((AbstractFSWAL)wal).getNumRolledLogFiles();
    }

    public static long getLogFileSize(WAL wal) {
        return ((AbstractFSWAL)wal).getLogFileSize();
    }

    public static Path getCurrentFileName(WAL wal) {
        return ((AbstractFSWAL)wal).getCurrentFileName();
    }

    static void requestLogRoll(WAL wal) {
        ((AbstractFSWAL)wal).requestLogRoll();
    }

    public static long extractFileNumFromWAL(WAL wal) {
        Path walName = ((AbstractFSWAL)wal).getCurrentFileName();
        if (walName == null) {
            throw new IllegalArgumentException("The WAL path couldn't be null");
        }
        String[] walPathStrs = walName.toString().split("\\.");
        return Long.parseLong(walPathStrs[walPathStrs.length - (AbstractFSWALProvider.isMetaFile(walName) ? 2 : 1)]);
    }

    public static boolean validateWALFilename(String filename) {
        return pattern.matcher(filename).matches();
    }

    public static String getWALDirectoryName(String serverName) {
        StringBuilder dirName = new StringBuilder("WALs");
        dirName.append("/");
        dirName.append(serverName);
        return dirName.toString();
    }

    public static String getWALArchiveDirectoryName(Configuration conf, String serverName) {
        StringBuilder dirName = new StringBuilder("oldWALs");
        if (conf.getBoolean(SEPARATE_OLDLOGDIR, false)) {
            dirName.append("/");
            dirName.append(serverName);
        }
        return dirName.toString();
    }

    public static ServerName getServerNameFromWALDirectoryName(Configuration conf, String path) throws IOException {
        String fullPath;
        if (path == null || path.length() <= "WALs".length()) {
            return null;
        }
        if (conf == null) {
            throw new IllegalArgumentException("parameter conf must be set");
        }
        String rootDir = conf.get("hbase.rootdir");
        if (rootDir == null || rootDir.isEmpty()) {
            throw new IllegalArgumentException("hbase.rootdir key not found in conf.");
        }
        StringBuilder startPathSB = new StringBuilder(rootDir);
        if (!rootDir.endsWith("/")) {
            startPathSB.append('/');
        }
        startPathSB.append("WALs");
        if (!"WALs".endsWith("/")) {
            startPathSB.append('/');
        }
        String startPath = startPathSB.toString();
        try {
            fullPath = FileSystem.get((Configuration)conf).makeQualified(new Path(path)).toString();
        }
        catch (IllegalArgumentException e) {
            LOG.info("Call to makeQualified failed on " + path + " " + e.getMessage());
            return null;
        }
        if (!fullPath.startsWith(startPath)) {
            return null;
        }
        String serverNameAndFile = fullPath.substring(startPath.length());
        if (serverNameAndFile.indexOf(47) < "a,0,0".length()) {
            return null;
        }
        Path p = new Path(path);
        return AbstractFSWALProvider.getServerNameFromWALDirectoryName(p);
    }

    public static ServerName getServerNameFromWALDirectoryName(Path logFile) {
        String logDirName = logFile.getParent().getName();
        if (logDirName.equals("WALs")) {
            logDirName = logFile.getName();
        }
        ServerName serverName = null;
        if (logDirName.endsWith(SPLITTING_EXT)) {
            logDirName = logDirName.substring(0, logDirName.length() - SPLITTING_EXT.length());
        }
        try {
            serverName = ServerName.parseServerName(logDirName);
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            serverName = null;
            LOG.warn("Cannot parse a server name from path=" + logFile + "; " + ex.getMessage());
        }
        if (serverName != null && serverName.getStartcode() < 0L) {
            LOG.warn("Invalid log file path=" + logFile);
            serverName = null;
        }
        return serverName;
    }

    public static boolean isMetaFile(Path p) {
        return AbstractFSWALProvider.isMetaFile(p.getName());
    }

    public static boolean isMetaFile(String p) {
        return p != null && p.endsWith(META_WAL_PROVIDER_ID);
    }

    public static boolean isArchivedLogFile(Path p) {
        String oldLog = "/oldWALs/";
        return p.toString().contains(oldLog);
    }

    public static Path findArchivedLog(Path path, Configuration conf) throws IOException {
        Path oldLogDir;
        Path archivedLogLocation;
        if (path.toString().contains("oldWALs")) {
            return null;
        }
        Path walRootDir = CommonFSUtils.getWALRootDir(conf);
        FileSystem fs = path.getFileSystem(conf);
        if (fs.exists(archivedLogLocation = new Path(oldLogDir = new Path(walRootDir, "oldWALs"), path.getName()))) {
            LOG.info("Log " + path + " was moved to " + archivedLogLocation);
            return archivedLogLocation;
        }
        ServerName serverName = AbstractFSWALProvider.getServerNameFromWALDirectoryName(path);
        oldLogDir = new Path(walRootDir, "oldWALs" + "/" + serverName.getServerName());
        archivedLogLocation = new Path(oldLogDir, path.getName());
        if (fs.exists(archivedLogLocation)) {
            LOG.info("Log " + path + " was moved to " + archivedLogLocation);
            return archivedLogLocation;
        }
        LOG.error("Couldn't locate log: " + path);
        return null;
    }

    public static WAL.Reader openReader(Path path, Configuration conf) throws IOException {
        long retryInterval = 2000L;
        int maxAttempts = 30;
        int attempt = 0;
        Exception ee = null;
        WAL.Reader reader = null;
        while (reader == null && attempt++ < maxAttempts) {
            try {
                reader = WALFactory.createReader(path.getFileSystem(conf), path, conf);
                return reader;
            }
            catch (FileNotFoundException fnfe) {
                Path archivedLog = AbstractFSWALProvider.findArchivedLog(path, conf);
                if (archivedLog != null) {
                    return AbstractFSWALProvider.openReader(archivedLog, conf);
                }
                throw fnfe;
            }
            catch (LeaseNotRecoveredException lnre) {
                LOG.warn("Try to recover the WAL lease " + path, (Throwable)lnre);
                AbstractFSWALProvider.recoverLease(conf, path);
                reader = null;
                ee = lnre;
            }
            catch (NullPointerException npe) {
                LOG.warn("Got NPE opening reader, will retry.");
                reader = null;
                ee = npe;
            }
            if (reader != null) continue;
            try {
                Thread.sleep(retryInterval);
            }
            catch (InterruptedException interruptedException) {}
        }
        throw new IOException("Could not open reader", ee);
    }

    private static void recoverLease(Configuration conf, final Path path) {
        try {
            FileSystem dfs = CommonFSUtils.getCurrentFileSystem(conf);
            RecoverLeaseFSUtils.recoverFileLease((FileSystem)dfs, (Path)path, (Configuration)conf, (CancelableProgressable)new CancelableProgressable(){

                public boolean progress() {
                    LOG.debug("Still trying to recover WAL lease: " + path);
                    return true;
                }
            });
        }
        catch (IOException e) {
            LOG.warn("unable to recover lease for WAL: " + path, (Throwable)e);
        }
    }

    @Override
    public void addWALActionsListener(WALActionsListener listener) {
        this.listeners.add(listener);
    }

    public static String getWALPrefixFromWALName(String name) {
        int endIndex = name.replaceAll(META_WAL_PROVIDER_ID, "").lastIndexOf(WAL_FILE_NAME_DELIMITER);
        return name.substring(0, endIndex);
    }

    public static class WALStartTimeComparator
    implements Comparator<Path> {
        @Override
        public int compare(Path o1, Path o2) {
            return Long.compare(WALStartTimeComparator.getTS(o1), WALStartTimeComparator.getTS(o2));
        }

        public static long getTS(Path p) {
            return WAL.getTimestamp(p.getName());
        }
    }

    public static interface Reader
    extends WAL.Reader {
        public void init(FileSystem var1, Path var2, Configuration var3, FSDataInputStream var4) throws IOException;
    }
}

