/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hbase.thirdparty.org.apache.commons.collections4.functors;

import io.hops.hudi.org.apache.hbase.thirdparty.org.apache.commons.collections4.FunctorException;
import io.hops.hudi.org.apache.hbase.thirdparty.org.apache.commons.collections4.Predicate;
import io.hops.hudi.org.apache.hbase.thirdparty.org.apache.commons.collections4.Transformer;
import java.io.Serializable;

public final class TransformerPredicate<T>
implements Predicate<T>,
Serializable {
    private static final long serialVersionUID = -2407966402920578741L;
    private final Transformer<? super T, Boolean> iTransformer;

    public static <T> Predicate<T> transformerPredicate(Transformer<? super T, Boolean> transformer) {
        if (transformer == null) {
            throw new NullPointerException("The transformer to call must not be null");
        }
        return new TransformerPredicate<T>(transformer);
    }

    public TransformerPredicate(Transformer<? super T, Boolean> transformer) {
        this.iTransformer = transformer;
    }

    @Override
    public boolean evaluate(T object) {
        Boolean result = this.iTransformer.transform(object);
        if (result == null) {
            throw new FunctorException("Transformer must return an instanceof Boolean, it was a null object");
        }
        return result;
    }

    public Transformer<? super T, Boolean> getTransformer() {
        return this.iTransformer;
    }
}

