/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.http.client.methods;

import io.hops.hudi.org.apache.http.Header;
import io.hops.hudi.org.apache.http.HeaderElement;
import io.hops.hudi.org.apache.http.HeaderIterator;
import io.hops.hudi.org.apache.http.HttpResponse;
import io.hops.hudi.org.apache.http.annotation.NotThreadSafe;
import io.hops.hudi.org.apache.http.client.methods.HttpRequestBase;
import io.hops.hudi.org.apache.http.util.Args;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;

@NotThreadSafe
public class HttpOptions
extends HttpRequestBase {
    public static final String METHOD_NAME = "OPTIONS";

    public HttpOptions() {
    }

    public HttpOptions(URI uri2) {
        this.setURI(uri2);
    }

    public HttpOptions(String uri2) {
        this.setURI(URI.create(uri2));
    }

    @Override
    public String getMethod() {
        return METHOD_NAME;
    }

    public Set<String> getAllowedMethods(HttpResponse response) {
        Args.notNull(response, "HTTP response");
        HeaderIterator it = response.headerIterator("Allow");
        HashSet<String> methods = new HashSet<String>();
        while (it.hasNext()) {
            HeaderElement[] elements;
            Header header = it.nextHeader();
            for (HeaderElement element : elements = header.getElements()) {
                methods.add(element.getName());
            }
        }
        return methods;
    }
}

