/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.http.impl.execchain;

import io.hops.hudi.org.apache.http.HttpException;
import io.hops.hudi.org.apache.http.HttpHost;
import io.hops.hudi.org.apache.http.HttpRequest;
import io.hops.hudi.org.apache.http.ProtocolException;
import io.hops.hudi.org.apache.http.annotation.Immutable;
import io.hops.hudi.org.apache.http.auth.AuthScope;
import io.hops.hudi.org.apache.http.auth.UsernamePasswordCredentials;
import io.hops.hudi.org.apache.http.client.CredentialsProvider;
import io.hops.hudi.org.apache.http.client.methods.CloseableHttpResponse;
import io.hops.hudi.org.apache.http.client.methods.HttpExecutionAware;
import io.hops.hudi.org.apache.http.client.methods.HttpRequestWrapper;
import io.hops.hudi.org.apache.http.client.methods.HttpUriRequest;
import io.hops.hudi.org.apache.http.client.protocol.HttpClientContext;
import io.hops.hudi.org.apache.http.client.utils.URIUtils;
import io.hops.hudi.org.apache.http.conn.routing.HttpRoute;
import io.hops.hudi.org.apache.http.impl.client.BasicCredentialsProvider;
import io.hops.hudi.org.apache.http.impl.execchain.ClientExecChain;
import io.hops.hudi.org.apache.http.params.HttpParams;
import io.hops.hudi.org.apache.http.protocol.HttpContext;
import io.hops.hudi.org.apache.http.protocol.HttpProcessor;
import io.hops.hudi.org.apache.http.util.Args;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Immutable
public class ProtocolExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final HttpProcessor httpProcessor;

    public ProtocolExec(ClientExecChain requestExecutor, HttpProcessor httpProcessor) {
        Args.notNull(requestExecutor, "HTTP client request executor");
        Args.notNull(httpProcessor, "HTTP protocol processor");
        this.requestExecutor = requestExecutor;
        this.httpProcessor = httpProcessor;
    }

    void rewriteRequestURI(HttpRequestWrapper request, HttpRoute route) throws ProtocolException {
        URI uri2 = request.getURI();
        if (uri2 != null) {
            try {
                request.setURI(URIUtils.rewriteURIForRoute(uri2, route));
            }
            catch (URISyntaxException ex) {
                throw new ProtocolException("Invalid URI: " + uri2, ex);
            }
        }
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        String userinfo;
        URI uri2;
        block18: {
            Args.notNull(route, "HTTP route");
            Args.notNull(request, "HTTP request");
            Args.notNull(context, "HTTP context");
            HttpRequest original = request.getOriginal();
            uri2 = null;
            if (original instanceof HttpUriRequest) {
                uri2 = ((HttpUriRequest)original).getURI();
            } else {
                String uriString = original.getRequestLine().getUri();
                try {
                    uri2 = URI.create(uriString);
                }
                catch (IllegalArgumentException ex) {
                    if (!this.log.isDebugEnabled()) break block18;
                    this.log.debug((Object)("Unable to parse '" + uriString + "' as a valid URI; " + "request URI and Host header may be inconsistent"), (Throwable)ex);
                }
            }
        }
        request.setURI(uri2);
        this.rewriteRequestURI(request, route);
        HttpParams params = request.getParams();
        HttpHost virtualHost = (HttpHost)params.getParameter("http.virtual-host");
        if (virtualHost != null && virtualHost.getPort() == -1) {
            int port = route.getTargetHost().getPort();
            if (port != -1) {
                virtualHost = new HttpHost(virtualHost.getHostName(), port, virtualHost.getSchemeName());
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Using virtual host" + virtualHost));
            }
        }
        HttpHost target = null;
        if (virtualHost != null) {
            target = virtualHost;
        } else if (uri2 != null && uri2.isAbsolute() && uri2.getHost() != null) {
            target = new HttpHost(uri2.getHost(), uri2.getPort(), uri2.getScheme());
        }
        if (target == null) {
            target = request.getTarget();
        }
        if (target == null) {
            target = route.getTargetHost();
        }
        if (uri2 != null && (userinfo = uri2.getUserInfo()) != null) {
            CredentialsProvider credsProvider = context.getCredentialsProvider();
            if (credsProvider == null) {
                credsProvider = new BasicCredentialsProvider();
                context.setCredentialsProvider(credsProvider);
            }
            credsProvider.setCredentials(new AuthScope(target), new UsernamePasswordCredentials(userinfo));
        }
        context.setAttribute("http.target_host", target);
        context.setAttribute("http.route", route);
        context.setAttribute("http.request", request);
        this.httpProcessor.process(request, (HttpContext)context);
        CloseableHttpResponse response = this.requestExecutor.execute(route, request, context, execAware);
        try {
            context.setAttribute("http.response", response);
            this.httpProcessor.process(response, (HttpContext)context);
            return response;
        }
        catch (RuntimeException ex) {
            response.close();
            throw ex;
        }
        catch (IOException ex) {
            response.close();
            throw ex;
        }
        catch (HttpException ex) {
            response.close();
            throw ex;
        }
    }
}

