/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.http.impl.pool;

import io.hops.hudi.org.apache.http.HttpClientConnection;
import io.hops.hudi.org.apache.http.HttpHost;
import io.hops.hudi.org.apache.http.annotation.ThreadSafe;
import io.hops.hudi.org.apache.http.config.ConnectionConfig;
import io.hops.hudi.org.apache.http.config.SocketConfig;
import io.hops.hudi.org.apache.http.impl.pool.BasicConnFactory;
import io.hops.hudi.org.apache.http.impl.pool.BasicPoolEntry;
import io.hops.hudi.org.apache.http.params.HttpParams;
import io.hops.hudi.org.apache.http.pool.AbstractConnPool;
import io.hops.hudi.org.apache.http.pool.ConnFactory;
import java.util.concurrent.atomic.AtomicLong;

@ThreadSafe
public class BasicConnPool
extends AbstractConnPool<HttpHost, HttpClientConnection, BasicPoolEntry> {
    private static final AtomicLong COUNTER = new AtomicLong();

    public BasicConnPool(ConnFactory<HttpHost, HttpClientConnection> connFactory) {
        super(connFactory, 2, 20);
    }

    @Deprecated
    public BasicConnPool(HttpParams params) {
        super(new BasicConnFactory(params), 2, 20);
    }

    public BasicConnPool(SocketConfig sconfig, ConnectionConfig cconfig) {
        super(new BasicConnFactory(sconfig, cconfig), 2, 20);
    }

    public BasicConnPool() {
        super(new BasicConnFactory(SocketConfig.DEFAULT, ConnectionConfig.DEFAULT), 2, 20);
    }

    @Override
    protected BasicPoolEntry createEntry(HttpHost host2, HttpClientConnection conn) {
        return new BasicPoolEntry(Long.toString(COUNTER.getAndIncrement()), host2, conn);
    }

    @Override
    protected boolean validate(BasicPoolEntry entry) {
        return !((HttpClientConnection)entry.getConnection()).isStale();
    }
}

