/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.eclipse.jetty.server.session;

import io.hops.hudi.org.eclipse.jetty.server.session.AbstractSessionCacheFactory;
import io.hops.hudi.org.eclipse.jetty.server.session.NullSessionCache;
import io.hops.hudi.org.eclipse.jetty.server.session.SessionCache;
import io.hops.hudi.org.eclipse.jetty.server.session.SessionHandler;
import io.hops.hudi.org.eclipse.jetty.util.log.Log;
import io.hops.hudi.org.eclipse.jetty.util.log.Logger;

public class NullSessionCacheFactory
extends AbstractSessionCacheFactory {
    private static final Logger LOG = Log.getLogger("io.hops.hudi.org.eclipse.jetty.server.session");

    @Override
    public int getEvictionPolicy() {
        return 0;
    }

    @Override
    public void setEvictionPolicy(int evictionPolicy) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ignoring eviction policy setting for NullSessionCaches", new Object[0]);
        }
    }

    @Override
    public boolean isSaveOnInactiveEvict() {
        return false;
    }

    @Override
    public void setSaveOnInactiveEvict(boolean saveOnInactiveEvict) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ignoring eviction policy setting for NullSessionCaches", new Object[0]);
        }
    }

    @Override
    public boolean isInvalidateOnShutdown() {
        return false;
    }

    @Override
    public void setInvalidateOnShutdown(boolean invalidateOnShutdown) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ignoring invalidateOnShutdown setting for NullSessionCaches", new Object[0]);
        }
    }

    @Override
    public SessionCache newSessionCache(SessionHandler handler) {
        return new NullSessionCache(handler);
    }
}

