/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.openjdk.jol.layouters;

import io.hops.hudi.org.openjdk.jol.datamodel.DataModel;
import io.hops.hudi.org.openjdk.jol.datamodel.ModelVM;
import io.hops.hudi.org.openjdk.jol.info.ClassData;
import io.hops.hudi.org.openjdk.jol.info.ClassLayout;
import io.hops.hudi.org.openjdk.jol.info.FieldData;
import io.hops.hudi.org.openjdk.jol.info.FieldLayout;
import io.hops.hudi.org.openjdk.jol.layouters.Layouter;
import io.hops.hudi.org.openjdk.jol.util.MathUtil;
import io.hops.hudi.org.openjdk.jol.vm.VM;
import io.hops.hudi.org.openjdk.jol.vm.VirtualMachine;
import java.util.List;
import java.util.TreeSet;

public class CurrentLayouter
implements Layouter {
    static final DataModel CURRENT = new ModelVM();

    @Override
    public ClassLayout layout(ClassData data) {
        long instanceSize;
        VirtualMachine vm = VM.current();
        if (data.isArray()) {
            int base = vm.arrayBaseOffset(data.arrayComponentType());
            int scale = vm.arrayIndexScale(data.arrayComponentType());
            long instanceSize2 = MathUtil.align((long)base + data.arrayLength() * (long)scale, vm.objectAlignment());
            TreeSet<FieldLayout> result = new TreeSet<FieldLayout>();
            result.add(new FieldLayout(FieldData.create(data.arrayClass(), "<elements>", data.arrayComponentType()), base, (long)scale * data.arrayLength()));
            return ClassLayout.create(data, result, CURRENT, instanceSize2, false);
        }
        List<FieldData> fields = data.fields();
        TreeSet<FieldLayout> result = new TreeSet<FieldLayout>();
        for (FieldData f : fields) {
            result.add(new FieldLayout(f, vm.fieldOffset(f.refField()), vm.sizeOfField(f.typeClass())));
        }
        if (result.isEmpty()) {
            instanceSize = vm.objectHeaderSize();
        } else {
            FieldLayout f = (FieldLayout)result.last();
            instanceSize = f.offset() + f.size();
        }
        instanceSize = MathUtil.align(instanceSize, vm.objectAlignment());
        return ClassLayout.create(data, result, CURRENT, instanceSize, true);
    }

    public String toString() {
        return "Current VM Layout";
    }
}

