/*
 * Decompiled with CFR 0.152.
 */
package org.I0Itec.zkclient;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.I0Itec.zkclient.IZkConnection;
import org.I0Itec.zkclient.exception.ZkException;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkConnection
implements IZkConnection {
    private static final Logger LOG = LoggerFactory.getLogger(ZkConnection.class);
    private static final int DEFAULT_SESSION_TIMEOUT = 30000;
    private ZooKeeper _zk = null;
    private Lock _zookeeperLock = new ReentrantLock();
    private final String _servers;
    private final int _sessionTimeOut;

    public ZkConnection(String zkServers) {
        this(zkServers, 30000);
    }

    public ZkConnection(String zkServers, int sessionTimeOut) {
        this._servers = zkServers;
        this._sessionTimeOut = sessionTimeOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(Watcher watcher) {
        this._zookeeperLock.lock();
        try {
            if (this._zk != null) {
                throw new IllegalStateException("zk client has already been started");
            }
            try {
                LOG.debug("Creating new ZookKeeper instance to connect to " + this._servers + ".");
                this._zk = new ZooKeeper(this._servers, this._sessionTimeOut, watcher);
            }
            catch (IOException e) {
                throw new ZkException("Unable to connect to " + this._servers, e);
            }
        }
        finally {
            this._zookeeperLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws InterruptedException {
        this._zookeeperLock.lock();
        try {
            if (this._zk != null) {
                LOG.debug("Closing ZooKeeper connected to " + this._servers);
                this._zk.close();
                this._zk = null;
            }
        }
        finally {
            this._zookeeperLock.unlock();
        }
    }

    @Override
    public String create(String path, byte[] data, CreateMode mode) throws KeeperException, InterruptedException {
        return this._zk.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, mode);
    }

    @Override
    public String create(String path, byte[] data, List<ACL> acl, CreateMode mode) throws KeeperException, InterruptedException {
        return this._zk.create(path, data, acl, mode);
    }

    @Override
    public void delete(String path) throws InterruptedException, KeeperException {
        this._zk.delete(path, -1);
    }

    @Override
    public void delete(String path, int version) throws InterruptedException, KeeperException {
        this._zk.delete(path, version);
    }

    @Override
    public boolean exists(String path, boolean watch) throws KeeperException, InterruptedException {
        return this._zk.exists(path, watch) != null;
    }

    @Override
    public List<String> getChildren(String path, boolean watch) throws KeeperException, InterruptedException {
        return this._zk.getChildren(path, watch);
    }

    @Override
    public byte[] readData(String path, Stat stat, boolean watch) throws KeeperException, InterruptedException {
        return this._zk.getData(path, watch, stat);
    }

    public void writeData(String path, byte[] data) throws KeeperException, InterruptedException {
        this.writeData(path, data, -1);
    }

    @Override
    public void writeData(String path, byte[] data, int version) throws KeeperException, InterruptedException {
        this._zk.setData(path, data, version);
    }

    @Override
    public Stat writeDataReturnStat(String path, byte[] data, int version) throws KeeperException, InterruptedException {
        return this._zk.setData(path, data, version);
    }

    @Override
    public ZooKeeper.States getZookeeperState() {
        return this._zk != null ? this._zk.getState() : null;
    }

    public ZooKeeper getZookeeper() {
        return this._zk;
    }

    @Override
    public long getCreateTime(String path) throws KeeperException, InterruptedException {
        Stat stat = this._zk.exists(path, false);
        if (stat != null) {
            return stat.getCtime();
        }
        return -1L;
    }

    @Override
    public String getServers() {
        return this._servers;
    }

    @Override
    public List<OpResult> multi(Iterable<Op> ops) throws KeeperException, InterruptedException {
        return this._zk.multi(ops);
    }

    @Override
    public void addAuthInfo(String scheme2, byte[] auth) {
        this._zk.addAuthInfo(scheme2, auth);
    }

    @Override
    public void setAcl(String path, List<ACL> acl, int version) throws KeeperException, InterruptedException {
        this._zk.setACL(path, acl, version);
    }

    @Override
    public Map.Entry<List<ACL>, Stat> getAcl(String path) throws KeeperException, InterruptedException {
        Stat stat = new Stat();
        List acl = this._zk.getACL(path, stat);
        return new AbstractMap.SimpleEntry<List<ACL>, Stat>(acl, stat);
    }
}

