/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordGlobalLocation;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.util.JFunction$;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.Literal;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001\u0002\b\u0010\u0001YA\u0001\"\b\u0001\u0003\u0002\u0003\u0006IA\b\u0005\tK\u0001\u0011\t\u0011)A\u0005M!Aa\u0006\u0001B\u0001B\u0003%q\u0006C\u00036\u0001\u0011\u0005a\u0007\u0003\u0005=\u0001!\u0015\r\u0011\"\u0003>\u0011!I\u0005\u0001#b\u0001\n\u0013Q\u0005\"\u0002*\u0001\t\u0003\u0019\u0006\"\u0002>\u0001\t\u0013Y\bBB@\u0001\t\u0013\t\t\u0001C\u0004\u0002\u000e\u0001!I!a\u0004\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@!9\u00111\n\u0001\u0005\n\u00055\u0003bBA,\u0001\u0011\u0005\u0011\u0011\f\u0002\u0018%\u0016\u001cwN\u001d3MKZ,G.\u00138eKb\u001cV\u000f\u001d9peRT!\u0001E\t\u0002\t!,H-\u001b\u0006\u0003%M\ta!\u00199bG\",'\"\u0001\u000b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u00019\u0002C\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"AB!osJ+g-A\u0003ta\u0006\u00148\u000e\u0005\u0002 G5\t\u0001E\u0003\u0002\"E\u0005\u00191/\u001d7\u000b\u0005u\t\u0012B\u0001\u0013!\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u00039iW\r^1eCR\f7i\u001c8gS\u001e\u0004\"a\n\u0017\u000e\u0003!R!!\u000b\u0016\u0002\r\r|gNZ5h\u0015\tYs\"\u0001\u0004d_6lwN\\\u0005\u0003[!\u0012A\u0003S8pI&,W*\u001a;bI\u0006$\u0018mQ8oM&<\u0017AC7fi\u0006\u001cE.[3oiB\u0011\u0001gM\u0007\u0002c)\u0011!GK\u0001\u0006i\u0006\u0014G.Z\u0005\u0003iE\u0012Q\u0003S8pI&,G+\u00192mK6+G/Y\"mS\u0016tG/\u0001\u0004=S:LGO\u0010\u000b\u0005oeR4\b\u0005\u00029\u00015\tq\u0002C\u0003\u001e\t\u0001\u0007a\u0004C\u0003&\t\u0001\u0007a\u0005C\u0003/\t\u0001\u0007q&A\u0005f]\u001eLg.Z\"uqV\ta\b\u0005\u0002@\u00076\t\u0001I\u0003\u0002,\u0003*\u0011!iD\u0001\u0007G2LWM\u001c;\n\u0005\u0011\u0003%\u0001\u0007%p_\u0012LWm\u00159be.,enZ5oK\u000e{g\u000e^3yi\"\u0012QA\u0012\t\u00031\u001dK!\u0001S\r\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018!D7fi\u0006$\u0017\r^1UC\ndW-F\u0001L!\tau*D\u0001N\u0015\tqu\"\u0001\u0005nKR\fG-\u0019;b\u0013\t\u0001VJA\nI_>$\u0017.\u001a+bE2,W*\u001a;bI\u0006$\u0018\r\u000b\u0002\u0007\r\u0006\tr-\u001a;DC:$\u0017\u000eZ1uK\u001aKG.Z:\u0015\u0007Q\u0013W\u000fE\u0002V9~s!A\u0016.\u0011\u0005]KR\"\u0001-\u000b\u0005e+\u0012A\u0002\u001fs_>$h(\u0003\u0002\\3\u00051\u0001K]3eK\u001aL!!\u00180\u0003\u0007M+GO\u0003\u0002\\3A\u0011Q\u000bY\u0005\u0003Cz\u0013aa\u0015;sS:<\u0007\"B2\b\u0001\u0004!\u0017\u0001C1mY\u001aKG.Z:\u0011\u0007\u0015TWN\u0004\u0002gQ:\u0011qkZ\u0005\u00025%\u0011\u0011.G\u0001\ba\u0006\u001c7.Y4f\u0013\tYGNA\u0002TKFT!![\r\u0011\u00059\u001cX\"A8\u000b\u0005A\f\u0018A\u00014t\u0015\t\u0011\u0018#\u0001\u0004iC\u0012|w\u000e]\u0005\u0003i>\u0014!BR5mKN#\u0018\r^;t\u0011\u00151x\u00011\u0001x\u0003)\u0011XmY8sI.+\u0017p\u001d\t\u0004Kb|\u0016BA=m\u0005\u0011a\u0015n\u001d;\u0002%\u001d,GOU3d_J$7*Z=D_:4\u0017nZ\u000b\u0002yB\u0019\u0001$`0\n\u0005yL\"AB(qi&|g.A\rbiR\u0014\u0018NY;uK6\u000bGo\u00195fgJ+7m\u001c:e\u0017\u0016LH\u0003BA\u0002\u0003\u0013\u00012\u0001GA\u0003\u0013\r\t9!\u0007\u0002\b\u0005>|G.Z1o\u0011\u0019\tY!\u0003a\u0001?\u0006i\u0011\r\u001e;sS\n,H/\u001a(b[\u0016\f\u0001dZ3u\u0003R$(/\u001b2vi\u0016d\u0015\u000e^3sC2$V\u000f\u001d7f)\u0019\t\t\"a\f\u0002:A!\u0001$`A\n!\u001dA\u0012QCA\r\u0003SI1!a\u0006\u001a\u0005\u0019!V\u000f\u001d7feA!\u00111DA\u0013\u001b\t\tiB\u0003\u0003\u0002 \u0005\u0005\u0012aC3yaJ,7o]5p]NT1!a\t!\u0003!\u0019\u0017\r^1msN$\u0018\u0002BA\u0014\u0003;\u0011!#\u0011;ue&\u0014W\u000f^3SK\u001a,'/\u001a8dKB!\u00111DA\u0016\u0013\u0011\ti#!\b\u0003\u000f1KG/\u001a:bY\"9\u0011\u0011\u0007\u0006A\u0002\u0005M\u0012aC3yaJ,7o]5p]F\u0002B!a\u0007\u00026%!\u0011qGA\u000f\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\b\u0003wQ\u0001\u0019AA\u001a\u0003-)\u0007\u0010\u001d:fgNLwN\u001c\u001a\u00025\u0019LG\u000e^3s#V,'/[3t/&$\bNU3d_J$7*Z=\u0015\t\u0005\u0005\u0013Q\t\t\u00071\u0005U\u00111I<\u0011\t\u0015D\u00181\u0007\u0005\b\u0003\u000fZ\u0001\u0019AA%\u00031\tX/\u001a:z\r&dG/\u001a:t!\u0011)'.a\r\u00021\u0019LG\u000e^3s#V,'/_,ji\"\u0014VmY8sI.+\u0017\u0010\u0006\u0003\u0002P\u0005M\u0003\u0003\u0002\r~\u0003#\u0002b\u0001GA\u000b\u0003g9\bbBA+\u0019\u0001\u0007\u00111G\u0001\fcV,'/\u001f$jYR,'/\u0001\tjg&sG-\u001a=Bm\u0006LG.\u00192mKV\u0011\u00111\u0001")
public class RecordLevelIndexSupport {
    private transient HoodieSparkEngineContext engineCtx;
    private transient HoodieTableMetadata metadataTable;
    private final SparkSession spark;
    private final HoodieMetadataConfig metadataConfig;
    private final HoodieTableMetaClient metaClient;
    private volatile transient byte bitmap$trans$0;

    private HoodieSparkEngineContext engineCtx$lzycompute() {
        RecordLevelIndexSupport recordLevelIndexSupport = this;
        synchronized (recordLevelIndexSupport) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.engineCtx = new HoodieSparkEngineContext(new JavaSparkContext(this.spark.sparkContext()));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.engineCtx;
    }

    private HoodieSparkEngineContext engineCtx() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.engineCtx$lzycompute() : this.engineCtx;
    }

    private HoodieTableMetadata metadataTable$lzycompute() {
        RecordLevelIndexSupport recordLevelIndexSupport = this;
        synchronized (recordLevelIndexSupport) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.metadataTable = HoodieTableMetadata.create(this.engineCtx(), this.metadataConfig, this.metaClient.getBasePathV2().toString());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.metadataTable;
    }

    private HoodieTableMetadata metadataTable() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.metadataTable$lzycompute() : this.metadataTable;
    }

    public scala.collection.immutable.Set<String> getCandidateFiles(Seq<FileStatus> allFiles, List<String> recordKeys) {
        java.util.Map<String, HoodieRecordGlobalLocation> recordKeyLocationsMap = this.metadataTable().readRecordIndex((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(recordKeys).asJava());
        Map fileIdToPartitionMap = Map$.MODULE$.empty();
        Set candidateFiles = Set$.MODULE$.empty();
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(recordKeyLocationsMap.values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)location -> fileIdToPartitionMap.put((Object)location.getFileId(), (Object)location.getPartitionPath()));
        allFiles.foreach((Function1 & Serializable & scala.Serializable)file -> {
            String fileId = FSUtils.getFileIdFromFilePath(file.getPath());
            scala.Option partitionOpt = fileIdToPartitionMap.get((Object)fileId);
            return partitionOpt.isDefined() ? candidateFiles.$plus$eq((Object)file.getPath().getName()) : BoxedUnit.UNIT;
        });
        return candidateFiles.toSet();
    }

    private scala.Option<String> getRecordKeyConfig() {
        Option<String[]> recordKeysOpt = this.metaClient.getTableConfig().getRecordKeyFields();
        Option recordKeyOpt = recordKeysOpt.map(JFunction$.MODULE$.toJavaFunction((Function1 & Serializable & scala.Serializable)arr -> ((String[])arr).length == 1 ? arr[0] : null));
        return Option$.MODULE$.apply(recordKeyOpt.orElse(null));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean attributeMatchesRecordKey(String attributeName) {
        scala.Option<String> recordKeyOpt = this.getRecordKeyConfig();
        if (recordKeyOpt.isDefined()) {
            Object object = recordKeyOpt.get();
            String string = attributeName;
            if (object == null) {
                if (string == null) return true;
            } else if (object.equals(string)) {
                return true;
            }
        }
        String string = HoodieRecord.HoodieMetadataField.RECORD_KEY_METADATA_FIELD.getFieldName();
        Object object = recordKeyOpt.get();
        if (string != null) {
            if (!string.equals(object)) return false;
            return true;
        }
        if (object == null) return true;
        return false;
    }

    private scala.Option<Tuple2<AttributeReference, Literal>> getAttributeLiteralTuple(Expression expression1, Expression expression2) {
        scala.Option option;
        Expression expression = expression1;
        if (expression instanceof AttributeReference) {
            scala.Option option2;
            AttributeReference attributeReference = (AttributeReference)expression;
            Expression expression3 = expression2;
            if (expression3 instanceof Literal) {
                Literal literal = (Literal)expression3;
                option2 = Option$.MODULE$.apply((Object)new Tuple2((Object)attributeReference, (Object)literal));
            } else {
                option2 = Option$.MODULE$.empty();
            }
            option = option2;
        } else if (expression instanceof Literal) {
            scala.Option option3;
            Literal literal = (Literal)expression;
            Expression expression4 = expression2;
            if (expression4 instanceof AttributeReference) {
                AttributeReference attributeReference = (AttributeReference)expression4;
                option3 = Option$.MODULE$.apply((Object)new Tuple2((Object)attributeReference, (Object)literal));
            } else {
                option3 = Option$.MODULE$.empty();
            }
            option = option3;
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public Tuple2<List<Expression>, List<String>> filterQueriesWithRecordKey(Seq<Expression> queryFilters) {
        Tuple2 tuple2;
        if (!this.isIndexAvailable()) {
            tuple2 = new Tuple2((Object)List$.MODULE$.empty(), (Object)List$.MODULE$.empty());
        } else {
            ObjectRef recordKeyQueries = ObjectRef.create((Object)List$.MODULE$.empty());
            ObjectRef recordKeys = ObjectRef.create((Object)List$.MODULE$.empty());
            queryFilters.foreach((Function1 & Serializable & scala.Serializable)query -> {
                RecordLevelIndexSupport.$anonfun$filterQueriesWithRecordKey$1(this, recordKeys, recordKeyQueries, query);
                return BoxedUnit.UNIT;
            });
            tuple2 = new Tuple2((Object)((List)recordKeyQueries.elem), (Object)((List)recordKeys.elem));
        }
        return tuple2;
    }

    private scala.Option<Tuple2<Expression, List<String>>> filterQueryWithRecordKey(Expression queryFilter) {
        scala.Option option;
        Expression expression = queryFilter;
        if (expression instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)expression;
            Tuple2 tuple2 = (Tuple2)this.getAttributeLiteralTuple(equalTo.left(), equalTo.right()).orNull(Predef$.MODULE$.$conforms());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            AttributeReference attribute = (AttributeReference)tuple2._1();
            Literal literal = (Literal)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)attribute, (Object)literal);
            Tuple2 tuple23 = tuple22;
            AttributeReference attribute2 = (AttributeReference)tuple23._1();
            Literal literal2 = (Literal)tuple23._2();
            option = attribute2 != null && attribute2.name() != null && this.attributeMatchesRecordKey(attribute2.name()) ? Option$.MODULE$.apply((Object)new Tuple2((Object)equalTo, (Object)new .colon.colon((Object)literal2.value().toString(), (List)Nil$.MODULE$))) : Option$.MODULE$.empty();
        } else if (expression instanceof In) {
            In in = (In)expression;
            BooleanRef validINQuery = BooleanRef.create((boolean)true);
            Expression expression2 = in.value();
            if (expression2 instanceof AttributeReference) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                validINQuery.elem = false;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            ObjectRef literals = ObjectRef.create((Object)List$.MODULE$.empty());
            in.list().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                RecordLevelIndexSupport.$anonfun$filterQueryWithRecordKey$1(literals, validINQuery, x0$1);
                return BoxedUnit.UNIT;
            });
            option = validINQuery.elem ? Option$.MODULE$.apply((Object)new Tuple2((Object)in, (Object)((List)literals.elem))) : Option$.MODULE$.empty();
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public boolean isIndexAvailable() {
        return this.metadataConfig.enabled() && this.metaClient.getTableConfig().getMetadataPartitions().contains("record_index");
    }

    public static final /* synthetic */ void $anonfun$filterQueriesWithRecordKey$2(ObjectRef recordKeys$1, ObjectRef recordKeyQueries$1, Tuple2 x0$1) {
        Expression expression;
        List recKeys;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x0$1;
                if (tuple2 == null) break block2;
                Expression exp = (Expression)tuple2._1();
                recKeys = (List)tuple2._2();
                if (exp == null) break block2;
                expression = exp;
                if (recKeys != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        List list = recKeys;
        recordKeys$1.elem = (List)((List)recordKeys$1.elem).$plus$plus((GenTraversableOnce)list, List$.MODULE$.canBuildFrom());
        recordKeyQueries$1.elem = (List)((List)recordKeyQueries$1.elem).$colon$plus((Object)expression, List$.MODULE$.canBuildFrom());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$filterQueriesWithRecordKey$1(RecordLevelIndexSupport $this, ObjectRef recordKeys$1, ObjectRef recordKeyQueries$1, Expression query) {
        $this.filterQueryWithRecordKey(query).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            RecordLevelIndexSupport.$anonfun$filterQueriesWithRecordKey$2(recordKeys$1, recordKeyQueries$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$filterQueryWithRecordKey$1(ObjectRef literals$1, BooleanRef validINQuery$1, Expression x0$1) {
        Expression expression = x0$1;
        if (expression instanceof Literal) {
            Literal literal = (Literal)expression;
            literals$1.elem = (List)((List)literals$1.elem).$colon$plus((Object)literal.value().toString(), List$.MODULE$.canBuildFrom());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            validINQuery$1.elem = false;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public RecordLevelIndexSupport(SparkSession spark, HoodieMetadataConfig metadataConfig, HoodieTableMetaClient metaClient) {
        this.spark = spark;
        this.metadataConfig = metadataConfig;
        this.metaClient = metaClient;
    }
}

