/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.commit;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.HoodieDatasetBulkInsertHelper;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.commit.BaseDatasetBulkInsertCommitActionExecutor;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.data.HoodieJavaPairRDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class DatasetBulkInsertOverwriteCommitActionExecutor
extends BaseDatasetBulkInsertCommitActionExecutor {
    public DatasetBulkInsertOverwriteCommitActionExecutor(HoodieWriteConfig config, SparkRDDWriteClient writeClient, String instantTime) {
        super(config, writeClient, instantTime);
    }

    @Override
    protected Option<HoodieData<WriteStatus>> doExecute(Dataset<Row> records, boolean arePartitionRecordsSorted) {
        this.table.getActiveTimeline().transitionRequestedToInflight(new HoodieInstant(HoodieInstant.State.REQUESTED, this.getCommitActionType(), this.instantTime), Option.empty());
        return Option.of(HoodieDatasetBulkInsertHelper.bulkInsert(records, this.instantTime, this.table, this.writeConfig, arePartitionRecordsSorted, false));
    }

    @Override
    public WriteOperationType getWriteOperationType() {
        return WriteOperationType.INSERT_OVERWRITE;
    }

    @Override
    protected Map<String, List<String>> getPartitionToReplacedFileIds(HoodieData<WriteStatus> writeStatuses) {
        return HoodieJavaPairRDD.getJavaPairRDD(writeStatuses.map(status -> status.getStat().getPartitionPath()).distinct().mapToPair(partitionPath -> Pair.of(partitionPath, this.getAllExistingFileIds((String)partitionPath)))).collectAsMap();
    }

    protected List<String> getAllExistingFileIds(String partitionPath) {
        return this.table.getSliceView().getLatestFileSlices(partitionPath).map(FileSlice::getFileId).distinct().collect(Collectors.toList());
    }
}

