/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.config;

import java.util.Map;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.model.ActionType;

@Immutable
public class HoodieTableServiceManagerConfig
extends HoodieConfig {
    public static final String TABLE_SERVICE_MANAGER_PREFIX = "hoodie.table.service.manager";
    public static final ConfigProperty<Boolean> TABLE_SERVICE_MANAGER_ENABLED = ConfigProperty.key("hoodie.table.service.manager.enabled").defaultValue(false).markAdvanced().sinceVersion("0.13.0").withDocumentation("If true, use table service manager to execute table service");
    public static final ConfigProperty<String> TABLE_SERVICE_MANAGER_URIS = ConfigProperty.key("hoodie.table.service.manager.uris").defaultValue("http://localhost:9091").markAdvanced().sinceVersion("0.13.0").withDocumentation("Table service manager URIs (comma-delimited).");
    public static final ConfigProperty<String> TABLE_SERVICE_MANAGER_ACTIONS = ConfigProperty.key("hoodie.table.service.manager.actions").noDefaultValue().markAdvanced().sinceVersion("0.13.0").withDocumentation("The actions deployed on table service manager, such as compaction or clean.");
    public static final ConfigProperty<String> TABLE_SERVICE_MANAGER_DEPLOY_USERNAME = ConfigProperty.key("hoodie.table.service.manager.deploy.username").defaultValue("default").markAdvanced().sinceVersion("0.13.0").withDocumentation("The user name for this table to deploy table services.");
    public static final ConfigProperty<String> TABLE_SERVICE_MANAGER_DEPLOY_QUEUE = ConfigProperty.key("hoodie.table.service.manager.deploy.queue").defaultValue("default").markAdvanced().sinceVersion("0.13.0").withDocumentation("The queue for this table to deploy table services.");
    public static final ConfigProperty<String> TABLE_SERVICE_MANAGER_DEPLOY_RESOURCES = ConfigProperty.key("hoodie.table.service.manager.deploy.resources").defaultValue("spark:4g,4g").markAdvanced().sinceVersion("0.13.0").withDocumentation("The resources for this table to use for deploying table services.");
    public static final ConfigProperty<Integer> TABLE_SERVICE_MANAGER_DEPLOY_PARALLELISM = ConfigProperty.key("hoodie.table.service.manager.deploy.parallelism").defaultValue(100).markAdvanced().sinceVersion("0.13.0").withDocumentation("The parallelism for this table to deploy table services.");
    public static final ConfigProperty<String> TABLE_SERVICE_MANAGER_DEPLOY_EXECUTION_ENGINE = ConfigProperty.key("hoodie.table.service.manager.execution.engine").defaultValue("spark").markAdvanced().sinceVersion("0.13.0").withDocumentation("The execution engine to deploy for table service of this table, default spark");
    public static final ConfigProperty<String> TABLE_SERVICE_MANAGER_DEPLOY_EXTRA_PARAMS = ConfigProperty.key("hoodie.table.service.manager.deploy.extra.params").noDefaultValue().markAdvanced().sinceVersion("0.13.0").withDocumentation("The extra params to deploy for table service of this table, split by ';'");
    public static final ConfigProperty<Integer> TABLE_SERVICE_MANAGER_TIMEOUT_SEC = ConfigProperty.key("hoodie.table.service.manager.connection.timeout.sec").defaultValue(300).markAdvanced().sinceVersion("0.13.0").withDocumentation("Timeout in seconds for connections to table service manager.");
    public static final ConfigProperty<Integer> TABLE_SERVICE_MANAGER_RETRIES = ConfigProperty.key("hoodie.table.service.manager.connection.retries").defaultValue(3).markAdvanced().sinceVersion("0.13.0").withDocumentation("Number of retries while opening a connection to table service manager");
    public static final ConfigProperty<Integer> TABLE_SERVICE_MANAGER_RETRY_DELAY_SEC = ConfigProperty.key("hoodie.table.service.manager.connection.retry.delay.sec").defaultValue(1).markAdvanced().sinceVersion("0.13.0").withDocumentation("Number of seconds for the client to wait between consecutive connection attempts");

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean isTableServiceManagerEnabled() {
        return this.getBoolean(TABLE_SERVICE_MANAGER_ENABLED);
    }

    public String getTableServiceManagerURIs() {
        return this.getStringOrDefault(TABLE_SERVICE_MANAGER_URIS);
    }

    public String getTableServiceManagerActions() {
        return this.getStringOrDefault(TABLE_SERVICE_MANAGER_ACTIONS);
    }

    public String getDeployUsername() {
        return this.getStringOrDefault(TABLE_SERVICE_MANAGER_DEPLOY_USERNAME);
    }

    public String getDeployQueue() {
        return this.getStringOrDefault(TABLE_SERVICE_MANAGER_DEPLOY_QUEUE);
    }

    public String getDeployResources() {
        return this.getStringOrDefault(TABLE_SERVICE_MANAGER_DEPLOY_RESOURCES);
    }

    public int getDeployParallelism() {
        return this.getIntOrDefault(TABLE_SERVICE_MANAGER_DEPLOY_PARALLELISM);
    }

    public String getDeployExtraParams() {
        return this.getStringOrDefault(TABLE_SERVICE_MANAGER_DEPLOY_EXTRA_PARAMS);
    }

    public String getDeployExecutionEngine() {
        return this.getStringOrDefault(TABLE_SERVICE_MANAGER_DEPLOY_EXECUTION_ENGINE);
    }

    public int getConnectionTimeoutSec() {
        return this.getIntOrDefault(TABLE_SERVICE_MANAGER_TIMEOUT_SEC);
    }

    public int getConnectionRetryLimit() {
        return this.getIntOrDefault(TABLE_SERVICE_MANAGER_RETRIES);
    }

    public int getConnectionRetryDelay() {
        return this.getIntOrDefault(TABLE_SERVICE_MANAGER_RETRY_DELAY_SEC);
    }

    public boolean isEnabledAndActionSupported(ActionType actionType) {
        return this.isTableServiceManagerEnabled() && this.getTableServiceManagerActions().contains(actionType.name());
    }

    public static class Builder {
        private final HoodieTableServiceManagerConfig config = new HoodieTableServiceManagerConfig();

        public Builder fromProperties(Properties props) {
            this.config.getProps().putAll((Map<?, ?>)props);
            return this;
        }

        public Builder setURIs(String uris) {
            this.config.setValue(TABLE_SERVICE_MANAGER_URIS, uris);
            return this;
        }

        public HoodieTableServiceManagerConfig build() {
            this.config.setDefaults(HoodieTableServiceManagerConfig.class.getName());
            return this.config;
        }
    }
}

