/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;
import org.apache.hudi.common.fs.ConsistencyGuard;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.fs.NoOpConsistencyGuard;
import org.apache.hudi.common.fs.SizeAwareFSDataOutputStream;
import org.apache.hudi.common.fs.StorageSchemes;
import org.apache.hudi.common.fs.TimedFSDataInputStream;
import org.apache.hudi.common.metrics.Registry;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.hadoop.CachingPath;

public class HoodieWrapperFileSystem
extends FileSystem {
    public static final String HOODIE_SCHEME_PREFIX = "hoodie-";
    private static final String TMP_PATH_POSTFIX = ".tmp";
    private static Registry METRICS_REGISTRY_DATA;
    private static Registry METRICS_REGISTRY_META;
    private ConcurrentMap<String, SizeAwareFSDataOutputStream> openStreams = new ConcurrentHashMap<String, SizeAwareFSDataOutputStream>();
    private FileSystem fileSystem;
    private URI uri;
    private ConsistencyGuard consistencyGuard = new NoOpConsistencyGuard();

    public static void setMetricsRegistry(Registry registry, Registry registryMeta) {
        METRICS_REGISTRY_DATA = registry;
        METRICS_REGISTRY_META = registryMeta;
    }

    private static Registry getMetricRegistryForPath(Path p) {
        return p != null && p.toString().contains(".hoodie") ? METRICS_REGISTRY_META : METRICS_REGISTRY_DATA;
    }

    protected static <R> R executeFuncWithTimeMetrics(String metricName, Path p, CheckedFunction<R> func) throws IOException {
        HoodieTimer timer = HoodieTimer.start();
        R res = func.get();
        Registry registry = HoodieWrapperFileSystem.getMetricRegistryForPath(p);
        if (registry != null) {
            registry.increment(metricName);
            registry.add(metricName + ".totalDuration", timer.endTimer());
        }
        return res;
    }

    protected static <R> R executeFuncWithTimeAndByteMetrics(String metricName, Path p, long byteCount, CheckedFunction<R> func) throws IOException {
        Registry registry = HoodieWrapperFileSystem.getMetricRegistryForPath(p);
        if (registry != null) {
            registry.add(metricName + ".totalBytes", byteCount);
        }
        return HoodieWrapperFileSystem.executeFuncWithTimeMetrics(metricName, p, func);
    }

    public HoodieWrapperFileSystem() {
    }

    public HoodieWrapperFileSystem(FileSystem fileSystem2, ConsistencyGuard consistencyGuard) {
        this.fileSystem = fileSystem2;
        this.uri = fileSystem2.getUri();
        this.consistencyGuard = consistencyGuard;
    }

    public static Path convertToHoodiePath(Path file, Configuration conf) {
        String scheme2 = FSUtils.getFs(file.toString(), conf).getScheme();
        return HoodieWrapperFileSystem.convertPathWithScheme(file, HoodieWrapperFileSystem.getHoodieScheme(scheme2));
    }

    public static Path convertPathWithScheme(Path oldPath, String newScheme) {
        URI oldURI = oldPath.toUri();
        try {
            URI newURI = new URI(newScheme, oldURI.getAuthority(), oldURI.getPath(), oldURI.getQuery(), oldURI.getFragment());
            return new CachingPath(newURI);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getHoodieScheme(String scheme2) {
        if (!StorageSchemes.isSchemeSupported(scheme2)) {
            throw new IllegalArgumentException("BlockAlignedAvroParquetWriter does not support scheme " + scheme2);
        }
        String newScheme = HOODIE_SCHEME_PREFIX + scheme2;
        return newScheme;
    }

    public void initialize(URI uri2, Configuration conf) {
        Path path = new Path(uri2);
        if (path.toString().startsWith(HOODIE_SCHEME_PREFIX)) {
            path = new Path(path.toString().replace(HOODIE_SCHEME_PREFIX, ""));
            this.uri = path.toUri();
        } else {
            this.uri = uri2;
        }
        this.fileSystem = FSUtils.getFs(path.toString(), conf);
    }

    public URI getUri() {
        return this.uri;
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        return this.wrapInputStream(f, this.fileSystem.open(this.convertToDefaultPath(f), bufferSize));
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return HoodieWrapperFileSystem.executeFuncWithTimeMetrics(MetricName.create.name(), f, () -> {
            Path translatedPath = this.convertToDefaultPath(f);
            return this.wrapOutputStream(f, this.fileSystem.create(translatedPath, permission, overwrite, bufferSize, replication, blockSize, progress));
        });
    }

    private FSDataOutputStream wrapOutputStream(Path path, FSDataOutputStream fsDataOutputStream) throws IOException {
        if (fsDataOutputStream instanceof SizeAwareFSDataOutputStream) {
            return fsDataOutputStream;
        }
        SizeAwareFSDataOutputStream os = new SizeAwareFSDataOutputStream(path, fsDataOutputStream, this.consistencyGuard, () -> {
            SizeAwareFSDataOutputStream cfr_ignored_0 = (SizeAwareFSDataOutputStream)((Object)((Object)this.openStreams.remove(path.getName())));
        });
        this.openStreams.put(path.getName(), os);
        return os;
    }

    private FSDataInputStream wrapInputStream(Path path, FSDataInputStream fsDataInputStream) throws IOException {
        if (fsDataInputStream instanceof TimedFSDataInputStream) {
            return fsDataInputStream;
        }
        return new TimedFSDataInputStream(path, fsDataInputStream);
    }

    public FSDataOutputStream create(Path f, boolean overwrite) throws IOException {
        return HoodieWrapperFileSystem.executeFuncWithTimeMetrics(MetricName.create.name(), f, () -> this.wrapOutputStream(f, this.fileSystem.create(this.convertToDefaultPath(f), overwrite)));
    }

    public FSDataOutputStream create(Path f) throws IOException {
        return HoodieWrapperFileSystem.executeFuncWithTimeMetrics(MetricName.create.name(), f, () -> this.wrapOutputStream(f, this.fileSystem.create(this.convertToDefaultPath(f))));
    }

    public FSDataOutputStream create(Path f, Progressable progress) throws IOException {
        return HoodieWrapperFileSystem.executeFuncWithTimeMetrics(MetricName.create.name(), f, () -> this.wrapOutputStream(f, this.fileSystem.create(this.convertToDefaultPath(f), progress)));
    }

    public FSDataOutputStream create(Path f, short replication) throws IOException {
        return HoodieWrapperFileSystem.executeFuncWithTimeMetrics(MetricName.create.name(), f, () -> this.wrapOutputStream(f, this.fileSystem.create(this.convertToDefaultPath(f), replication)));
    }

    public FSDataOutputStream create(Path f, short replication, Progressable progress) throws IOException {
        return HoodieWrapperFileSystem.executeFuncWithTimeMetrics(MetricName.create.name(), f, () -> this.wrapOutputStream(f, this.fileSystem.create(this.convertToDefaultPath(f), replication, progress)));
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize) throws IOException {
        return HoodieWrapperFileSystem.executeFuncWithTimeMetrics(MetricName.create.name(), f, () -> this.wrapOutputStream(f, this.fileSystem.create(this.convertToDefaultPath(f), overwrite, bufferSize)));
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, Progressable progress) throws IOException {
        return HoodieWrapperFileSystem.executeFuncWithTimeMetrics(MetricName.create.name(), f, () -> this.wrapOutputStream(f, this.fileSystem.create(this.convertToDefaultPath(f), overwrite, bufferSize, progress)));
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return HoodieWrapperFileSystem.executeFuncWithTimeMetrics(MetricName.create.name(), f, () -> this.wrapOutputStream(f, this.fileSystem.create(this.convertToDefaultPath(f), overwrite, bufferSize, replication, blockSize, progress)));
    }

    public FSDataOutputStream create(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return HoodieWrapperFileSystem.executeFuncWithTimeMetrics(MetricName.create.name(), f, () -> this.wrapOutputStream(f, this.fileSystem.create(this.convertToDefaultPath(f), permission, flags, bufferSize, replication, blockSize, progress)));
    }

    public FSDataOutputStream create(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt) throws IOException {
        return HoodieWrapperFileSystem.executeFuncWithTimeMetrics(MetricName.create.name(), f, () -> this.wrapOutputStream(f, this.fileSystem.create(this.convertToDefaultPath(f), permission, flags, bufferSize, replication, blockSize, progress, checksumOpt)));
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize) throws IOException {
        return HoodieWrapperFileSystem.executeFuncWithTimeMetrics(MetricName.create.name(), f, () -> this.wrapOutputStream(f, this.fileSystem.create(this.convertToDefaultPath(f), overwrite, bufferSize, replication, blockSize)));
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        return this.wrapOutputStream(f, this.fileSystem.append(this.convertToDefaultPath(f), bufferSize, progress));
    }

    public boolean rename(Path src, Path dst) throws IOException {
        return HoodieWrapperFileSystem.executeFuncWithTimeMetrics(MetricName.rename.name(), src, () -> {
            try {
                this.consistencyGuard.waitTillFileAppears(this.convertToDefaultPath(src));
            }
            catch (TimeoutException e) {
                throw new HoodieException("Timed out waiting for " + src + " to appear", e);
            }
            boolean success = this.fileSystem.rename(this.convertToDefaultPath(src), this.convertToDefaultPath(dst));
            if (success) {
                try {
                    this.consistencyGuard.waitTillFileAppears(this.convertToDefaultPath(dst));
                }
                catch (TimeoutException e) {
                    throw new HoodieException("Timed out waiting for " + dst + " to appear", e);
                }
                try {
                    this.consistencyGuard.waitTillFileDisappears(this.convertToDefaultPath(src));
                }
                catch (TimeoutException e) {
                    throw new HoodieException("Timed out waiting for " + src + " to disappear", e);
                }
            }
            return success;
        });
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        return HoodieWrapperFileSystem.executeFuncWithTimeMetrics(MetricName.delete.name(), f, () -> {
            boolean success = this.fileSystem.delete(this.convertToDefaultPath(f), recursive);
            if (success) {
                try {
                    this.consistencyGuard.waitTillFileDisappears(f);
                }
                catch (TimeoutException e) {
                    throw new HoodieException("Timed out waiting for " + f + " to disappear", e);
                }
            }
            return success;
        });
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        return HoodieWrapperFileSystem.executeFuncWithTimeMetrics(MetricName.listStatus.name(), f, () -> this.fileSystem.listStatus(this.convertToDefaultPath(f)));
    }

    public Path getWorkingDirectory() {
        return this.convertToHoodiePath(this.fileSystem.getWorkingDirectory());
    }

    public void setWorkingDirectory(Path newDir) {
        this.fileSystem.setWorkingDirectory(this.convertToDefaultPath(newDir));
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        return HoodieWrapperFileSystem.executeFuncWithTimeMetrics(MetricName.mkdirs.name(), f, () -> {
            boolean success = this.fileSystem.mkdirs(this.convertToDefaultPath(f), permission);
            if (success) {
                try {
                    this.consistencyGuard.waitTillFileAppears(this.convertToDefaultPath(f));
                }
                catch (TimeoutException e) {
                    throw new HoodieException("Timed out waiting for directory " + f + " to appear", e);
                }
            }
            return success;
        });
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        return HoodieWrapperFileSystem.executeFuncWithTimeMetrics(MetricName.getFileStatus.name(), f, () -> {
            try {
                this.consistencyGuard.waitTillFileAppears(this.convertToDefaultPath(f));
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            return this.fileSystem.getFileStatus(this.convertToDefaultPath(f));
        });
    }

    public String getScheme() {
        return this.uri.getScheme();
    }

    public String getCanonicalServiceName() {
        return this.fileSystem.getCanonicalServiceName();
    }

    public String getName() {
        return this.fileSystem.getName();
    }

    public Path makeQualified(Path path) {
        return this.convertToHoodiePath(this.fileSystem.makeQualified(this.convertToDefaultPath(path)));
    }

    public Token<?> getDelegationToken(String renewer) throws IOException {
        return this.fileSystem.getDelegationToken(renewer);
    }

    public Token<?>[] addDelegationTokens(String renewer, Credentials credentials) throws IOException {
        return this.fileSystem.addDelegationTokens(renewer, credentials);
    }

    public FileSystem[] getChildFileSystems() {
        return this.fileSystem.getChildFileSystems();
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start2, long len) throws IOException {
        return this.fileSystem.getFileBlockLocations(file, start2, len);
    }

    public BlockLocation[] getFileBlockLocations(Path p, long start2, long len) throws IOException {
        return this.fileSystem.getFileBlockLocations(this.convertToDefaultPath(p), start2, len);
    }

    public FsServerDefaults getServerDefaults() throws IOException {
        return this.fileSystem.getServerDefaults();
    }

    public FsServerDefaults getServerDefaults(Path p) throws IOException {
        return this.fileSystem.getServerDefaults(this.convertToDefaultPath(p));
    }

    public Path resolvePath(Path p) throws IOException {
        return this.convertToHoodiePath(this.fileSystem.resolvePath(this.convertToDefaultPath(p)));
    }

    public FSDataInputStream open(Path f) throws IOException {
        return this.wrapInputStream(f, this.fileSystem.open(this.convertToDefaultPath(f)));
    }

    public FSDataOutputStream createNonRecursive(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        Path p = this.convertToDefaultPath(f);
        return this.wrapOutputStream(p, this.fileSystem.createNonRecursive(p, overwrite, bufferSize, replication, blockSize, progress));
    }

    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        Path p = this.convertToDefaultPath(f);
        return this.wrapOutputStream(p, this.fileSystem.createNonRecursive(p, permission, overwrite, bufferSize, replication, blockSize, progress));
    }

    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        Path p = this.convertToDefaultPath(f);
        return this.wrapOutputStream(p, this.fileSystem.createNonRecursive(p, permission, flags, bufferSize, replication, blockSize, progress));
    }

    public boolean createNewFile(Path f) throws IOException {
        boolean newFile = this.fileSystem.createNewFile(this.convertToDefaultPath(f));
        if (newFile) {
            try {
                this.consistencyGuard.waitTillFileAppears(this.convertToDefaultPath(f));
            }
            catch (TimeoutException e) {
                throw new HoodieException("Timed out waiting for " + f + " to appear", e);
            }
        }
        return newFile;
    }

    public FSDataOutputStream append(Path f) throws IOException {
        return this.wrapOutputStream(f, this.fileSystem.append(this.convertToDefaultPath(f)));
    }

    public FSDataOutputStream append(Path f, int bufferSize) throws IOException {
        return this.wrapOutputStream(f, this.fileSystem.append(this.convertToDefaultPath(f), bufferSize));
    }

    public void concat(Path trg, Path[] psrcs) throws IOException {
        Path[] psrcsNew = this.convertDefaults(psrcs);
        this.fileSystem.concat(this.convertToDefaultPath(trg), psrcsNew);
        try {
            this.consistencyGuard.waitTillFileAppears(this.convertToDefaultPath(trg));
        }
        catch (TimeoutException e) {
            throw new HoodieException("Timed out waiting for " + trg + " to appear", e);
        }
    }

    public short getReplication(Path src) throws IOException {
        return this.fileSystem.getReplication(this.convertToDefaultPath(src));
    }

    public boolean setReplication(Path src, short replication) throws IOException {
        return this.fileSystem.setReplication(this.convertToDefaultPath(src), replication);
    }

    public boolean delete(Path f) throws IOException {
        return HoodieWrapperFileSystem.executeFuncWithTimeMetrics(MetricName.delete.name(), f, () -> this.delete(f, true));
    }

    public boolean deleteOnExit(Path f) throws IOException {
        return this.fileSystem.deleteOnExit(this.convertToDefaultPath(f));
    }

    public boolean cancelDeleteOnExit(Path f) {
        return this.fileSystem.cancelDeleteOnExit(this.convertToDefaultPath(f));
    }

    public boolean exists(Path f) throws IOException {
        return this.fileSystem.exists(this.convertToDefaultPath(f));
    }

    public boolean isDirectory(Path f) throws IOException {
        return this.fileSystem.isDirectory(this.convertToDefaultPath(f));
    }

    public boolean isFile(Path f) throws IOException {
        return this.fileSystem.isFile(this.convertToDefaultPath(f));
    }

    public long getLength(Path f) throws IOException {
        return this.fileSystem.getLength(this.convertToDefaultPath(f));
    }

    public ContentSummary getContentSummary(Path f) throws IOException {
        return this.fileSystem.getContentSummary(this.convertToDefaultPath(f));
    }

    public RemoteIterator<Path> listCorruptFileBlocks(Path path) throws IOException {
        return this.fileSystem.listCorruptFileBlocks(this.convertToDefaultPath(path));
    }

    public FileStatus[] listStatus(Path f, PathFilter filter) throws IOException {
        return HoodieWrapperFileSystem.executeFuncWithTimeMetrics(MetricName.listStatus.name(), f, () -> this.fileSystem.listStatus(this.convertToDefaultPath(f), filter));
    }

    public FileStatus[] listStatus(Path[] files) throws IOException {
        return HoodieWrapperFileSystem.executeFuncWithTimeMetrics(MetricName.listStatus.name(), files.length > 0 ? files[0] : null, () -> this.fileSystem.listStatus(this.convertDefaults(files)));
    }

    public FileStatus[] listStatus(Path[] files, PathFilter filter) throws IOException {
        return HoodieWrapperFileSystem.executeFuncWithTimeMetrics(MetricName.listStatus.name(), files.length > 0 ? files[0] : null, () -> this.fileSystem.listStatus(this.convertDefaults(files), filter));
    }

    public FileStatus[] globStatus(Path pathPattern) throws IOException {
        return HoodieWrapperFileSystem.executeFuncWithTimeMetrics(MetricName.globStatus.name(), pathPattern, () -> this.fileSystem.globStatus(this.convertToDefaultPath(pathPattern)));
    }

    public FileStatus[] globStatus(Path pathPattern, PathFilter filter) throws IOException {
        return HoodieWrapperFileSystem.executeFuncWithTimeMetrics(MetricName.globStatus.name(), pathPattern, () -> this.fileSystem.globStatus(this.convertToDefaultPath(pathPattern), filter));
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws IOException {
        return this.fileSystem.listLocatedStatus(this.convertToDefaultPath(f));
    }

    public RemoteIterator<LocatedFileStatus> listFiles(Path f, boolean recursive) throws IOException {
        return HoodieWrapperFileSystem.executeFuncWithTimeMetrics(MetricName.listFiles.name(), f, () -> this.fileSystem.listFiles(this.convertToDefaultPath(f), recursive));
    }

    public Path getHomeDirectory() {
        return this.convertToHoodiePath(this.fileSystem.getHomeDirectory());
    }

    public boolean mkdirs(Path f) throws IOException {
        return HoodieWrapperFileSystem.executeFuncWithTimeMetrics(MetricName.mkdirs.name(), f, () -> {
            boolean success = this.fileSystem.mkdirs(this.convertToDefaultPath(f));
            if (success) {
                try {
                    this.consistencyGuard.waitTillFileAppears(this.convertToDefaultPath(f));
                }
                catch (TimeoutException e) {
                    throw new HoodieException("Timed out waiting for directory " + f + " to appear", e);
                }
            }
            return success;
        });
    }

    public void copyFromLocalFile(Path src, Path dst) throws IOException {
        this.fileSystem.copyFromLocalFile(this.convertToLocalPath(src), this.convertToDefaultPath(dst));
        try {
            this.consistencyGuard.waitTillFileAppears(this.convertToDefaultPath(dst));
        }
        catch (TimeoutException e) {
            throw new HoodieException("Timed out waiting for destination " + dst + " to appear", e);
        }
    }

    public void moveFromLocalFile(Path[] srcs, Path dst) throws IOException {
        this.fileSystem.moveFromLocalFile(this.convertLocalPaths(srcs), this.convertToDefaultPath(dst));
        try {
            this.consistencyGuard.waitTillFileAppears(this.convertToDefaultPath(dst));
        }
        catch (TimeoutException e) {
            throw new HoodieException("Timed out waiting for destination " + dst + " to appear", e);
        }
    }

    public void moveFromLocalFile(Path src, Path dst) throws IOException {
        this.fileSystem.moveFromLocalFile(this.convertToLocalPath(src), this.convertToDefaultPath(dst));
        try {
            this.consistencyGuard.waitTillFileAppears(this.convertToDefaultPath(dst));
        }
        catch (TimeoutException e) {
            throw new HoodieException("Timed out waiting for destination " + dst + " to appear", e);
        }
    }

    public void copyFromLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        this.fileSystem.copyFromLocalFile(delSrc, this.convertToLocalPath(src), this.convertToDefaultPath(dst));
        try {
            this.consistencyGuard.waitTillFileAppears(this.convertToDefaultPath(dst));
        }
        catch (TimeoutException e) {
            throw new HoodieException("Timed out waiting for destination " + dst + " to appear", e);
        }
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path[] srcs, Path dst) throws IOException {
        this.fileSystem.copyFromLocalFile(delSrc, overwrite, this.convertLocalPaths(srcs), this.convertToDefaultPath(dst));
        try {
            this.consistencyGuard.waitTillFileAppears(this.convertToDefaultPath(dst));
        }
        catch (TimeoutException e) {
            throw new HoodieException("Timed out waiting for destination " + dst + " to appear", e);
        }
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws IOException {
        this.fileSystem.copyFromLocalFile(delSrc, overwrite, this.convertToLocalPath(src), this.convertToDefaultPath(dst));
        try {
            this.consistencyGuard.waitTillFileAppears(this.convertToDefaultPath(dst));
        }
        catch (TimeoutException e) {
            throw new HoodieException("Timed out waiting for destination " + dst + " to appear", e);
        }
    }

    public void copyToLocalFile(Path src, Path dst) throws IOException {
        this.fileSystem.copyToLocalFile(this.convertToDefaultPath(src), this.convertToLocalPath(dst));
    }

    public void moveToLocalFile(Path src, Path dst) throws IOException {
        this.fileSystem.moveToLocalFile(this.convertToDefaultPath(src), this.convertToLocalPath(dst));
    }

    public void copyToLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        this.fileSystem.copyToLocalFile(delSrc, this.convertToDefaultPath(src), this.convertToLocalPath(dst));
    }

    public void copyToLocalFile(boolean delSrc, Path src, Path dst, boolean useRawLocalFileSystem) throws IOException {
        this.fileSystem.copyToLocalFile(delSrc, this.convertToDefaultPath(src), this.convertToLocalPath(dst), useRawLocalFileSystem);
    }

    public Path startLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        return this.convertToHoodiePath(this.fileSystem.startLocalOutput(this.convertToDefaultPath(fsOutputFile), this.convertToDefaultPath(tmpLocalFile)));
    }

    public void completeLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        this.fileSystem.completeLocalOutput(this.convertToDefaultPath(fsOutputFile), this.convertToDefaultPath(tmpLocalFile));
    }

    public void close() throws IOException {
        super.close();
    }

    public long getUsed() throws IOException {
        return this.fileSystem.getUsed();
    }

    public long getBlockSize(Path f) throws IOException {
        return this.fileSystem.getBlockSize(this.convertToDefaultPath(f));
    }

    public long getDefaultBlockSize() {
        return this.fileSystem.getDefaultBlockSize();
    }

    public long getDefaultBlockSize(Path f) {
        return this.fileSystem.getDefaultBlockSize(this.convertToDefaultPath(f));
    }

    public short getDefaultReplication() {
        return this.fileSystem.getDefaultReplication();
    }

    public short getDefaultReplication(Path path) {
        return this.fileSystem.getDefaultReplication(this.convertToDefaultPath(path));
    }

    public void access(Path path, FsAction mode) throws IOException {
        this.fileSystem.access(this.convertToDefaultPath(path), mode);
    }

    public void createSymlink(Path target, Path link, boolean createParent) throws IOException {
        this.fileSystem.createSymlink(this.convertToDefaultPath(target), this.convertToDefaultPath(link), createParent);
    }

    public FileStatus getFileLinkStatus(Path f) throws IOException {
        return this.fileSystem.getFileLinkStatus(this.convertToDefaultPath(f));
    }

    public boolean supportsSymlinks() {
        return this.fileSystem.supportsSymlinks();
    }

    public Path getLinkTarget(Path f) throws IOException {
        return this.convertToHoodiePath(this.fileSystem.getLinkTarget(this.convertToDefaultPath(f)));
    }

    public FileChecksum getFileChecksum(Path f) throws IOException {
        return this.fileSystem.getFileChecksum(this.convertToDefaultPath(f));
    }

    public FileChecksum getFileChecksum(Path f, long length) throws IOException {
        return this.fileSystem.getFileChecksum(this.convertToDefaultPath(f), length);
    }

    public void setVerifyChecksum(boolean verifyChecksum) {
        this.fileSystem.setVerifyChecksum(verifyChecksum);
    }

    public void setWriteChecksum(boolean writeChecksum) {
        this.fileSystem.setWriteChecksum(writeChecksum);
    }

    public FsStatus getStatus() throws IOException {
        return this.fileSystem.getStatus();
    }

    public FsStatus getStatus(Path p) throws IOException {
        return this.fileSystem.getStatus(this.convertToDefaultPath(p));
    }

    public void setPermission(Path p, FsPermission permission) throws IOException {
        this.fileSystem.setPermission(this.convertToDefaultPath(p), permission);
    }

    public void setOwner(Path p, String username, String groupname) throws IOException {
        this.fileSystem.setOwner(this.convertToDefaultPath(p), username, groupname);
    }

    public void setTimes(Path p, long mtime, long atime) throws IOException {
        this.fileSystem.setTimes(this.convertToDefaultPath(p), mtime, atime);
    }

    public Path createSnapshot(Path path, String snapshotName) throws IOException {
        return this.convertToHoodiePath(this.fileSystem.createSnapshot(this.convertToDefaultPath(path), snapshotName));
    }

    public void renameSnapshot(Path path, String snapshotOldName, String snapshotNewName) throws IOException {
        this.fileSystem.renameSnapshot(this.convertToDefaultPath(path), snapshotOldName, snapshotNewName);
    }

    public void deleteSnapshot(Path path, String snapshotName) throws IOException {
        this.fileSystem.deleteSnapshot(this.convertToDefaultPath(path), snapshotName);
    }

    public void modifyAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        this.fileSystem.modifyAclEntries(this.convertToDefaultPath(path), aclSpec);
    }

    public void removeAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        this.fileSystem.removeAclEntries(this.convertToDefaultPath(path), aclSpec);
    }

    public void removeDefaultAcl(Path path) throws IOException {
        this.fileSystem.removeDefaultAcl(this.convertToDefaultPath(path));
    }

    public void removeAcl(Path path) throws IOException {
        this.fileSystem.removeAcl(this.convertToDefaultPath(path));
    }

    public void setAcl(Path path, List<AclEntry> aclSpec) throws IOException {
        this.fileSystem.setAcl(this.convertToDefaultPath(path), aclSpec);
    }

    public AclStatus getAclStatus(Path path) throws IOException {
        return this.fileSystem.getAclStatus(this.convertToDefaultPath(path));
    }

    public void setXAttr(Path path, String name, byte[] value) throws IOException {
        this.fileSystem.setXAttr(this.convertToDefaultPath(path), name, value);
    }

    public void setXAttr(Path path, String name, byte[] value, EnumSet<XAttrSetFlag> flag) throws IOException {
        this.fileSystem.setXAttr(this.convertToDefaultPath(path), name, value, flag);
    }

    public byte[] getXAttr(Path path, String name) throws IOException {
        return this.fileSystem.getXAttr(this.convertToDefaultPath(path), name);
    }

    public Map<String, byte[]> getXAttrs(Path path) throws IOException {
        return this.fileSystem.getXAttrs(this.convertToDefaultPath(path));
    }

    public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
        return this.fileSystem.getXAttrs(this.convertToDefaultPath(path), names);
    }

    public List<String> listXAttrs(Path path) throws IOException {
        return this.fileSystem.listXAttrs(this.convertToDefaultPath(path));
    }

    public void removeXAttr(Path path, String name) throws IOException {
        this.fileSystem.removeXAttr(this.convertToDefaultPath(path), name);
    }

    public Configuration getConf() {
        return this.fileSystem.getConf();
    }

    public void setConf(Configuration conf) {
    }

    public int hashCode() {
        return this.fileSystem.hashCode();
    }

    public boolean equals(Object obj) {
        return this.fileSystem.equals(obj);
    }

    public String toString() {
        return this.fileSystem.toString();
    }

    public Path convertToHoodiePath(Path oldPath) {
        return HoodieWrapperFileSystem.convertPathWithScheme(oldPath, HoodieWrapperFileSystem.getHoodieScheme(this.getScheme()));
    }

    private Path convertToDefaultPath(Path oldPath) {
        return HoodieWrapperFileSystem.convertPathWithScheme(oldPath, this.getScheme());
    }

    private Path convertToLocalPath(Path oldPath) {
        try {
            return HoodieWrapperFileSystem.convertPathWithScheme(oldPath, FileSystem.getLocal((Configuration)this.getConf()).getScheme());
        }
        catch (IOException e) {
            throw new HoodieIOException(e.getMessage(), e);
        }
    }

    private Path[] convertLocalPaths(Path[] psrcs) {
        Path[] psrcsNew = new Path[psrcs.length];
        for (int i = 0; i < psrcs.length; ++i) {
            psrcsNew[i] = this.convertToLocalPath(psrcs[i]);
        }
        return psrcsNew;
    }

    private Path[] convertDefaults(Path[] psrcs) {
        Path[] psrcsNew = new Path[psrcs.length];
        for (int i = 0; i < psrcs.length; ++i) {
            psrcsNew[i] = this.convertToDefaultPath(psrcs[i]);
        }
        return psrcsNew;
    }

    public long getBytesWritten(Path file) {
        if (this.openStreams.containsKey(file.getName())) {
            return ((SizeAwareFSDataOutputStream)((Object)this.openStreams.get(file.getName()))).getBytesWritten();
        }
        throw new IllegalArgumentException(file.toString() + " does not have a open stream. Cannot get the bytes written on the stream");
    }

    protected boolean needCreateTempFile() {
        return StorageSchemes.HDFS.getScheme().equals(this.fileSystem.getScheme());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createImmutableFileInPath(Path fullPath, Option<byte[]> content) throws HoodieIOException {
        FSDataOutputStream fsout = null;
        Path tmpPath = null;
        boolean needTempFile = this.needCreateTempFile();
        try {
            if (!content.isPresent()) {
                fsout = this.fileSystem.create(fullPath, false);
            }
            if (content.isPresent() && needTempFile) {
                Path parent = fullPath.getParent();
                tmpPath = new Path(parent, fullPath.getName() + TMP_PATH_POSTFIX);
                fsout = this.fileSystem.create(tmpPath, false);
                fsout.write(content.get());
            }
            if (content.isPresent() && !needTempFile) {
                fsout = this.fileSystem.create(fullPath, false);
                fsout.write(content.get());
            }
        }
        catch (IOException e) {
            try {
                String errorMsg = "Failed to create file " + (tmpPath != null ? tmpPath : fullPath);
                throw new HoodieIOException(errorMsg, e);
            }
            catch (Throwable throwable) {
                try {
                    if (null != fsout) {
                        fsout.close();
                    }
                }
                catch (IOException e2) {
                    String errorMsg = "Failed to close file " + (needTempFile ? tmpPath : fullPath);
                    throw new HoodieIOException(errorMsg, e2);
                }
                boolean renameSuccess2 = false;
                try {
                    if (null == tmpPath) throw throwable;
                    renameSuccess2 = this.fileSystem.rename(tmpPath, fullPath);
                    throw throwable;
                }
                catch (IOException e3) {
                    throw new HoodieIOException("Failed to rename " + tmpPath + " to the target " + fullPath, e3);
                }
                finally {
                    if (!renameSuccess2 && null != tmpPath) {
                        try {
                            this.fileSystem.delete(tmpPath, false);
                            LOG.warn((Object)("Fail to rename " + tmpPath + " to " + fullPath + ", target file exists: " + this.fileSystem.exists(fullPath)));
                        }
                        catch (IOException e4) {
                            throw new HoodieIOException("Failed to delete tmp file " + tmpPath, e4);
                        }
                    }
                }
            }
        }
        try {
            if (null != fsout) {
                fsout.close();
            }
        }
        catch (IOException e) {
            String errorMsg = "Failed to close file " + (needTempFile ? tmpPath : fullPath);
            throw new HoodieIOException(errorMsg, e);
        }
        boolean renameSuccess = false;
        try {
            if (null == tmpPath) return;
            renameSuccess = this.fileSystem.rename(tmpPath, fullPath);
            return;
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to rename " + tmpPath + " to the target " + fullPath, e);
        }
        finally {
            if (!renameSuccess && null != tmpPath) {
                try {
                    this.fileSystem.delete(tmpPath, false);
                    LOG.warn((Object)("Fail to rename " + tmpPath + " to " + fullPath + ", target file exists: " + this.fileSystem.exists(fullPath)));
                }
                catch (IOException e) {
                    throw new HoodieIOException("Failed to delete tmp file " + tmpPath, e);
                }
            }
        }
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @FunctionalInterface
    public static interface CheckedFunction<R> {
        public R get() throws IOException;
    }

    protected static enum MetricName {
        create,
        rename,
        delete,
        listStatus,
        mkdirs,
        getFileStatus,
        globStatus,
        listFiles,
        read,
        write;

    }
}

