/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.view;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.HoodieMetaserverConfig;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.function.SerializableFunctionUnchecked;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.table.view.IncrementalTimelineSyncFileSystemView;
import org.apache.hudi.common.table.view.PriorityBasedFileSystemView;
import org.apache.hudi.common.table.view.RemoteHoodieTableFileSystemView;
import org.apache.hudi.common.table.view.RocksDbBasedFileSystemView;
import org.apache.hudi.common.table.view.SpillableMapBasedFileSystemView;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.util.Functions;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.metadata.HoodieMetadataFileSystemView;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemViewManager {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemViewManager.class);
    private static final String HOODIE_METASERVER_FILE_SYSTEM_VIEW_CLASS = "org.apache.hudi.common.table.view.HoodieMetaserverFileSystemView";
    private final SerializableConfiguration conf;
    private final FileSystemViewStorageConfig viewStorageConfig;
    private final ConcurrentHashMap<String, SyncableFileSystemView> globalViewMap;
    private final Functions.Function2<HoodieTableMetaClient, FileSystemViewStorageConfig, SyncableFileSystemView> viewCreator;

    private FileSystemViewManager(HoodieEngineContext context, FileSystemViewStorageConfig viewStorageConfig, Functions.Function2<HoodieTableMetaClient, FileSystemViewStorageConfig, SyncableFileSystemView> viewCreator) {
        this.conf = context.getHadoopConf();
        this.viewStorageConfig = viewStorageConfig;
        this.globalViewMap = new ConcurrentHashMap();
        this.viewCreator = viewCreator;
    }

    public void clearFileSystemView(String basePath) {
        SyncableFileSystemView view = this.globalViewMap.remove(basePath);
        if (view != null) {
            view.close();
        }
    }

    public SyncableFileSystemView getFileSystemView(String basePath) {
        return this.globalViewMap.computeIfAbsent(basePath, path -> {
            HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.conf.newCopy()).setBasePath((String)path).build();
            return this.viewCreator.apply(metaClient, this.viewStorageConfig);
        });
    }

    public SyncableFileSystemView getFileSystemView(HoodieTableMetaClient metaClient) {
        return this.globalViewMap.computeIfAbsent(metaClient.getBasePath(), path -> this.viewCreator.apply(metaClient, this.viewStorageConfig));
    }

    public void close() {
        if (!this.globalViewMap.isEmpty()) {
            this.globalViewMap.values().forEach(SyncableFileSystemView::close);
            this.globalViewMap.clear();
        }
    }

    private static RocksDbBasedFileSystemView createRocksDBBasedFileSystemView(SerializableConfiguration conf, FileSystemViewStorageConfig viewConf, HoodieTableMetaClient metaClient) {
        HoodieTimeline timeline = metaClient.getActiveTimeline().filterCompletedAndCompactionInstants();
        return new RocksDbBasedFileSystemView(metaClient, timeline, viewConf);
    }

    private static SpillableMapBasedFileSystemView createSpillableMapBasedFileSystemView(SerializableConfiguration conf, FileSystemViewStorageConfig viewConf, HoodieTableMetaClient metaClient, HoodieCommonConfig commonConfig) {
        LOG.info("Creating SpillableMap based view for basePath " + metaClient.getBasePath());
        HoodieTimeline timeline = metaClient.getActiveTimeline().filterCompletedAndCompactionInstants();
        return new SpillableMapBasedFileSystemView(metaClient, timeline, viewConf, commonConfig);
    }

    private static HoodieTableFileSystemView createInMemoryFileSystemView(HoodieMetadataConfig metadataConfig, FileSystemViewStorageConfig viewConf, HoodieTableMetaClient metaClient, SerializableFunctionUnchecked<HoodieTableMetaClient, HoodieTableMetadata> metadataCreator) {
        LOG.info("Creating InMemory based view for basePath " + metaClient.getBasePathV2());
        HoodieTimeline timeline = metaClient.getActiveTimeline().filterCompletedAndCompactionInstants();
        if (metaClient.getTableConfig().isMetadataTableAvailable()) {
            ValidationUtils.checkArgument(metadataCreator != null, "Metadata supplier is null. Cannot instantiate metadata file system view");
            return new HoodieMetadataFileSystemView(metaClient, timeline, metadataCreator.apply(metaClient));
        }
        if (metaClient.getMetaserverConfig().isMetaserverEnabled()) {
            return (HoodieTableFileSystemView)ReflectionUtils.loadClass(HOODIE_METASERVER_FILE_SYSTEM_VIEW_CLASS, new Class[]{HoodieTableMetaClient.class, HoodieTimeline.class, HoodieMetaserverConfig.class}, new Object[]{metaClient, timeline, metaClient.getMetaserverConfig()});
        }
        return new HoodieTableFileSystemView(metaClient, timeline, viewConf.isIncrementalTimelineSyncEnabled());
    }

    public static HoodieTableFileSystemView createInMemoryFileSystemView(HoodieEngineContext engineContext, HoodieTableMetaClient metaClient, HoodieMetadataConfig metadataConfig) {
        return FileSystemViewManager.createInMemoryFileSystemViewWithTimeline(engineContext, metaClient, metadataConfig, metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants());
    }

    public static HoodieTableFileSystemView createInMemoryFileSystemViewWithTimeline(HoodieEngineContext engineContext, HoodieTableMetaClient metaClient, HoodieMetadataConfig metadataConfig, HoodieTimeline timeline) {
        LOG.info("Creating InMemory based view for basePath " + metaClient.getBasePath());
        if (metaClient.getTableConfig().isMetadataTableAvailable()) {
            return new HoodieMetadataFileSystemView(engineContext, metaClient, timeline, metadataConfig);
        }
        if (metaClient.getMetaserverConfig().isMetaserverEnabled()) {
            return (HoodieTableFileSystemView)ReflectionUtils.loadClass(HOODIE_METASERVER_FILE_SYSTEM_VIEW_CLASS, new Class[]{HoodieTableMetaClient.class, HoodieTimeline.class, HoodieMetadataConfig.class}, new Object[]{metaClient, timeline, metaClient.getMetaserverConfig()});
        }
        return new HoodieTableFileSystemView(metaClient, timeline);
    }

    private static RemoteHoodieTableFileSystemView createRemoteFileSystemView(SerializableConfiguration conf, FileSystemViewStorageConfig viewConf, HoodieTableMetaClient metaClient) {
        LOG.info("Creating remote view for basePath " + metaClient.getBasePath() + ". Server=" + viewConf.getRemoteViewServerHost() + ":" + viewConf.getRemoteViewServerPort() + ", Timeout=" + viewConf.getRemoteTimelineClientTimeoutSecs());
        return new RemoteHoodieTableFileSystemView(metaClient, viewConf);
    }

    public static FileSystemViewManager createViewManager(HoodieEngineContext context, HoodieMetadataConfig metadataConfig, FileSystemViewStorageConfig config, HoodieCommonConfig commonConfig) {
        return FileSystemViewManager.createViewManager(context, metadataConfig, config, commonConfig, null);
    }

    public static FileSystemViewManager createViewManagerWithTableMetadata(HoodieEngineContext context, HoodieMetadataConfig metadataConfig, FileSystemViewStorageConfig config, HoodieCommonConfig commonConfig) {
        return FileSystemViewManager.createViewManager(context, metadataConfig, config, commonConfig, metaClient -> HoodieTableMetadata.create(context, metadataConfig, metaClient.getBasePathV2().toString(), true));
    }

    public static FileSystemViewManager createViewManager(HoodieEngineContext context, HoodieMetadataConfig metadataConfig, FileSystemViewStorageConfig config, HoodieCommonConfig commonConfig, SerializableFunctionUnchecked<HoodieTableMetaClient, HoodieTableMetadata> metadataCreator) {
        LOG.info("Creating View Manager with storage type :" + (Object)((Object)config.getStorageType()));
        SerializableConfiguration conf = context.getHadoopConf();
        switch (config.getStorageType()) {
            case EMBEDDED_KV_STORE: {
                LOG.info("Creating embedded rocks-db based Table View");
                return new FileSystemViewManager(context, config, (metaClient, viewConf) -> FileSystemViewManager.createRocksDBBasedFileSystemView(conf, viewConf, metaClient));
            }
            case SPILLABLE_DISK: {
                LOG.info("Creating Spillable Disk based Table View");
                return new FileSystemViewManager(context, config, (metaClient, viewConf) -> FileSystemViewManager.createSpillableMapBasedFileSystemView(conf, viewConf, metaClient, commonConfig));
            }
            case MEMORY: {
                LOG.info("Creating in-memory based Table View");
                return new FileSystemViewManager(context, config, (metaClient, viewConfig) -> FileSystemViewManager.createInMemoryFileSystemView(metadataConfig, viewConfig, metaClient, metadataCreator));
            }
            case REMOTE_ONLY: {
                LOG.info("Creating remote only table view");
                return new FileSystemViewManager(context, config, (metaClient, viewConfig) -> FileSystemViewManager.createRemoteFileSystemView(conf, viewConfig, metaClient));
            }
            case REMOTE_FIRST: {
                LOG.info("Creating remote first table view");
                return new FileSystemViewManager(context, config, (metaClient, viewConfig) -> {
                    IncrementalTimelineSyncFileSystemView secondaryView;
                    RemoteHoodieTableFileSystemView remoteFileSystemView = FileSystemViewManager.createRemoteFileSystemView(conf, viewConfig, metaClient);
                    switch (viewConfig.getSecondaryStorageType()) {
                        case MEMORY: {
                            secondaryView = FileSystemViewManager.createInMemoryFileSystemView(metadataConfig, viewConfig, metaClient, metadataCreator);
                            break;
                        }
                        case EMBEDDED_KV_STORE: {
                            secondaryView = FileSystemViewManager.createRocksDBBasedFileSystemView(conf, viewConfig, metaClient);
                            break;
                        }
                        case SPILLABLE_DISK: {
                            secondaryView = FileSystemViewManager.createSpillableMapBasedFileSystemView(conf, viewConfig, metaClient, commonConfig);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Secondary Storage type can only be in-memory or spillable. Was :" + (Object)((Object)viewConfig.getSecondaryStorageType()));
                        }
                    }
                    return new PriorityBasedFileSystemView(remoteFileSystemView, secondaryView);
                });
            }
        }
        throw new IllegalArgumentException("Unknown file system view type :" + (Object)((Object)config.getStorageType()));
    }
}

