/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution.bulkinsert;

import java.io.Serializable;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.AvroConversionUtils;
import org.apache.hudi.HoodieSparkUtils;
import org.apache.hudi.SparkConversionUtils;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.SerializableSchema;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieSparkRecord;
import org.apache.hudi.common.model.RewriteAvroPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.execution.bulkinsert.SpatialCurveSortPartitionerBase;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.HoodieInternalRowUtils;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;

public class RDDSpatialCurveSortPartitioner<T>
extends SpatialCurveSortPartitionerBase<JavaRDD<HoodieRecord<T>>> {
    private final transient HoodieSparkEngineContext sparkEngineContext;
    private final SerializableSchema schema;
    private final HoodieRecord.HoodieRecordType recordType;

    public RDDSpatialCurveSortPartitioner(HoodieSparkEngineContext sparkEngineContext, String[] orderByColumns, HoodieClusteringConfig.LayoutOptimizationStrategy layoutOptStrategy, HoodieClusteringConfig.SpatialCurveCompositionStrategyType curveCompositionStrategyType, Schema schema, HoodieRecord.HoodieRecordType recordType) {
        super(orderByColumns, layoutOptStrategy, curveCompositionStrategyType);
        this.sparkEngineContext = sparkEngineContext;
        this.schema = new SerializableSchema(schema);
        this.recordType = recordType;
    }

    @Override
    public JavaRDD<HoodieRecord<T>> repartitionRecords(JavaRDD<HoodieRecord<T>> records, int outputSparkPartitions) {
        if (this.recordType == HoodieRecord.HoodieRecordType.AVRO) {
            JavaRDD genericRecordsRDD = records.map((Function & Serializable)f -> (GenericRecord)f.toIndexedRecord(this.schema.get(), new Properties()).get().getData());
            Dataset<Row> sourceDataset = AvroConversionUtils.createDataFrame((RDD<GenericRecord>)genericRecordsRDD.rdd(), this.schema.toString(), this.sparkEngineContext.getSqlContext().sparkSession());
            Dataset<Row> sortedDataset = this.reorder(sourceDataset, outputSparkPartitions);
            return HoodieSparkUtils.createRdd(sortedDataset, this.schema.get().getName(), this.schema.get().getNamespace(), false, Option.empty()).toJavaRDD().map((Function & Serializable)record -> {
                String key = record.get(HoodieRecord.RECORD_KEY_METADATA_FIELD).toString();
                String partition = record.get(HoodieRecord.PARTITION_PATH_METADATA_FIELD).toString();
                HoodieKey hoodieKey = new HoodieKey(key, partition);
                HoodieAvroRecord<RewriteAvroPayload> hoodieRecord = new HoodieAvroRecord<RewriteAvroPayload>(hoodieKey, new RewriteAvroPayload((GenericRecord)record));
                return hoodieRecord;
            });
        }
        if (this.recordType == HoodieRecord.HoodieRecordType.SPARK) {
            StructType structType = HoodieInternalRowUtils.getCachedSchema(this.schema.get());
            Dataset<Row> sourceDataset = SparkConversionUtils.createDataFrame(records.rdd(), this.sparkEngineContext.getSqlContext().sparkSession(), structType);
            Dataset<Row> sortedDataset = this.reorder(sourceDataset, outputSparkPartitions);
            return sortedDataset.queryExecution().toRdd().toJavaRDD().map((Function & Serializable)internalRow -> {
                String key = internalRow.getString(HoodieRecord.HoodieMetadataField.RECORD_KEY_METADATA_FIELD.ordinal());
                String partition = internalRow.getString(HoodieRecord.HoodieMetadataField.PARTITION_PATH_METADATA_FIELD.ordinal());
                HoodieKey hoodieKey = new HoodieKey(key, partition);
                return new HoodieSparkRecord(hoodieKey, (InternalRow)internalRow, structType, false);
            });
        }
        throw new UnsupportedOperationException(this.recordType.name());
    }
}

