/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.expression.BinaryExpression;
import org.apache.hudi.expression.Expression;
import org.apache.hudi.expression.Literal;
import org.apache.hudi.expression.NameReference;
import org.apache.hudi.expression.Predicates;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HoodieHiveSyncException;
import org.apache.hudi.hive.util.FilterGenVisitor;
import org.apache.hudi.internal.schema.Types;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.common.model.FieldSchema;
import org.apache.hudi.sync.common.model.Partition;
import org.apache.hudi.sync.common.model.PartitionValueExtractor;

public class PartitionFilterGenerator {
    private static final Set<String> SUPPORT_TYPES = new HashSet<String>(){
        {
            this.add("int");
            this.add("bigint");
            this.add("date");
            this.add("string");
        }
    };
    private static final String UNSUPPORTED_TYPE_ERROR = "The value type: %s doesn't support to be pushed down to HMS, acceptable types: " + String.join((CharSequence)",", SUPPORT_TYPES);

    private static Literal buildLiteralExpression(String fieldValue, String fieldType) {
        switch (fieldType.toLowerCase(Locale.ROOT)) {
            case "int": {
                return new Literal<Integer>(Integer.parseInt(fieldValue), Types.IntType.get());
            }
            case "bigint": {
                return new Literal<Long>(Long.parseLong(fieldValue), Types.LongType.get());
            }
            case "date": {
                return new Literal<String>(fieldValue, Types.DateType.get());
            }
            case "string": {
                return new Literal<String>(fieldValue, Types.StringType.get());
            }
            case "boolean": {
                return new Literal<Boolean>(Boolean.parseBoolean(fieldValue), Types.BooleanType.get());
            }
        }
        throw new IllegalArgumentException(String.format(UNSUPPORTED_TYPE_ERROR, fieldType));
    }

    private static Expression buildPartitionExpression(List<Partition> partitions, List<FieldSchema> partitionFields) {
        return partitions.stream().map(partition -> {
            List<String> partitionValues = partition.getValues();
            BinaryExpression root = null;
            for (int i = 0; i < partitionFields.size(); ++i) {
                FieldSchema field = (FieldSchema)partitionFields.get(i);
                Predicates.BinaryComparison exp = Predicates.eq(new NameReference(field.getName()), PartitionFilterGenerator.buildLiteralExpression(partitionValues.get(i), field.getType()));
                root = root != null ? Predicates.and(root, exp) : exp;
            }
            return root;
        }).reduce(null, (result, expr) -> {
            if (result == null) {
                return expr;
            }
            return Predicates.or(result, expr);
        });
    }

    private static List<Pair<FieldSchema, String[]>> extractFieldValues(List<Partition> partitions, List<FieldSchema> partitionFields) {
        return IntStream.range(0, partitionFields.size()).mapToObj(i -> {
            HashSet<String> values2 = new HashSet<String>();
            for (int j = 0; j < partitions.size(); ++j) {
                values2.add(((Partition)partitions.get(j)).getValues().get(i));
            }
            return Pair.of(partitionFields.get(i), values2.toArray(new String[0]));
        }).collect(Collectors.toList());
    }

    private static Expression buildMinMaxPartitionExpression(List<Partition> partitions, List<FieldSchema> partitionFields) {
        return PartitionFilterGenerator.extractFieldValues(partitions, partitionFields).stream().map(fieldWithValues -> {
            FieldSchema fieldSchema = (FieldSchema)fieldWithValues.getKey();
            if (!SUPPORT_TYPES.contains(fieldSchema.getType())) {
                return null;
            }
            String[] values2 = (String[])fieldWithValues.getValue();
            if (values2.length == 1) {
                return Predicates.eq(new NameReference(fieldSchema.getName()), PartitionFilterGenerator.buildLiteralExpression(values2[0], fieldSchema.getType()));
            }
            Arrays.sort(values2, new ValueComparator(fieldSchema.getType()));
            return Predicates.and(Predicates.gteq(new NameReference(fieldSchema.getName()), PartitionFilterGenerator.buildLiteralExpression(values2[0], fieldSchema.getType())), Predicates.lteq(new NameReference(fieldSchema.getName()), PartitionFilterGenerator.buildLiteralExpression(values2[values2.length - 1], fieldSchema.getType())));
        }).filter(Objects::nonNull).reduce(null, (result, expr) -> {
            if (result == null) {
                return expr;
            }
            return Predicates.and(result, expr);
        });
    }

    public static String generatePushDownFilter(List<String> writtenPartitions, List<FieldSchema> partitionFields, HiveSyncConfig config) {
        PartitionValueExtractor partitionValueExtractor = (PartitionValueExtractor)ReflectionUtils.loadClass(config.getStringOrDefault(HoodieSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS));
        List<Partition> partitions = writtenPartitions.stream().map(s -> {
            List<String> values2 = partitionValueExtractor.extractPartitionValuesInPath((String)s);
            if (values2.size() != partitionFields.size()) {
                throw new HoodieHiveSyncException("Partition fields and values should be same length, but got partitionFields: " + partitionFields + " with values: " + values2);
            }
            return new Partition(values2, null);
        }).collect(Collectors.toList());
        int estimateSize = partitionFields.size() * partitions.size();
        Expression filter = estimateSize > config.getIntOrDefault(HiveSyncConfig.HIVE_SYNC_FILTER_PUSHDOWN_MAX_SIZE) ? PartitionFilterGenerator.buildMinMaxPartitionExpression(partitions, partitionFields) : PartitionFilterGenerator.buildPartitionExpression(partitions, partitionFields);
        if (filter != null) {
            return PartitionFilterGenerator.generateFilterString(filter);
        }
        return "";
    }

    private static String generateFilterString(Expression filter) {
        return filter.accept(new FilterGenVisitor());
    }

    private static class ValueComparator
    implements Comparator<String> {
        private final String valueType;

        public ValueComparator(String type) {
            this.valueType = type;
        }

        @Override
        public int compare(String s1, String s2) {
            switch (this.valueType.toLowerCase(Locale.ROOT)) {
                case "int": {
                    int i1 = Integer.parseInt(s1);
                    int i2 = Integer.parseInt(s2);
                    return i1 - i2;
                }
                case "bigint": {
                    long l1 = Long.parseLong(s1);
                    long l2 = Long.parseLong(s2);
                    return Long.signum(l1 - l2);
                }
                case "date": 
                case "string": {
                    return s1.compareTo(s2);
                }
            }
            throw new IllegalArgumentException(String.format(UNSUPPORTED_TYPE_ERROR, this.valueType));
        }
    }
}

