/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bucket;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.index.HoodieIndexUtils;
import org.apache.hudi.index.bucket.BucketIdentifier;
import org.apache.hudi.index.bucket.BucketIndexLocationMapper;
import org.apache.hudi.index.bucket.HoodieBucketIndex;
import org.apache.hudi.table.HoodieTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieSimpleBucketIndex
extends HoodieBucketIndex {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieSimpleBucketIndex.class);

    public HoodieSimpleBucketIndex(HoodieWriteConfig config) {
        super(config);
    }

    public Map<Integer, HoodieRecordLocation> loadBucketIdToFileIdMappingForPartition(HoodieTable hoodieTable, String partition) {
        HashMap<Integer, HoodieRecordLocation> bucketIdToFileIdMapping = new HashMap<Integer, HoodieRecordLocation>();
        hoodieTable.getMetaClient().reloadActiveTimeline();
        HoodieIndexUtils.getLatestFileSlicesForPartition(partition, hoodieTable).forEach(fileSlice -> {
            String fileId = fileSlice.getFileId();
            String commitTime = fileSlice.getBaseInstantTime();
            int bucketId = BucketIdentifier.bucketIdFromFileId(fileId);
            if (bucketIdToFileIdMapping.containsKey(bucketId)) {
                throw new HoodieIOException("Find multiple files at partition path=" + partition + " belongs to the same bucket id = " + bucketId);
            }
            bucketIdToFileIdMapping.put(bucketId, new HoodieRecordLocation(commitTime, fileId));
        });
        return bucketIdToFileIdMapping;
    }

    public int getBucketID(HoodieKey key) {
        return BucketIdentifier.getBucketId(key, this.indexKeyFields, this.numBuckets);
    }

    @Override
    public boolean canIndexLogFiles() {
        return false;
    }

    @Override
    protected BucketIndexLocationMapper getLocationMapper(HoodieTable table, List<String> partitionPath) {
        return new SimpleBucketIndexLocationMapper(table, partitionPath);
    }

    public class SimpleBucketIndexLocationMapper
    implements BucketIndexLocationMapper {
        private final Map<String, Map<Integer, HoodieRecordLocation>> partitionPathFileIDList;

        public SimpleBucketIndexLocationMapper(HoodieTable table, List<String> partitions) {
            this.partitionPathFileIDList = partitions.stream().collect(Collectors.toMap(p -> p, p -> HoodieSimpleBucketIndex.this.loadBucketIdToFileIdMappingForPartition(table, (String)p)));
        }

        @Override
        public Option<HoodieRecordLocation> getRecordLocation(HoodieKey key) {
            int bucketId = HoodieSimpleBucketIndex.this.getBucketID(key);
            Map<Integer, HoodieRecordLocation> bucketIdToFileIdMapping = this.partitionPathFileIDList.get(key.getPartitionPath());
            return Option.ofNullable(bucketIdToFileIdMapping.getOrDefault(bucketId, null));
        }
    }
}

