/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.io.HoodieReadHandle;
import org.apache.hudi.io.IOUtils;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.table.HoodieTable;

public class HoodieMergedReadHandle<T, I, K, O>
extends HoodieReadHandle<T, I, K, O> {
    protected final Schema readerSchema;

    public HoodieMergedReadHandle(HoodieWriteConfig config, Option<String> instantTime, HoodieTable<T, I, K, O> hoodieTable, Pair<String, String> partitionPathFileIDPair) {
        super(config, instantTime, hoodieTable, partitionPathFileIDPair);
        this.readerSchema = HoodieAvroUtils.addMetadataFields(new Schema.Parser().parse(config.getSchema()), config.allowOperationMetadataField());
    }

    public List<HoodieRecord<T>> getMergedRecords() {
        Option<FileSlice> fileSliceOpt = this.getLatestFileSlice();
        if (!fileSliceOpt.isPresent()) {
            return Collections.emptyList();
        }
        ValidationUtils.checkState(StringUtils.nonEmpty(this.instantTime), String.format("Expected a valid instant time but got `%s`", this.instantTime));
        FileSlice fileSlice = fileSliceOpt.get();
        HoodieRecordLocation currentLocation = new HoodieRecordLocation(this.instantTime, fileSlice.getFileId());
        Option<Object> baseFileReader = Option.empty();
        HoodieMergedLogRecordScanner logRecordScanner = null;
        try {
            baseFileReader = this.getBaseFileReader(fileSlice);
            logRecordScanner = this.getLogRecordScanner(fileSlice);
            ArrayList mergedRecords = new ArrayList();
            this.doMergedRead(baseFileReader, logRecordScanner).forEach(r -> {
                r.unseal();
                r.setCurrentLocation(currentLocation);
                r.seal();
                mergedRecords.add((HoodieRecord)r);
            });
            ArrayList arrayList = mergedRecords;
            return arrayList;
        }
        catch (IOException e) {
            throw new HoodieIndexException("Error in reading " + fileSlice, e);
        }
        finally {
            if (baseFileReader.isPresent()) {
                ((HoodieFileReader)baseFileReader.get()).close();
            }
            if (logRecordScanner != null) {
                logRecordScanner.close();
            }
        }
    }

    private Option<FileSlice> getLatestFileSlice() {
        if (StringUtils.nonEmpty(this.instantTime) && this.hoodieTable.getMetaClient().getCommitsTimeline().filterCompletedInstants().lastInstant().isPresent()) {
            return Option.fromJavaOptional(this.hoodieTable.getHoodieView().getLatestMergedFileSlicesBeforeOrOn((String)this.partitionPathFileIDPair.getLeft(), this.instantTime).filter(fileSlice -> fileSlice.getFileId().equals(this.partitionPathFileIDPair.getRight())).findFirst());
        }
        return Option.empty();
    }

    private Option<HoodieFileReader> getBaseFileReader(FileSlice fileSlice) throws IOException {
        if (fileSlice.getBaseFile().isPresent()) {
            return Option.of(this.createNewFileReader(fileSlice.getBaseFile().get()));
        }
        return Option.empty();
    }

    private HoodieMergedLogRecordScanner getLogRecordScanner(FileSlice fileSlice) {
        List logFilePaths = fileSlice.getLogFiles().sorted(HoodieLogFile.getLogFileComparator()).map(l -> l.getPath().toString()).collect(Collectors.toList());
        return ((HoodieMergedLogRecordScanner.Builder)HoodieMergedLogRecordScanner.newBuilder().withFileSystem(this.hoodieTable.getMetaClient().getFs()).withBasePath(this.hoodieTable.getMetaClient().getBasePathV2().toString()).withLogFilePaths(logFilePaths)).withReaderSchema(this.readerSchema).withLatestInstantTime(this.instantTime).withMaxMemorySizeInBytes(IOUtils.getMaxMemoryPerCompaction(this.hoodieTable.getTaskContextSupplier(), this.config)).withReadBlocksLazily(this.config.getCompactionLazyBlockReadEnabled()).withReverseReader(this.config.getCompactionReverseLogReadEnabled()).withBufferSize(this.config.getMaxDFSStreamBufferSize()).withSpillableMapBasePath(this.config.getSpillableMapBasePath()).withPartition(fileSlice.getPartitionPath()).withOptimizedLogBlocksScan(this.config.enableOptimizedLogBlocksScan()).withDiskMapType(this.config.getCommonConfig().getSpillableDiskMapType()).withBitCaskDiskMapCompressionEnabled(this.config.getCommonConfig().isBitCaskDiskMapCompressionEnabled()).withRecordMerger(this.config.getRecordMerger()).build();
    }

    private List<HoodieRecord<T>> doMergedRead(Option<HoodieFileReader> baseFileReaderOpt, HoodieMergedLogRecordScanner logRecordScanner) throws IOException {
        ArrayList<HoodieRecord<T>> mergedRecords = new ArrayList<HoodieRecord<T>>();
        Map<String, HoodieRecord> deltaRecordMap = logRecordScanner.getRecords();
        HashSet<String> deltaRecordKeys = new HashSet<String>(deltaRecordMap.keySet());
        if (baseFileReaderOpt.isPresent()) {
            Option<Pair<String, String>> simpleKeyGenFieldsOpt;
            HoodieFileReader baseFileReader = baseFileReaderOpt.get();
            HoodieRecordMerger recordMerger = this.config.getRecordMerger();
            ClosableIterator baseFileItr = baseFileReader.getRecordIterator(this.readerSchema);
            HoodieTableConfig tableConfig = this.hoodieTable.getMetaClient().getTableConfig();
            Option<Pair<String, String>> option = simpleKeyGenFieldsOpt = tableConfig.populateMetaFields() ? Option.empty() : Option.of(Pair.of(tableConfig.getRecordKeyFieldProp(), tableConfig.getPartitionFieldProp()));
            while (baseFileItr.hasNext()) {
                HoodieRecord record = ((HoodieRecord)baseFileItr.next()).wrapIntoHoodieRecordPayloadWithParams(this.readerSchema, this.config.getProps(), simpleKeyGenFieldsOpt, logRecordScanner.isWithOperationField(), logRecordScanner.getPartitionNameOverride(), false, Option.empty());
                String key = record.getRecordKey();
                if (deltaRecordMap.containsKey(key)) {
                    deltaRecordKeys.remove(key);
                    Option<Pair<HoodieRecord, Schema>> mergeResult = recordMerger.merge(record, this.readerSchema, deltaRecordMap.get(key), this.readerSchema, this.config.getPayloadConfig().getProps());
                    if (!mergeResult.isPresent()) continue;
                    HoodieRecord r = mergeResult.get().getLeft().wrapIntoHoodieRecordPayloadWithParams(this.readerSchema, this.config.getProps(), simpleKeyGenFieldsOpt, logRecordScanner.isWithOperationField(), logRecordScanner.getPartitionNameOverride(), false, Option.empty());
                    mergedRecords.add(r);
                    continue;
                }
                mergedRecords.add(record.copy());
            }
        }
        for (String key : deltaRecordKeys) {
            mergedRecords.add(deltaRecordMap.get(key));
        }
        return mergedRecords;
    }
}

