/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import io.hops.hudi.com.codahale.metrics.MetricRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.metrics.Registry;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metrics.HoodieGauge;
import org.apache.hudi.metrics.MetricsReporter;
import org.apache.hudi.metrics.MetricsReporterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metrics {
    private static final Logger LOG = LoggerFactory.getLogger(Metrics.class);
    private static final Map<String, Metrics> METRICS_INSTANCE_PER_BASEPATH = new HashMap<String, Metrics>();
    private final MetricRegistry registry = new MetricRegistry();
    private final List<MetricsReporter> reporters;
    private final String commonMetricPrefix;
    private boolean initialized = false;

    public Metrics(HoodieWriteConfig metricConfig) {
        this.commonMetricPrefix = metricConfig.getMetricReporterMetricsNamePrefix();
        this.reporters = new ArrayList<MetricsReporter>();
        Option<MetricsReporter> defaultReporter = MetricsReporterFactory.createReporter(metricConfig, this.registry);
        defaultReporter.ifPresent(this.reporters::add);
        if (StringUtils.nonEmpty(metricConfig.getMetricReporterFileBasedConfigs())) {
            this.reporters.addAll(this.addAdditionalMetricsExporters(metricConfig));
        }
        if (this.reporters.size() == 0) {
            throw new RuntimeException("Cannot initialize Reporters.");
        }
        this.reporters.forEach(MetricsReporter::start);
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown));
        this.initialized = true;
    }

    private void registerHoodieCommonMetrics() {
        this.registerGauges(Registry.getAllMetrics(true, true), Option.of(this.commonMetricPrefix));
    }

    public static synchronized Metrics getInstance(HoodieWriteConfig metricConfig) {
        String basePath = metricConfig.getBasePath();
        if (METRICS_INSTANCE_PER_BASEPATH.containsKey(basePath)) {
            return METRICS_INSTANCE_PER_BASEPATH.get(basePath);
        }
        Metrics metrics = new Metrics(metricConfig);
        METRICS_INSTANCE_PER_BASEPATH.put(basePath, metrics);
        return metrics;
    }

    public static synchronized void shutdownAllMetrics() {
        METRICS_INSTANCE_PER_BASEPATH.values().forEach(Metrics::shutdown);
    }

    private List<MetricsReporter> addAdditionalMetricsExporters(HoodieWriteConfig metricConfig) {
        ArrayList<MetricsReporter> reporterList = new ArrayList<MetricsReporter>();
        List<String> propPathList = StringUtils.split(metricConfig.getMetricReporterFileBasedConfigs(), ",");
        try (FileSystem fs = FSUtils.getFs(propPathList.get(0), new Configuration());){
            for (String propPath : propPathList) {
                HoodieWriteConfig secondarySourceConfig = HoodieWriteConfig.newBuilder().fromInputStream((InputStream)fs.open(new Path(propPath))).withPath(metricConfig.getBasePath()).build();
                Option<MetricsReporter> reporter = MetricsReporterFactory.createReporter(secondarySourceConfig, this.registry);
                if (reporter.isPresent()) {
                    reporterList.add(reporter.get());
                    continue;
                }
                LOG.error(String.format("Could not create reporter using properties path %s base path %s", propPath, metricConfig.getBasePath()));
            }
        }
        catch (IOException e) {
            LOG.error("Failed to add MetricsExporters", (Throwable)e);
        }
        LOG.info("total additional metrics reporters added =" + reporterList.size());
        return reporterList;
    }

    public synchronized void shutdown() {
        try {
            this.registerHoodieCommonMetrics();
            this.reporters.forEach(MetricsReporter::report);
            LOG.info("Stopping the metrics reporter...");
            this.reporters.forEach(MetricsReporter::stop);
        }
        catch (Exception e) {
            LOG.warn("Error while closing reporter", (Throwable)e);
        }
        finally {
            this.initialized = false;
        }
    }

    public synchronized void flush() {
        try {
            LOG.info("Reporting and flushing all metrics");
            this.registerHoodieCommonMetrics();
            this.reporters.forEach(MetricsReporter::report);
            this.registry.getNames().forEach(this.registry::remove);
            this.registerHoodieCommonMetrics();
        }
        catch (Exception e) {
            LOG.error("Error while reporting and flushing metrics", (Throwable)e);
        }
    }

    public void registerGauges(Map<String, Long> metricsMap, Option<String> prefix) {
        String metricPrefix = prefix.isPresent() ? prefix.get() + "." : "";
        metricsMap.forEach((k, v) -> this.registerGauge(metricPrefix + k, (long)v));
    }

    public void registerGauge(String metricName, long value) {
        try {
            HoodieGauge guage = (HoodieGauge)this.registry.gauge(metricName, () -> new HoodieGauge<Long>(value));
            guage.setValue(value);
        }
        catch (Exception e) {
            LOG.error("Failed to send metrics: ", (Throwable)e);
        }
    }

    public MetricRegistry getRegistry() {
        return this.registry;
    }

    public static boolean isInitialized(String basePath) {
        if (METRICS_INSTANCE_PER_BASEPATH.containsKey(basePath)) {
            return Metrics.METRICS_INSTANCE_PER_BASEPATH.get((Object)basePath).initialized;
        }
        return false;
    }
}

