/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics.datadog;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.hops.hudi.com.codahale.metrics.Clock;
import io.hops.hudi.com.codahale.metrics.Counter;
import io.hops.hudi.com.codahale.metrics.Gauge;
import io.hops.hudi.com.codahale.metrics.Histogram;
import io.hops.hudi.com.codahale.metrics.Meter;
import io.hops.hudi.com.codahale.metrics.MetricFilter;
import io.hops.hudi.com.codahale.metrics.MetricRegistry;
import io.hops.hudi.com.codahale.metrics.ScheduledReporter;
import io.hops.hudi.com.codahale.metrics.Timer;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.metrics.MetricUtils;
import org.apache.hudi.metrics.datadog.DatadogHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatadogReporter
extends ScheduledReporter {
    private static final Logger LOG = LoggerFactory.getLogger(DatadogReporter.class);
    private final DatadogHttpClient client;
    private final String prefix;
    private final Option<String> host;
    private final Option<List<String>> tags;
    private final Clock clock;

    protected DatadogReporter(MetricRegistry registry, DatadogHttpClient client, String prefix, Option<String> host2, Option<List<String>> tags, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit) {
        super(registry, "hudi-datadog-reporter", filter, rateUnit, durationUnit);
        this.client = client;
        this.prefix = prefix;
        this.host = host2;
        this.tags = tags;
        this.clock = Clock.defaultClock();
    }

    @Override
    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        Map<List, List<Pair>> labelsPair = gauges.keySet().stream().map(MetricUtils::getLabelsAndMetricList).collect(Collectors.groupingBy(Pair::getValue));
        labelsPair.entrySet().forEach(labelsKeyValue -> {
            long now = this.clock.getTime() / 1000L;
            PayloadBuilder builder = new PayloadBuilder();
            builder.withMetricType(MetricType.gauge);
            gauges.forEach((metricName, metric) -> builder.addGauge(this.prefix(MetricUtils.getMetricAndLabels(metricName).getKey()), now, (Long)metric.getValue()));
            this.host.ifPresent(builder::withHost);
            List runTimeLables = (List)labelsKeyValue.getKey();
            this.tags.map(runTimeLables::addAll);
            builder.withTags(runTimeLables);
            this.client.send(builder.build());
        });
    }

    protected String prefix(String ... components) {
        return MetricRegistry.name(this.prefix, components);
    }

    @Override
    public void stop() {
        try {
            super.stop();
        }
        finally {
            try {
                this.client.close();
            }
            catch (IOException e) {
                LOG.warn("Error disconnecting from Datadog.", (Throwable)e);
            }
        }
    }

    static enum MetricType {
        gauge;

    }

    static class PayloadBuilder {
        private static final ObjectMapper MAPPER = new ObjectMapper();
        private final ObjectNode payload = MAPPER.createObjectNode();
        private final ArrayNode series = this.payload.putArray("series");
        private MetricType type;

        PayloadBuilder() {
        }

        PayloadBuilder withMetricType(MetricType type) {
            this.type = type;
            return this;
        }

        PayloadBuilder addGauge(String metric, long timestamp, long gaugeValue) {
            ValidationUtils.checkState(this.type == MetricType.gauge);
            ObjectNode seriesItem = MAPPER.createObjectNode().put("metric", metric);
            seriesItem.putArray("points").addArray().add(timestamp).add(gaugeValue);
            this.series.add((JsonNode)seriesItem);
            return this;
        }

        PayloadBuilder withHost(String host2) {
            this.series.forEach(seriesItem -> ((ObjectNode)seriesItem).put("host", host2));
            return this;
        }

        PayloadBuilder withTags(List<String> tags) {
            this.series.forEach(seriesItem -> ((ObjectNode)seriesItem).putArray("tags").addAll((Collection)tags.stream().map(TextNode::new).collect(Collectors.toList())));
            return this;
        }

        String build() {
            return this.payload.toString();
        }
    }
}

