/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.bootstrap;

import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieFileStatus;
import org.apache.hudi.common.bootstrap.FileStatusUtils;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.bootstrap.BootstrapMetadataHandler;
import org.apache.hudi.table.action.bootstrap.OrcBootstrapMetadataHandler;
import org.apache.hudi.table.action.bootstrap.ParquetBootstrapMetadataHandler;

public class MetadataBootstrapHandlerFactory {
    public static BootstrapMetadataHandler getMetadataHandler(HoodieWriteConfig config, HoodieTable table, HoodieFileStatus srcFileStatus) {
        Path sourceFilePath = FileStatusUtils.toPath(srcFileStatus.getPath());
        String extension = FSUtils.getFileExtension(sourceFilePath.toString());
        if (HoodieFileFormat.ORC.getFileExtension().equals(extension)) {
            return new OrcBootstrapMetadataHandler(config, table, srcFileStatus);
        }
        if (HoodieFileFormat.PARQUET.getFileExtension().equals(extension)) {
            return new ParquetBootstrapMetadataHandler(config, table, srcFileStatus);
        }
        throw new HoodieIOException("Bootstrap Metadata Handler not implemented for base file format " + extension);
    }
}

