/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.storage.row.HoodieRowCreateHandle;
import org.apache.hudi.keygen.BuiltinKeyGenerator;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.hudi.table.HoodieTable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkInsertDataInternalWriterHelper {
    private static final Logger LOG = LoggerFactory.getLogger(BulkInsertDataInternalWriterHelper.class);
    protected final String instantTime;
    protected final int taskPartitionId;
    protected final long taskId;
    protected final long taskEpochId;
    protected final HoodieTable hoodieTable;
    protected final HoodieWriteConfig writeConfig;
    protected final StructType structType;
    protected final Boolean arePartitionRecordsSorted;
    protected final List<WriteStatus> writeStatusList = new ArrayList<WriteStatus>();
    protected final String fileIdPrefix;
    protected final Map<String, HoodieRowCreateHandle> handles = new HashMap<String, HoodieRowCreateHandle>();
    protected final boolean populateMetaFields;
    protected final boolean shouldPreserveHoodieMetadata;
    protected final Option<BuiltinKeyGenerator> keyGeneratorOpt;
    protected final boolean simpleKeyGen;
    protected final int simplePartitionFieldIndex;
    protected final DataType simplePartitionFieldDataType;
    protected UTF8String lastKnownPartitionPath = null;
    protected HoodieRowCreateHandle handle;
    protected int numFilesWritten = 0;

    public BulkInsertDataInternalWriterHelper(HoodieTable hoodieTable, HoodieWriteConfig writeConfig, String instantTime, int taskPartitionId, long taskId, long taskEpochId, StructType structType, boolean populateMetaFields, boolean arePartitionRecordsSorted) {
        this(hoodieTable, writeConfig, instantTime, taskPartitionId, taskId, taskEpochId, structType, populateMetaFields, arePartitionRecordsSorted, false);
    }

    public BulkInsertDataInternalWriterHelper(HoodieTable hoodieTable, HoodieWriteConfig writeConfig, String instantTime, int taskPartitionId, long taskId, long taskEpochId, StructType structType, boolean populateMetaFields, boolean arePartitionRecordsSorted, boolean shouldPreserveHoodieMetadata) {
        this.hoodieTable = hoodieTable;
        this.writeConfig = writeConfig;
        this.instantTime = instantTime;
        this.taskPartitionId = taskPartitionId;
        this.taskId = taskId;
        this.taskEpochId = taskEpochId;
        this.structType = structType;
        this.populateMetaFields = populateMetaFields;
        this.shouldPreserveHoodieMetadata = shouldPreserveHoodieMetadata;
        this.arePartitionRecordsSorted = arePartitionRecordsSorted;
        this.fileIdPrefix = UUID.randomUUID().toString();
        this.keyGeneratorOpt = !populateMetaFields ? HoodieSparkKeyGeneratorFactory.getKeyGenerator(writeConfig.getProps()) : Option.empty();
        if (this.keyGeneratorOpt.isPresent() && this.keyGeneratorOpt.get() instanceof SimpleKeyGenerator) {
            this.simpleKeyGen = true;
            this.simplePartitionFieldIndex = (Integer)structType.getFieldIndex(this.keyGeneratorOpt.get().getPartitionPathFields().get(0)).get();
            this.simplePartitionFieldDataType = structType.fields()[this.simplePartitionFieldIndex].dataType();
        } else {
            this.simpleKeyGen = false;
            this.simplePartitionFieldIndex = -1;
            this.simplePartitionFieldDataType = null;
        }
    }

    public void write(InternalRow row) throws IOException {
        try {
            UTF8String partitionPath = this.extractPartitionPath(row);
            if (this.lastKnownPartitionPath == null || !Objects.equals(this.lastKnownPartitionPath, partitionPath) || !this.handle.canWrite()) {
                this.handle = this.getRowCreateHandle(partitionPath.toString());
                this.lastKnownPartitionPath = partitionPath.clone();
            }
            this.handle.write(row);
        }
        catch (Throwable t) {
            LOG.error("Global error thrown while trying to write records in HoodieRowCreateHandle ", t);
            throw t;
        }
    }

    public List<WriteStatus> getWriteStatuses() throws IOException {
        this.close();
        return this.writeStatusList;
    }

    public void abort() {
    }

    public void close() throws IOException {
        for (HoodieRowCreateHandle rowCreateHandle : this.handles.values()) {
            LOG.info("Closing bulk insert file " + rowCreateHandle.getFileName());
            this.writeStatusList.add(rowCreateHandle.close());
        }
        this.handles.clear();
        this.handle = null;
    }

    protected UTF8String extractPartitionPath(InternalRow row) {
        if (this.populateMetaFields) {
            return row.getUTF8String(HoodieRecord.PARTITION_PATH_META_FIELD_ORD);
        }
        if (this.keyGeneratorOpt.isPresent()) {
            return this.keyGeneratorOpt.get().getPartitionPath(row, this.structType);
        }
        return UTF8String.EMPTY_UTF8;
    }

    private HoodieRowCreateHandle getRowCreateHandle(String partitionPath) throws IOException {
        if (!this.handles.containsKey(partitionPath)) {
            if (this.arePartitionRecordsSorted.booleanValue()) {
                this.close();
            }
            LOG.info("Creating new file for partition path " + partitionPath);
            HoodieRowCreateHandle rowCreateHandle = this.createHandle(partitionPath);
            this.handles.put(partitionPath, rowCreateHandle);
        } else if (!this.handles.get(partitionPath).canWrite()) {
            LOG.info("Rolling max-size file for partition path " + partitionPath);
            this.writeStatusList.add(this.handles.remove(partitionPath).close());
            HoodieRowCreateHandle rowCreateHandle = this.createHandle(partitionPath);
            this.handles.put(partitionPath, rowCreateHandle);
        }
        return this.handles.get(partitionPath);
    }

    private HoodieRowCreateHandle createHandle(String partitionPath) {
        return new HoodieRowCreateHandle(this.hoodieTable, this.writeConfig, partitionPath, this.getNextFileId(), this.instantTime, this.taskPartitionId, this.taskId, this.taskEpochId, this.structType, this.shouldPreserveHoodieMetadata);
    }

    protected String getNextFileId() {
        return String.format("%s-%d", this.fileIdPrefix, this.numFilesWritten++);
    }
}

