/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.util.ArrayList;
import java.util.List;
import org.apache.hudi.avro.model.HoodieRollbackPlan;
import org.apache.hudi.common.HoodieRollbackStat;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.rollback.BaseRollbackActionExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyOnWriteRollbackActionExecutor<T, I, K, O>
extends BaseRollbackActionExecutor<T, I, K, O> {
    private static final Logger LOG = LoggerFactory.getLogger(CopyOnWriteRollbackActionExecutor.class);

    public CopyOnWriteRollbackActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, HoodieInstant commitInstant, boolean deleteInstants, boolean skipLocking) {
        super(context, config, table, instantTime, commitInstant, deleteInstants, skipLocking, false);
    }

    public CopyOnWriteRollbackActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, HoodieInstant commitInstant, boolean deleteInstants, boolean skipTimelinePublish, boolean skipLocking) {
        super(context, config, table, instantTime, commitInstant, deleteInstants, skipTimelinePublish, skipLocking, false);
    }

    @Override
    protected List<HoodieRollbackStat> executeRollback(HoodieRollbackPlan hoodieRollbackPlan) {
        HoodieTimer rollbackTimer = HoodieTimer.start();
        List<HoodieRollbackStat> stats = new ArrayList<HoodieRollbackStat>();
        HoodieActiveTimeline activeTimeline = this.table.getActiveTimeline();
        if (this.instantToRollback.isCompleted()) {
            LOG.info("Unpublishing instant " + this.instantToRollback);
            this.resolvedInstant = activeTimeline.revertToInflight(this.instantToRollback);
            this.table.getMetaClient().reloadActiveTimeline();
        }
        if (!this.resolvedInstant.isRequested()) {
            LOG.info("Clean out all base files generated for commit: " + this.resolvedInstant);
            stats = this.executeRollback(this.resolvedInstant, hoodieRollbackPlan);
        }
        this.dropBootstrapIndexIfNeeded(this.instantToRollback);
        LOG.info("Time(in ms) taken to finish rollback " + rollbackTimer.endTimer());
        return stats;
    }
}

