/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;
import org.apache.hudi.table.upgrade.UpgradeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FourToFiveUpgradeHandler
implements UpgradeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FourToFiveUpgradeHandler.class);

    @Override
    public Map<ConfigProperty, String> upgrade(HoodieWriteConfig config, HoodieEngineContext context, String instantTime, SupportsUpgradeDowngrade upgradeDowngradeHelper) {
        try {
            HoodieTable table = upgradeDowngradeHelper.getTable(config, context);
            if (!config.doSkipDefaultPartitionValidation().booleanValue() && this.hasDefaultPartitionPath(config, table)) {
                LOG.error(String.format("\"%s\" partition detected. From 0.12, we are changing the default partition in hudi to %s  Please read and write back the data in \"%s\" partition in hudi to new partition path \"%s\". \"\n Sample spark command to use to re-write the data: \n\n val df = spark.read.format(\"hudi\").load(HUDI_TABLE_PATH).filter(col(\"PARTITION_PATH_COLUMN\") === \"%s\"); \t \n\n df.drop(\"_hoodie_commit_time\").drop(\"_hoodie_commit_seqno\").drop(\"_hoodie_record_key\")\"\n .drop(\"_hoodie_partition_path\").drop(\"_hoodie_file_name\").withColumn(PARTITION_PATH_COLUMN,\"%s\")\"\n .write.options(writeOptions).mode(Append).save(HUDI_TABLE_PATH);\t\n\"\n Please fix values for PARTITION_PATH_COLUMN, HUDI_TABLE_PATH and set all write configs in above command before running.  Also do delete the records in old partition once above command succeeds.  Sample spark command to delete old partition records: \n\n val df = spark.read.format(\"hudi\").load(HUDI_TABLE_PATH).filter(col(\"PARTITION_PATH_COLUMN\") === \"%s\"); \t \n\n df.write.option(\"hoodie.datasource.write.operation\",\"delete\").options(writeOptions).mode(Append).save(HUDI_TABLE_PATH);\t\n\"\n", "default", "__HIVE_DEFAULT_PARTITION__", "default", "__HIVE_DEFAULT_PARTITION__", "default", "__HIVE_DEFAULT_PARTITION__", "default"));
                throw new HoodieException(String.format("Old deprecated \"%s\" partition found in hudi table. This needs a migration step before we can upgrade ", "default"));
            }
            return Collections.emptyMap();
        }
        catch (IOException e) {
            LOG.error("Fetching file system instance failed", (Throwable)e);
            throw new HoodieException("Fetching FileSystem instance failed ", e);
        }
    }

    private boolean hasDefaultPartitionPath(HoodieWriteConfig config, HoodieTable table) throws IOException {
        HoodieTableConfig tableConfig = table.getMetaClient().getTableConfig();
        if (!tableConfig.getPartitionFields().isPresent()) {
            return false;
        }
        String checkPartitionPath = "default";
        boolean hiveStylePartitioningEnable = Boolean.parseBoolean(tableConfig.getHiveStylePartitioningEnable());
        if (hiveStylePartitioningEnable) {
            String[] partitions = tableConfig.getPartitionFields().get();
            checkPartitionPath = partitions[0] + "=" + "default";
        }
        FileSystem fs = new Path(config.getBasePath()).getFileSystem(table.getHadoopConf());
        return fs.exists(new Path(config.getBasePath() + "/" + checkPartitionPath));
    }
}

