/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.keygen.CustomAvroKeyGenerator;
import org.apache.hudi.keygen.CustomKeyGenerator;
import org.apache.hudi.keygen.GlobalAvroDeleteKeyGenerator;
import org.apache.hudi.keygen.GlobalDeleteKeyGenerator;
import org.apache.hudi.keygen.NonpartitionedAvroKeyGenerator;
import org.apache.hudi.keygen.NonpartitionedKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;

public final class SparkKeyGenUtils$ {
    public static SparkKeyGenUtils$ MODULE$;

    static {
        new SparkKeyGenUtils$();
    }

    public String getPartitionColumns(TypedProperties props) {
        String keyGeneratorClass = HoodieSparkKeyGeneratorFactory.getKeyGeneratorClassName(props);
        return this.getPartitionColumns(keyGeneratorClass, props);
    }

    public String getPartitionColumns(String keyGenClass, TypedProperties typedProperties) {
        String string;
        if (keyGenClass.equals(CustomKeyGenerator.class.getCanonicalName()) || keyGenClass.equals(CustomAvroKeyGenerator.class.getCanonicalName())) {
            string = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])typedProperties.getString(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key()).split(","))).map((Function1 & java.io.Serializable & Serializable)pathField -> (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathField.split(":"))).headOption().getOrElse((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(44).append("Illegal partition path field format: '").append((String)pathField).append("' for ").append(keyGenClass).toString()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",");
        } else if (keyGenClass.equals(NonpartitionedKeyGenerator.class.getCanonicalName()) || keyGenClass.equals(NonpartitionedAvroKeyGenerator.class.getCanonicalName()) || keyGenClass.equals(GlobalDeleteKeyGenerator.class.getCanonicalName()) || keyGenClass.equals(GlobalAvroDeleteKeyGenerator.class.getCanonicalName())) {
            string = "";
        } else {
            ValidationUtils.checkArgument(typedProperties.containsKey(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key()), "Partition path needs to be set");
            string = typedProperties.getString(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key());
        }
        return string;
    }

    private SparkKeyGenUtils$() {
        MODULE$ = this;
    }
}

