/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.callback.kafka;

import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;

@ConfigClassProperty(name="Write commit Kafka callback configs", groupName=ConfigGroups.Names.WRITE_CLIENT, subGroupName=ConfigGroups.SubGroupNames.COMMIT_CALLBACK, description="Controls notifications sent to Kafka, on events happening to a hudi table.")
public class HoodieWriteCommitKafkaCallbackConfig
extends HoodieConfig {
    public static final ConfigProperty<String> BOOTSTRAP_SERVERS = ConfigProperty.key("hoodie.write.commit.callback.kafka.bootstrap.servers").noDefaultValue().markAdvanced().sinceVersion("0.7.0").withDocumentation("Bootstrap servers of kafka cluster, to be used for publishing commit metadata.");
    public static final ConfigProperty<String> TOPIC = ConfigProperty.key("hoodie.write.commit.callback.kafka.topic").noDefaultValue().markAdvanced().sinceVersion("0.7.0").withDocumentation("Kafka topic name to publish timeline activity into.");
    public static final ConfigProperty<String> PARTITION = ConfigProperty.key("hoodie.write.commit.callback.kafka.partition").noDefaultValue().markAdvanced().sinceVersion("0.7.0").withDocumentation("It may be desirable to serialize all changes into a single Kafka partition  for providing strict ordering. By default, Kafka messages are keyed by table name, which  guarantees ordering at the table level, but not globally (or when new partitions are added)");
    public static final ConfigProperty<String> ACKS = ConfigProperty.key("hoodie.write.commit.callback.kafka.acks").defaultValue("all").markAdvanced().sinceVersion("0.7.0").withDocumentation("kafka acks level, all by default to ensure strong durability.");
    public static final ConfigProperty<Integer> RETRIES = ConfigProperty.key("hoodie.write.commit.callback.kafka.retries").defaultValue(3).markAdvanced().sinceVersion("0.7.0").withDocumentation("Times to retry the produce. 3 by default");
    @Deprecated
    public static final String CALLBACK_KAFKA_BOOTSTRAP_SERVERS = BOOTSTRAP_SERVERS.key();
    @Deprecated
    public static final String CALLBACK_KAFKA_TOPIC = TOPIC.key();
    @Deprecated
    public static final String CALLBACK_KAFKA_PARTITION = PARTITION.key();
    @Deprecated
    public static final String CALLBACK_KAFKA_ACKS = ACKS.key();
    @Deprecated
    public static final String DEFAULT_CALLBACK_KAFKA_ACKS = ACKS.defaultValue();
    @Deprecated
    public static final String CALLBACK_KAFKA_RETRIES = RETRIES.key();
    @Deprecated
    public static final int DEFAULT_CALLBACK_KAFKA_RETRIES = RETRIES.defaultValue();

    public static void setCallbackKafkaConfigIfNeeded(HoodieConfig config) {
        config.setDefaultValue(ACKS);
        config.setDefaultValue(RETRIES);
    }
}

