/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.hops.hudi.org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import io.hops.hudi.org.apache.http.ssl.SSLContextBuilder;
import io.hops.hudi.org.apache.http.ssl.SSLContexts;
import io.hops.hudi.org.apache.http.ssl.TrustStrategy;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Base64;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.internal.schema.HoodieSchemaException;
import org.apache.hudi.utilities.config.HoodieSchemaProviderConfig;
import org.apache.hudi.utilities.exception.HoodieSchemaFetchException;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.spark.api.java.JavaSparkContext;

public class SchemaRegistryProvider
extends SchemaProvider {
    private SSLSocketFactory sslSocketFactory;

    public Schema parseSchemaFromRegistry(String registryUrl) {
        String schema = this.fetchSchemaFromRegistry(registryUrl);
        try {
            String schemaConverter = ConfigUtils.getStringWithAltKeys(this.config, HoodieSchemaProviderConfig.SCHEMA_CONVERTER);
            SchemaConverter converter = !StringUtils.isNullOrEmpty(schemaConverter) ? (SchemaConverter)ReflectionUtils.loadClass(schemaConverter) : s -> s;
            return new Schema.Parser().parse(converter.convert(schema));
        }
        catch (Exception e) {
            throw new HoodieSchemaException("Failed to parse schema from registry: " + schema, e);
        }
    }

    public String fetchSchemaFromRegistry(String registryUrl) {
        try {
            HttpURLConnection connection;
            Matcher matcher = Pattern.compile("://(.*?)@").matcher(registryUrl);
            if (matcher.find()) {
                String creds = matcher.group(1);
                String urlWithoutCreds = registryUrl.replace(creds + "@", "");
                connection = this.getConnection(urlWithoutCreds);
                this.setAuthorizationHeader(matcher.group(1), connection);
            } else {
                connection = this.getConnection(registryUrl);
            }
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(this.getStream(connection));
            return node.get("schema").asText();
        }
        catch (Exception e) {
            throw new HoodieSchemaFetchException("Failed to fetch schema from registry", e);
        }
    }

    protected HttpURLConnection getConnection(String url2) throws IOException {
        URL registry = new URL(url2);
        if (this.sslSocketFactory != null) {
            HttpsURLConnection connection = (HttpsURLConnection)registry.openConnection();
            connection.setSSLSocketFactory(this.sslSocketFactory);
            return connection;
        }
        return (HttpURLConnection)registry.openConnection();
    }

    protected void setAuthorizationHeader(String creds, HttpURLConnection connection) {
        String encodedAuth = Base64.getEncoder().encodeToString(creds.getBytes(StandardCharsets.UTF_8));
        connection.setRequestProperty("Authorization", "Basic " + encodedAuth);
    }

    protected InputStream getStream(HttpURLConnection connection) throws IOException {
        return connection.getInputStream();
    }

    public SchemaRegistryProvider(TypedProperties props, JavaSparkContext jssc) {
        super(props, jssc);
        ConfigUtils.checkRequiredConfigProperties(props, Collections.singletonList(HoodieSchemaProviderConfig.SRC_SCHEMA_REGISTRY_URL));
        if (this.config.containsKey("schema.registry.ssl.keystore.location") || this.config.containsKey("schema.registry.ssl.truststore.location")) {
            this.setUpSSLStores();
        }
    }

    private void setUpSSLStores() {
        SSLContextBuilder sslContextBuilder = SSLContexts.custom();
        try {
            if (this.config.containsKey("schema.registry.ssl.truststore.location")) {
                sslContextBuilder.loadTrustMaterial(new File(this.config.getString("schema.registry.ssl.truststore.location")), this.config.getString("schema.registry.ssl.truststore.password").toCharArray(), (TrustStrategy)new TrustSelfSignedStrategy());
            }
            if (this.config.containsKey("schema.registry.ssl.keystore.location")) {
                sslContextBuilder.loadKeyMaterial(new File(this.config.getString("schema.registry.ssl.keystore.location")), this.config.getString("schema.registry.ssl.keystore.password").toCharArray(), this.config.getString("schema.registry.ssl.key.password").toCharArray());
            }
            this.sslSocketFactory = sslContextBuilder.build().getSocketFactory();
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Schema getSourceSchema() {
        String registryUrl = ConfigUtils.getStringWithAltKeys(this.config, HoodieSchemaProviderConfig.SRC_SCHEMA_REGISTRY_URL);
        try {
            return this.parseSchemaFromRegistry(registryUrl);
        }
        catch (Exception e) {
            throw new HoodieSchemaFetchException("Error reading source schema from registry :" + registryUrl, e);
        }
    }

    @Override
    public Schema getTargetSchema() {
        String registryUrl = ConfigUtils.getStringWithAltKeys(this.config, HoodieSchemaProviderConfig.SRC_SCHEMA_REGISTRY_URL);
        String targetRegistryUrl = ConfigUtils.getStringWithAltKeys(this.config, HoodieSchemaProviderConfig.TARGET_SCHEMA_REGISTRY_URL, registryUrl);
        try {
            return this.parseSchemaFromRegistry(targetRegistryUrl);
        }
        catch (Exception e) {
            throw new HoodieSchemaFetchException("Error reading target schema from registry :" + targetRegistryUrl, e);
        }
    }

    @FunctionalInterface
    public static interface SchemaConverter {
        public String convert(String var1) throws IOException;
    }

    public static class Config {
        @Deprecated
        public static final String SRC_SCHEMA_REGISTRY_URL_PROP = HoodieSchemaProviderConfig.SRC_SCHEMA_REGISTRY_URL.key();
        @Deprecated
        public static final String TARGET_SCHEMA_REGISTRY_URL_PROP = HoodieSchemaProviderConfig.TARGET_SCHEMA_REGISTRY_URL.key();
        @Deprecated
        public static final String SCHEMA_CONVERTER_PROP = HoodieSchemaProviderConfig.SCHEMA_CONVERTER.key();
        public static final String SSL_KEYSTORE_LOCATION_PROP = "schema.registry.ssl.keystore.location";
        public static final String SSL_TRUSTSTORE_LOCATION_PROP = "schema.registry.ssl.truststore.location";
        public static final String SSL_KEYSTORE_PASSWORD_PROP = "schema.registry.ssl.keystore.password";
        public static final String SSL_TRUSTSTORE_PASSWORD_PROP = "schema.registry.ssl.truststore.password";
        public static final String SSL_KEY_PASSWORD_PROP = "schema.registry.ssl.key.password";
    }
}

