/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import java.util.Collections;
import org.apache.hudi.DataSourceReadOptions;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.hudi.utilities.config.HoodieIncrSourceConfig;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.RowSource;
import org.apache.hudi.utilities.sources.SnapshotLoadQuerySplitter;
import org.apache.hudi.utilities.sources.helpers.IncrSourceHelper;
import org.apache.hudi.utilities.sources.helpers.QueryInfo;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieIncrSource
extends RowSource {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieIncrSource.class);
    private final Option<SnapshotLoadQuerySplitter> snapshotLoadQuerySplitter;

    public HoodieIncrSource(TypedProperties props, JavaSparkContext sparkContext, SparkSession sparkSession, SchemaProvider schemaProvider) {
        super(props, sparkContext, sparkSession, schemaProvider);
        this.snapshotLoadQuerySplitter = Option.ofNullable(props.getString("hoodie.deltastreamer.snapshotload.query.splitter.class.name", null)).map(className -> (SnapshotLoadQuerySplitter)ReflectionUtils.loadClass(className, new Class[]{TypedProperties.class}, new Object[]{props}));
    }

    @Override
    public Pair<Option<Dataset<Row>>, String> fetchNextBatch(Option<String> lastCkptStr, long sourceLimit) {
        Dataset source;
        IncrSourceHelper.MissingCheckpointStrategy missingCheckpointStrategy;
        ConfigUtils.checkRequiredConfigProperties(this.props, Collections.singletonList(HoodieIncrSourceConfig.HOODIE_SRC_BASE_PATH));
        String srcPath = ConfigUtils.getStringWithAltKeys(this.props, HoodieIncrSourceConfig.HOODIE_SRC_BASE_PATH);
        int numInstantsPerFetch = ConfigUtils.getIntWithAltKeys(this.props, HoodieIncrSourceConfig.NUM_INSTANTS_PER_FETCH);
        boolean readLatestOnMissingCkpt = ConfigUtils.getBooleanWithAltKeys(this.props, HoodieIncrSourceConfig.READ_LATEST_INSTANT_ON_MISSING_CKPT);
        IncrSourceHelper.MissingCheckpointStrategy missingCheckpointStrategy2 = missingCheckpointStrategy = ConfigUtils.containsConfigProperty(this.props, HoodieIncrSourceConfig.MISSING_CHECKPOINT_STRATEGY) ? IncrSourceHelper.MissingCheckpointStrategy.valueOf(ConfigUtils.getStringWithAltKeys(this.props, HoodieIncrSourceConfig.MISSING_CHECKPOINT_STRATEGY)) : null;
        if (readLatestOnMissingCkpt) {
            missingCheckpointStrategy = IncrSourceHelper.MissingCheckpointStrategy.READ_LATEST;
        }
        Option<String> beginInstant = lastCkptStr.isPresent() ? (lastCkptStr.get().isEmpty() ? Option.empty() : lastCkptStr) : Option.empty();
        TimelineUtils.HollowCommitHandling handlingMode = IncrSourceHelper.getHollowCommitHandleMode(this.props);
        QueryInfo queryInfo = IncrSourceHelper.generateQueryInfo(this.sparkContext, srcPath, numInstantsPerFetch, beginInstant, missingCheckpointStrategy, handlingMode, HoodieRecord.COMMIT_TIME_METADATA_FIELD, HoodieRecord.RECORD_KEY_METADATA_FIELD, null, false, Option.empty());
        if (queryInfo.areStartAndEndInstantsEqual()) {
            LOG.info("Already caught up. No new data to process");
            return Pair.of(Option.empty(), queryInfo.getEndInstant());
        }
        if (queryInfo.isIncremental()) {
            source = this.sparkSession.read().format("org.apache.hudi").option(DataSourceReadOptions.QUERY_TYPE().key(), DataSourceReadOptions.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions.BEGIN_INSTANTTIME().key(), queryInfo.getStartInstant()).option(DataSourceReadOptions.END_INSTANTTIME().key(), queryInfo.getEndInstant()).option(DataSourceReadOptions.INCREMENTAL_FALLBACK_TO_FULL_TABLE_SCAN_FOR_NON_EXISTING_FILES().key(), this.props.getString(DataSourceReadOptions.INCREMENTAL_FALLBACK_TO_FULL_TABLE_SCAN_FOR_NON_EXISTING_FILES().key(), DataSourceReadOptions.INCREMENTAL_FALLBACK_TO_FULL_TABLE_SCAN_FOR_NON_EXISTING_FILES().defaultValue())).option(DataSourceReadOptions.INCREMENTAL_READ_HANDLE_HOLLOW_COMMIT().key(), handlingMode.name()).load(srcPath);
        } else {
            Dataset snapshot = this.sparkSession.read().format("org.apache.hudi").option(DataSourceReadOptions.QUERY_TYPE().key(), DataSourceReadOptions.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(srcPath);
            if (this.snapshotLoadQuerySplitter.isPresent()) {
                queryInfo = this.snapshotLoadQuerySplitter.get().getNextCheckpoint((Dataset<Row>)snapshot, queryInfo);
            }
            source = snapshot.filter(String.format("%s > '%s'", HoodieRecord.COMMIT_TIME_METADATA_FIELD, queryInfo.getStartInstant())).filter(String.format("%s <= '%s'", HoodieRecord.COMMIT_TIME_METADATA_FIELD, queryInfo.getEndInstant()));
        }
        HoodieRecord.HoodieRecordType recordType = UtilHelpers.createRecordMerger(this.props).getRecordType();
        boolean shouldDropMetaFields = ConfigUtils.getBooleanWithAltKeys(this.props, HoodieIncrSourceConfig.HOODIE_DROP_ALL_META_FIELDS_FROM_SOURCE) || recordType == HoodieRecord.HoodieRecordType.SPARK;
        String[] colsToDrop = shouldDropMetaFields ? (String[])HoodieRecord.HOODIE_META_COLUMNS.stream().toArray(String[]::new) : (String[])HoodieRecord.HOODIE_META_COLUMNS.stream().filter(x -> !x.equals(HoodieRecord.PARTITION_PATH_METADATA_FIELD)).toArray(String[]::new);
        Dataset src = source.drop(colsToDrop);
        return Pair.of(Option.of(src), queryInfo.getEndInstant());
    }

    public static class Config {
        @Deprecated
        public static final String HOODIE_SRC_BASE_PATH = HoodieIncrSourceConfig.HOODIE_SRC_BASE_PATH.key();
        @Deprecated
        static final String NUM_INSTANTS_PER_FETCH = HoodieIncrSourceConfig.NUM_INSTANTS_PER_FETCH.key();
        @Deprecated
        static final Integer DEFAULT_NUM_INSTANTS_PER_FETCH = HoodieIncrSourceConfig.NUM_INSTANTS_PER_FETCH.defaultValue();
        @Deprecated
        static final String HOODIE_SRC_PARTITION_FIELDS = HoodieIncrSourceConfig.HOODIE_SRC_PARTITION_FIELDS.key();
        @Deprecated
        static final String HOODIE_SRC_PARTITION_EXTRACTORCLASS = HoodieIncrSourceConfig.HOODIE_SRC_PARTITION_EXTRACTORCLASS.key();
        @Deprecated
        static final String DEFAULT_HOODIE_SRC_PARTITION_EXTRACTORCLASS = HoodieIncrSourceConfig.HOODIE_SRC_PARTITION_EXTRACTORCLASS.defaultValue();
        @Deprecated
        public static final String READ_LATEST_INSTANT_ON_MISSING_CKPT = HoodieIncrSourceConfig.READ_LATEST_INSTANT_ON_MISSING_CKPT.key();
        @Deprecated
        public static final Boolean DEFAULT_READ_LATEST_INSTANT_ON_MISSING_CKPT = HoodieIncrSourceConfig.READ_LATEST_INSTANT_ON_MISSING_CKPT.defaultValue();
        @Deprecated
        public static final String MISSING_CHECKPOINT_STRATEGY = HoodieIncrSourceConfig.MISSING_CHECKPOINT_STRATEGY.key();
        @Deprecated
        static final String SOURCE_FILE_FORMAT = HoodieIncrSourceConfig.SOURCE_FILE_FORMAT.key();
        @Deprecated
        static final String DEFAULT_SOURCE_FILE_FORMAT = HoodieIncrSourceConfig.SOURCE_FILE_FORMAT.defaultValue();
        @Deprecated
        static final String HOODIE_DROP_ALL_META_FIELDS_FROM_SOURCE = HoodieIncrSourceConfig.HOODIE_DROP_ALL_META_FIELDS_FROM_SOURCE.key();
        @Deprecated
        public static final Boolean DEFAULT_HOODIE_DROP_ALL_META_FIELDS_FROM_SOURCE = HoodieIncrSourceConfig.HOODIE_DROP_ALL_META_FIELDS_FROM_SOURCE.defaultValue();
    }
}

