/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.RowSource;
import org.apache.hudi.utilities.sources.helpers.DFSPathSelector;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public class ParquetDFSSource
extends RowSource {
    private final DFSPathSelector pathSelector;

    public ParquetDFSSource(TypedProperties props, JavaSparkContext sparkContext, SparkSession sparkSession, SchemaProvider schemaProvider) {
        super(props, sparkContext, sparkSession, schemaProvider);
        this.pathSelector = DFSPathSelector.createSourceSelector(props, this.sparkContext.hadoopConfiguration());
    }

    @Override
    public Pair<Option<Dataset<Row>>, String> fetchNextBatch(Option<String> lastCkptStr, long sourceLimit) {
        Pair<Option<String>, String> selectPathsWithMaxModificationTime = this.pathSelector.getNextFilePathsAndMaxModificationTime(this.sparkContext, lastCkptStr, sourceLimit);
        return selectPathsWithMaxModificationTime.getLeft().map(pathStr -> Pair.of(Option.of(this.fromFiles((String)pathStr)), selectPathsWithMaxModificationTime.getRight())).orElseGet(() -> Pair.of(Option.empty(), selectPathsWithMaxModificationTime.getRight()));
    }

    private Dataset<Row> fromFiles(String pathStr) {
        return this.sparkSession.read().parquet(pathStr.split(","));
    }
}

