/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.helpers;

import com.google.protobuf.BoolValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.Message;
import com.google.protobuf.StringValue;
import com.google.protobuf.Timestamp;
import com.google.protobuf.UInt32Value;
import com.google.protobuf.UInt64Value;
import com.google.protobuf.util.Timestamps;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.kafka.common.utils.CopyOnWriteMap;

public class ProtoConversionUtil {
    public static Schema getAvroSchemaForMessageClass(Class clazz, SchemaConfig schemaConfig) {
        return new AvroSupport(schemaConfig).getSchema(clazz);
    }

    public static GenericRecord convertToAvro(Schema schema, Message message) {
        return AvroSupport.convert(schema, message);
    }

    static BigInteger toUnsignedBigInteger(long input) {
        if (input >= 0L) {
            return BigInteger.valueOf(input);
        }
        int upper = (int)(input >>> 32);
        int lower = (int)input;
        return BigInteger.valueOf(Integer.toUnsignedLong(upper)).shiftLeft(32).add(BigInteger.valueOf(Integer.toUnsignedLong(lower)));
    }

    private static class AvroSupport {
        private static final Schema STRING_SCHEMA = Schema.create((Schema.Type)Schema.Type.STRING);
        private static final Schema NULL_SCHEMA = Schema.create((Schema.Type)Schema.Type.NULL);
        private static final Schema UNSIGNED_LONG_SCHEMA = LogicalTypes.decimal((int)20).addToSchema(Schema.createFixed((String)"unsigned_long", null, (String)"org.apache.hudi.protos", (int)9));
        private static final Conversions.DecimalConversion DECIMAL_CONVERSION = new Conversions.DecimalConversion();
        private static final String OVERFLOW_DESCRIPTOR_FIELD_NAME = "descriptor_full_name";
        private static final String OVERFLOW_BYTES_FIELD_NAME = "proto_bytes";
        private static final Schema RECURSION_OVERFLOW_SCHEMA = Schema.createRecord((String)"recursion_overflow", null, (String)"org.apache.hudi.proto", (boolean)false, Arrays.asList(new Schema.Field("descriptor_full_name", STRING_SCHEMA, null, (Object)""), new Schema.Field("proto_bytes", Schema.create((Schema.Type)Schema.Type.BYTES), null, (Object)"".getBytes())));
        private static final Map<SchemaCacheKey, Schema> SCHEMA_CACHE = new ConcurrentHashMap<SchemaCacheKey, Schema>();
        private static final Map<Pair<Schema, Descriptors.Descriptor>, Descriptors.FieldDescriptor[]> FIELD_CACHE = new ConcurrentHashMap<Pair<Schema, Descriptors.Descriptor>, Descriptors.FieldDescriptor[]>();
        private static final Set<Descriptors.Descriptor> WRAPPER_DESCRIPTORS_TO_TYPE = CollectionUtils.createImmutableSet(StringValue.getDescriptor(), Int32Value.getDescriptor(), UInt32Value.getDescriptor(), Int64Value.getDescriptor(), UInt64Value.getDescriptor(), BoolValue.getDescriptor(), BytesValue.getDescriptor(), DoubleValue.getDescriptor(), FloatValue.getDescriptor());
        private final boolean wrappedPrimitivesAsRecords;
        private final int maxRecursionDepth;
        private final boolean timestampsAsRecords;

        private AvroSupport(SchemaConfig schemaConfig) {
            this.wrappedPrimitivesAsRecords = schemaConfig.isWrappedPrimitivesAsRecords();
            this.maxRecursionDepth = schemaConfig.getMaxRecursionDepth();
            this.timestampsAsRecords = schemaConfig.isTimestampsAsRecords();
        }

        public static GenericRecord convert(Schema schema, Message message) {
            return (GenericRecord)AvroSupport.convertObject(schema, message);
        }

        public Schema getSchema(Class c) {
            return SCHEMA_CACHE.computeIfAbsent(new SchemaCacheKey(c, this.wrappedPrimitivesAsRecords, this.maxRecursionDepth, this.timestampsAsRecords), key -> {
                try {
                    Object descriptor = c.getMethod("getDescriptor", new Class[0]).invoke(null, new Object[0]);
                    if (c.isEnum()) {
                        return this.getEnumSchema((Descriptors.EnumDescriptor)descriptor);
                    }
                    Descriptors.Descriptor castedDescriptor = (Descriptors.Descriptor)descriptor;
                    return this.getMessageSchema(castedDescriptor, new CopyOnWriteMap<Descriptors.Descriptor, Integer>(), this.getNamespace(castedDescriptor.getFullName()));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }

        private Schema getEnumSchema(Descriptors.EnumDescriptor enumDescriptor) {
            ArrayList<String> symbols = new ArrayList<String>(enumDescriptor.getValues().size());
            for (Descriptors.EnumValueDescriptor valueDescriptor : enumDescriptor.getValues()) {
                symbols.add(valueDescriptor.getName());
            }
            return Schema.createEnum((String)enumDescriptor.getName(), null, (String)this.getNamespace(enumDescriptor.getFullName()), symbols);
        }

        private Schema getMessageSchema(Descriptors.Descriptor descriptor, CopyOnWriteMap<Descriptors.Descriptor, Integer> recursionDepths, String path) {
            Integer currentRecursionCount = recursionDepths.getOrDefault(descriptor, 0);
            if (currentRecursionCount >= this.maxRecursionDepth) {
                return RECURSION_OVERFLOW_SCHEMA;
            }
            Schema result = Schema.createRecord((String)descriptor.getName(), null, (String)path, (boolean)false);
            currentRecursionCount = currentRecursionCount + 1;
            recursionDepths.put(descriptor, currentRecursionCount);
            ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>(descriptor.getFields().size());
            for (Descriptors.FieldDescriptor f : descriptor.getFields()) {
                fields.add(new Schema.Field(f.getName(), this.getFieldSchema(f, new CopyOnWriteMap<Descriptors.Descriptor, Integer>(recursionDepths), path), null, this.getDefault(f)));
            }
            result.setFields(fields);
            return result;
        }

        private Schema getFieldSchema(Descriptors.FieldDescriptor fieldDescriptor, CopyOnWriteMap<Descriptors.Descriptor, Integer> recursionDepths, String path) {
            switch (fieldDescriptor.getType()) {
                case BOOL: {
                    return AvroSupport.finalizeSchema(Schema.create((Schema.Type)Schema.Type.BOOLEAN), fieldDescriptor);
                }
                case FLOAT: {
                    return AvroSupport.finalizeSchema(Schema.create((Schema.Type)Schema.Type.FLOAT), fieldDescriptor);
                }
                case DOUBLE: {
                    return AvroSupport.finalizeSchema(Schema.create((Schema.Type)Schema.Type.DOUBLE), fieldDescriptor);
                }
                case ENUM: {
                    return AvroSupport.finalizeSchema(this.getEnumSchema(fieldDescriptor.getEnumType()), fieldDescriptor);
                }
                case STRING: {
                    Schema stringSchema = Schema.create((Schema.Type)Schema.Type.STRING);
                    GenericData.setStringType((Schema)stringSchema, (GenericData.StringType)GenericData.StringType.String);
                    return AvroSupport.finalizeSchema(stringSchema, fieldDescriptor);
                }
                case BYTES: {
                    return AvroSupport.finalizeSchema(Schema.create((Schema.Type)Schema.Type.BYTES), fieldDescriptor);
                }
                case INT32: 
                case SINT32: 
                case FIXED32: 
                case SFIXED32: {
                    return AvroSupport.finalizeSchema(Schema.create((Schema.Type)Schema.Type.INT), fieldDescriptor);
                }
                case UINT32: 
                case INT64: 
                case SINT64: 
                case FIXED64: 
                case SFIXED64: {
                    return AvroSupport.finalizeSchema(Schema.create((Schema.Type)Schema.Type.LONG), fieldDescriptor);
                }
                case UINT64: {
                    return AvroSupport.finalizeSchema(UNSIGNED_LONG_SCHEMA, fieldDescriptor);
                }
                case MESSAGE: {
                    String updatedPath = this.appendFieldNameToPath(path, fieldDescriptor.getName());
                    if (!this.wrappedPrimitivesAsRecords && WRAPPER_DESCRIPTORS_TO_TYPE.contains(fieldDescriptor.getMessageType())) {
                        Schema nestedFieldSchema = this.getFieldSchema((Descriptors.FieldDescriptor)fieldDescriptor.getMessageType().getFields().get(0), recursionDepths, updatedPath);
                        return AvroSupport.finalizeSchema(AvroSupport.makeSchemaNullable(nestedFieldSchema), fieldDescriptor);
                    }
                    if (!this.timestampsAsRecords && Timestamp.getDescriptor().equals(fieldDescriptor.getMessageType())) {
                        Schema timestampSchema = LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
                        return AvroSupport.finalizeSchema(AvroSupport.makeSchemaNullable(timestampSchema), fieldDescriptor);
                    }
                    if (fieldDescriptor.isRepeated()) {
                        Schema elementSchema = this.getMessageSchema(fieldDescriptor.getMessageType(), recursionDepths, updatedPath);
                        return AvroSupport.finalizeSchema(elementSchema, fieldDescriptor);
                    }
                    Schema fieldSchema = this.getMessageSchema(fieldDescriptor.getMessageType(), recursionDepths, updatedPath);
                    return AvroSupport.finalizeSchema(AvroSupport.makeSchemaNullable(fieldSchema), fieldDescriptor);
                }
            }
            throw new RuntimeException("Unexpected type: " + fieldDescriptor.getType());
        }

        private static Schema finalizeSchema(Schema schema, Descriptors.FieldDescriptor fieldDescriptor) {
            Schema updatedSchema = schema;
            if (fieldDescriptor.isRepeated()) {
                updatedSchema = Schema.createArray((Schema)updatedSchema);
            }
            if (fieldDescriptor.getContainingOneof() != null && (schema.getType() != Schema.Type.UNION || ((Schema)schema.getTypes().get(0)).getType() != Schema.Type.NULL)) {
                updatedSchema = AvroSupport.makeSchemaNullable(updatedSchema);
            }
            return updatedSchema;
        }

        private static Schema makeSchemaNullable(Schema schema) {
            return Schema.createUnion(Arrays.asList(NULL_SCHEMA, schema));
        }

        private Object getDefault(Descriptors.FieldDescriptor f) {
            if (f.isRepeated()) {
                return Collections.emptyList();
            }
            if (f.getContainingOneof() != null) {
                return Schema.Field.NULL_VALUE;
            }
            switch (f.getType()) {
                case BOOL: {
                    return false;
                }
                case FLOAT: {
                    return Float.valueOf(0.0f);
                }
                case DOUBLE: {
                    return 0.0;
                }
                case INT32: 
                case SINT32: 
                case FIXED32: 
                case SFIXED32: 
                case UINT32: 
                case INT64: 
                case SINT64: 
                case FIXED64: 
                case SFIXED64: {
                    return 0;
                }
                case UINT64: {
                    return "\u0000";
                }
                case STRING: 
                case BYTES: {
                    return "";
                }
                case ENUM: {
                    return ((Descriptors.EnumValueDescriptor)f.getEnumType().getValues().get(0)).getName();
                }
                case MESSAGE: {
                    return Schema.Field.NULL_VALUE;
                }
            }
            throw new RuntimeException("Unexpected type: " + f.getType());
        }

        private static Descriptors.FieldDescriptor[] getOrderedFields(Schema schema, Message message) {
            Descriptors.Descriptor descriptor = message.getDescriptorForType();
            return FIELD_CACHE.computeIfAbsent(Pair.of(schema, descriptor), key -> {
                Descriptors.FieldDescriptor[] fields = new Descriptors.FieldDescriptor[((Schema)key.getLeft()).getFields().size()];
                for (Schema.Field f : ((Schema)key.getLeft()).getFields()) {
                    fields[f.pos()] = ((Descriptors.Descriptor)key.getRight()).findFieldByName(f.name());
                }
                return fields;
            });
        }

        private static Object convertObject(Schema schema, Object value) {
            if (value == null) {
                return null;
            }
            if (RECURSION_OVERFLOW_SCHEMA.getFullName().equals(schema.getFullName())) {
                GenericData.Record overflowRecord = new GenericData.Record(schema);
                Message messageValue = (Message)value;
                overflowRecord.put(OVERFLOW_DESCRIPTOR_FIELD_NAME, (Object)messageValue.getDescriptorForType().getFullName());
                overflowRecord.put(OVERFLOW_BYTES_FIELD_NAME, (Object)ByteBuffer.wrap(messageValue.toByteArray()));
                return overflowRecord;
            }
            switch (schema.getType()) {
                case ARRAY: {
                    List arrayValue = (List)value;
                    GenericData.Array arrayCopy = new GenericData.Array(arrayValue.size(), schema);
                    for (Object obj : arrayValue) {
                        arrayCopy.add(AvroSupport.convertObject(schema.getElementType(), obj));
                    }
                    return arrayCopy;
                }
                case BYTES: {
                    ByteBuffer byteBufferValue = value instanceof ByteString ? ((ByteString)value).asReadOnlyByteBuffer() : (value instanceof Message ? ((ByteString)AvroSupport.getWrappedValue(value)).asReadOnlyByteBuffer() : (ByteBuffer)value);
                    int start2 = byteBufferValue.position();
                    int length = byteBufferValue.limit() - start2;
                    byte[] bytesCopy = new byte[length];
                    byteBufferValue.get(bytesCopy, 0, length);
                    byteBufferValue.position(start2);
                    return ByteBuffer.wrap(bytesCopy, 0, length);
                }
                case ENUM: {
                    return GenericData.get().createEnum(value.toString(), schema);
                }
                case FIXED: {
                    if (value instanceof byte[]) {
                        return GenericData.get().createFixed(null, (byte[])value, schema);
                    }
                    Object unsignedLongValue = value;
                    if (unsignedLongValue instanceof UInt64Value) {
                        unsignedLongValue = AvroSupport.getWrappedValue(unsignedLongValue);
                    } else if (unsignedLongValue instanceof Message) {
                        throw new HoodieException("Unexpected Message type when converting as an unsigned long: " + unsignedLongValue.getClass().getName());
                    }
                    return DECIMAL_CONVERSION.toFixed(new BigDecimal(ProtoConversionUtil.toUnsignedBigInteger((Long)unsignedLongValue)), schema, schema.getLogicalType());
                }
                case BOOLEAN: 
                case DOUBLE: 
                case FLOAT: 
                case INT: {
                    if (value instanceof Message) {
                        return AvroSupport.getWrappedValue(value);
                    }
                    return value;
                }
                case LONG: {
                    Object tmpValue = value;
                    if (value instanceof Message) {
                        if (LogicalTypes.timestampMicros().equals(schema.getLogicalType())) {
                            return Timestamps.toMicros((Timestamp)((Timestamp)value));
                        }
                        tmpValue = AvroSupport.getWrappedValue(value);
                    }
                    if (tmpValue instanceof Integer) {
                        tmpValue = new Long(((Integer)tmpValue).intValue());
                    }
                    return tmpValue;
                }
                case MAP: {
                    Map mapValue = (Map)value;
                    HashMap<Object, Object> mapCopy = new HashMap<Object, Object>(mapValue.size());
                    for (Map.Entry entry : mapValue.entrySet()) {
                        mapCopy.put(AvroSupport.convertObject(STRING_SCHEMA, entry.getKey()), AvroSupport.convertObject(schema.getValueType(), entry.getValue()));
                    }
                    return mapCopy;
                }
                case NULL: {
                    return null;
                }
                case RECORD: {
                    GenericData.Record newRecord = new GenericData.Record(schema);
                    Message messageValue = (Message)value;
                    for (Schema.Field field : schema.getFields()) {
                        int position = field.pos();
                        Descriptors.FieldDescriptor fieldDescriptor = AvroSupport.getOrderedFields(schema, messageValue)[position];
                        Object convertedValue = field.schema().getType() == Schema.Type.UNION && !fieldDescriptor.isRepeated() && !messageValue.hasField(fieldDescriptor) ? null : AvroSupport.convertObject(field.schema(), messageValue.getField(fieldDescriptor));
                        newRecord.put(position, convertedValue);
                    }
                    return newRecord;
                }
                case STRING: {
                    if (value instanceof String) {
                        return value;
                    }
                    if (value instanceof StringValue) {
                        return ((StringValue)value).getValue();
                    }
                    return new Utf8(value.toString());
                }
                case UNION: {
                    return AvroSupport.convertObject((Schema)schema.getTypes().get(1), value);
                }
            }
            throw new HoodieException("Proto to Avro conversion failed for schema \"" + schema + "\" and value \"" + value + "\"");
        }

        private static Object getWrappedValue(Object value) {
            Message valueAsMessage = (Message)value;
            return valueAsMessage.getField((Descriptors.FieldDescriptor)valueAsMessage.getDescriptorForType().getFields().get(0));
        }

        private String getNamespace(String descriptorFullName) {
            int lastDotIndex = descriptorFullName.lastIndexOf(46);
            return descriptorFullName.substring(0, lastDotIndex);
        }

        private String appendFieldNameToPath(String existingPath, String fieldName) {
            return existingPath + "." + fieldName;
        }

        private static class SchemaCacheKey {
            private final String className;
            private final boolean wrappedPrimitivesAsRecords;
            private final int maxRecursionDepth;
            private final boolean timestampsAsRecords;

            SchemaCacheKey(Class<?> clazz, boolean wrappedPrimitivesAsRecords, int maxRecursionDepth, boolean timestampsAsRecords) {
                this.className = clazz.getName();
                this.wrappedPrimitivesAsRecords = wrappedPrimitivesAsRecords;
                this.maxRecursionDepth = maxRecursionDepth;
                this.timestampsAsRecords = timestampsAsRecords;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                SchemaCacheKey that = (SchemaCacheKey)o;
                return this.wrappedPrimitivesAsRecords == that.wrappedPrimitivesAsRecords && this.maxRecursionDepth == that.maxRecursionDepth && this.timestampsAsRecords == that.timestampsAsRecords && this.className.equals(that.className);
            }

            public int hashCode() {
                return Objects.hash(this.className, this.wrappedPrimitivesAsRecords, this.maxRecursionDepth, this.timestampsAsRecords);
            }
        }
    }

    public static class SchemaConfig {
        private final boolean wrappedPrimitivesAsRecords;
        private final int maxRecursionDepth;
        private final boolean timestampsAsRecords;

        public SchemaConfig(boolean wrappedPrimitivesAsRecords, int maxRecursionDepth, boolean timestampsAsRecords) {
            this.wrappedPrimitivesAsRecords = wrappedPrimitivesAsRecords;
            this.maxRecursionDepth = maxRecursionDepth;
            this.timestampsAsRecords = timestampsAsRecords;
        }

        public boolean isWrappedPrimitivesAsRecords() {
            return this.wrappedPrimitivesAsRecords;
        }

        public boolean isTimestampsAsRecords() {
            return this.timestampsAsRecords;
        }

        public int getMaxRecursionDepth() {
            return this.maxRecursionDepth;
        }
    }
}

