/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.helpers.gcs;

import java.io.Serializable;
import java.util.List;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.utilities.config.CloudSourceConfig;
import org.apache.hudi.utilities.sources.helpers.CloudObjectMetadata;
import org.apache.hudi.utilities.sources.helpers.CloudObjectsSelectorCommon;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcsObjectMetadataFetcher
implements Serializable {
    private final String fileFormat;
    private final TypedProperties props;
    private static final String GCS_PREFIX = "gs://";
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(GcsObjectMetadataFetcher.class);

    public GcsObjectMetadataFetcher(TypedProperties props, String fileFormat) {
        this.props = props;
        this.fileFormat = fileFormat;
    }

    public List<CloudObjectMetadata> getGcsObjectMetadata(JavaSparkContext jsc, Dataset<Row> cloudObjectMetadataDF, boolean checkIfExists) {
        SerializableConfiguration serializableHadoopConf = new SerializableConfiguration(jsc.hadoopConfiguration());
        return cloudObjectMetadataDF.select("bucket", new String[]{"name", "size"}).distinct().mapPartitions(CloudObjectsSelectorCommon.getCloudObjectMetadataPerPartition(GCS_PREFIX, serializableHadoopConf, checkIfExists), Encoders.kryo(CloudObjectMetadata.class)).collectAsList();
    }

    public Dataset<Row> applyFilter(Dataset<Row> cloudObjectMetadataDF) {
        String filter = this.createFilter();
        LOG.info("Adding filter string to Dataset: " + filter);
        return cloudObjectMetadataDF.filter(filter);
    }

    private String createFilter() {
        StringBuilder filter = new StringBuilder("size > 0");
        this.getPropVal(CloudSourceConfig.SELECT_RELATIVE_PATH_PREFIX).ifPresent(val -> filter.append(" and name like '" + val + "%'"));
        this.getPropVal(CloudSourceConfig.IGNORE_RELATIVE_PATH_PREFIX).ifPresent(val -> filter.append(" and name not like '" + val + "%'"));
        this.getPropVal(CloudSourceConfig.IGNORE_RELATIVE_PATH_SUBSTR).ifPresent(val -> filter.append(" and name not like '%" + val + "%'"));
        this.getPropVal(CloudSourceConfig.CLOUD_DATAFILE_EXTENSION).or(() -> Option.of(this.fileFormat)).map(val -> filter.append(" and name like '%" + val + "'"));
        return filter.toString();
    }

    private Option<String> getPropVal(ConfigProperty<String> configProperty) {
        String value = ConfigUtils.getStringWithAltKeys(this.props, configProperty, true);
        if (!StringUtils.isNullOrEmpty(value)) {
            return Option.of(value);
        }
        return Option.empty();
    }
}

