/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class AddPartitionsToTxnResponseData
implements ApiMessage {
    int throttleTimeMs;
    AddPartitionsToTxnTopicResultCollection results;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 3;

    public AddPartitionsToTxnResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public AddPartitionsToTxnResponseData() {
        this.throttleTimeMs = 0;
        this.results = new AddPartitionsToTxnTopicResultCollection(0);
    }

    @Override
    public short apiKey() {
        return 24;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 3;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i;
        AddPartitionsToTxnTopicResultCollection newCollection;
        int arrayLength;
        this.throttleTimeMs = _readable.readInt();
        if (_version >= 3) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field results was serialized as null");
            }
            newCollection = new AddPartitionsToTxnTopicResultCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new AddPartitionsToTxnTopicResult(_readable, _version));
            }
            this.results = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field results was serialized as null");
            }
            newCollection = new AddPartitionsToTxnTopicResultCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new AddPartitionsToTxnTopicResult(_readable, _version));
            }
            this.results = newCollection;
        }
        this._unknownTaggedFields = null;
        if (_version >= 3) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        if (_version >= 3) {
            _writable.writeUnsignedVarint(this.results.size() + 1);
            for (AddPartitionsToTxnTopicResult resultsElement : this.results) {
                resultsElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.results.size());
            for (AddPartitionsToTxnTopicResult resultsElement : this.results) {
                resultsElement.write(_writable, _cache, _version);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 3) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        if (_version >= 3) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.results.size() + 1));
        } else {
            _size.addBytes(4);
        }
        for (AddPartitionsToTxnTopicResult resultsElement : this.results) {
            resultsElement.addSize(_size, _cache, _version);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 3) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AddPartitionsToTxnResponseData)) {
            return false;
        }
        AddPartitionsToTxnResponseData other = (AddPartitionsToTxnResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.results == null ? other.results != null : !this.results.equals(other.results)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.results == null ? 0 : this.results.hashCode());
        return hashCode;
    }

    @Override
    public AddPartitionsToTxnResponseData duplicate() {
        AddPartitionsToTxnResponseData _duplicate = new AddPartitionsToTxnResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        AddPartitionsToTxnTopicResultCollection newResults = new AddPartitionsToTxnTopicResultCollection(this.results.size());
        for (AddPartitionsToTxnTopicResult _element : this.results) {
            newResults.add(_element.duplicate());
        }
        _duplicate.results = newResults;
        return _duplicate;
    }

    public String toString() {
        return "AddPartitionsToTxnResponseData(throttleTimeMs=" + this.throttleTimeMs + ", results=" + MessageUtil.deepToString(this.results.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public AddPartitionsToTxnTopicResultCollection results() {
        return this.results;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AddPartitionsToTxnResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public AddPartitionsToTxnResponseData setResults(AddPartitionsToTxnTopicResultCollection v) {
        this.results = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "Duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("results", new ArrayOf(AddPartitionsToTxnTopicResult.SCHEMA_0), "The results for each topic.")));
        SCHEMA_3 = new Schema(new Field("throttle_time_ms", Type.INT32, "Duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("results", new CompactArrayOf(AddPartitionsToTxnTopicResult.SCHEMA_3), "The results for each topic."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    }

    public static class AddPartitionsToTxnTopicResultCollection
    extends ImplicitLinkedHashMultiCollection<AddPartitionsToTxnTopicResult> {
        public AddPartitionsToTxnTopicResultCollection() {
        }

        public AddPartitionsToTxnTopicResultCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public AddPartitionsToTxnTopicResultCollection(Iterator<AddPartitionsToTxnTopicResult> iterator2) {
            super(iterator2);
        }

        @Override
        public AddPartitionsToTxnTopicResult find(String name) {
            AddPartitionsToTxnTopicResult _key = new AddPartitionsToTxnTopicResult();
            _key.setName(name);
            return this.find(_key);
        }

        @Override
        public List<AddPartitionsToTxnTopicResult> findAll(String name) {
            AddPartitionsToTxnTopicResult _key = new AddPartitionsToTxnTopicResult();
            _key.setName(name);
            return this.findAll(_key);
        }

        public AddPartitionsToTxnTopicResultCollection duplicate() {
            AddPartitionsToTxnTopicResultCollection _duplicate = new AddPartitionsToTxnTopicResultCollection(this.size());
            for (AddPartitionsToTxnTopicResult _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class AddPartitionsToTxnPartitionResultCollection
    extends ImplicitLinkedHashMultiCollection<AddPartitionsToTxnPartitionResult> {
        public AddPartitionsToTxnPartitionResultCollection() {
        }

        public AddPartitionsToTxnPartitionResultCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public AddPartitionsToTxnPartitionResultCollection(Iterator<AddPartitionsToTxnPartitionResult> iterator2) {
            super(iterator2);
        }

        @Override
        public AddPartitionsToTxnPartitionResult find(int partitionIndex) {
            AddPartitionsToTxnPartitionResult _key = new AddPartitionsToTxnPartitionResult();
            _key.setPartitionIndex(partitionIndex);
            return this.find(_key);
        }

        @Override
        public List<AddPartitionsToTxnPartitionResult> findAll(int partitionIndex) {
            AddPartitionsToTxnPartitionResult _key = new AddPartitionsToTxnPartitionResult();
            _key.setPartitionIndex(partitionIndex);
            return this.findAll(_key);
        }

        public AddPartitionsToTxnPartitionResultCollection duplicate() {
            AddPartitionsToTxnPartitionResultCollection _duplicate = new AddPartitionsToTxnPartitionResultCollection(this.size());
            for (AddPartitionsToTxnPartitionResult _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class AddPartitionsToTxnPartitionResult
    implements Message,
    ImplicitLinkedHashCollection.Element {
        int partitionIndex;
        short errorCode;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public AddPartitionsToTxnPartitionResult(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public AddPartitionsToTxnPartitionResult() {
            this.partitionIndex = 0;
            this.errorCode = 0;
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AddPartitionsToTxnPartitionResult");
            }
            this.partitionIndex = _readable.readInt();
            this.errorCode = _readable.readShort();
            this._unknownTaggedFields = null;
            if (_version >= 3) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            _writable.writeShort(this.errorCode);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 3) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of AddPartitionsToTxnPartitionResult");
            }
            _size.addBytes(4);
            _size.addBytes(2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 3) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof AddPartitionsToTxnPartitionResult)) {
                return false;
            }
            AddPartitionsToTxnPartitionResult other = (AddPartitionsToTxnPartitionResult)obj;
            return this.partitionIndex == other.partitionIndex;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AddPartitionsToTxnPartitionResult)) {
                return false;
            }
            AddPartitionsToTxnPartitionResult other = (AddPartitionsToTxnPartitionResult)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            return hashCode;
        }

        @Override
        public AddPartitionsToTxnPartitionResult duplicate() {
            AddPartitionsToTxnPartitionResult _duplicate = new AddPartitionsToTxnPartitionResult();
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.errorCode = this.errorCode;
            return _duplicate;
        }

        public String toString() {
            return "AddPartitionsToTxnPartitionResult(partitionIndex=" + this.partitionIndex + ", errorCode=" + this.errorCode + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public short errorCode() {
            return this.errorCode;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public AddPartitionsToTxnPartitionResult setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public AddPartitionsToTxnPartitionResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition indexes."), new Field("error_code", Type.INT16, "The response error code.")));
            SCHEMA_3 = new Schema(new Field("partition_index", Type.INT32, "The partition indexes."), new Field("error_code", Type.INT16, "The response error code."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }

    public static class AddPartitionsToTxnTopicResult
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        AddPartitionsToTxnPartitionResultCollection results;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public AddPartitionsToTxnTopicResult(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public AddPartitionsToTxnTopicResult() {
            this.name = "";
            this.results = new AddPartitionsToTxnPartitionResultCollection(0);
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public void read(Readable _readable, short _version) {
            int i;
            AddPartitionsToTxnPartitionResultCollection newCollection;
            int arrayLength;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AddPartitionsToTxnTopicResult");
            }
            int length = _version >= 3 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            if (_version >= 3) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field results was serialized as null");
                }
                newCollection = new AddPartitionsToTxnPartitionResultCollection(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new AddPartitionsToTxnPartitionResult(_readable, _version));
                }
                this.results = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field results was serialized as null");
                }
                newCollection = new AddPartitionsToTxnPartitionResultCollection(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new AddPartitionsToTxnPartitionResult(_readable, _version));
                }
                this.results = newCollection;
            }
            this._unknownTaggedFields = null;
            if (_version >= 3) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            if (_version >= 3) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 3) {
                _writable.writeUnsignedVarint(this.results.size() + 1);
                _stringBytes = this.results.iterator();
                while (_stringBytes.hasNext()) {
                    AddPartitionsToTxnPartitionResult resultsElement = (AddPartitionsToTxnPartitionResult)_stringBytes.next();
                    resultsElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.results.size());
                _stringBytes = this.results.iterator();
                while (_stringBytes.hasNext()) {
                    AddPartitionsToTxnPartitionResult resultsElement = (AddPartitionsToTxnPartitionResult)_stringBytes.next();
                    resultsElement.write(_writable, _cache, _version);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 3) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of AddPartitionsToTxnTopicResult");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            if (_version >= 3) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version >= 3) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.results.size() + 1));
            } else {
                _size.addBytes(4);
            }
            for (AddPartitionsToTxnPartitionResult resultsElement : this.results) {
                resultsElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 3) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof AddPartitionsToTxnTopicResult)) {
                return false;
            }
            AddPartitionsToTxnTopicResult other = (AddPartitionsToTxnTopicResult)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AddPartitionsToTxnTopicResult)) {
                return false;
            }
            AddPartitionsToTxnTopicResult other = (AddPartitionsToTxnTopicResult)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.results == null ? other.results != null : !this.results.equals(other.results)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        @Override
        public AddPartitionsToTxnTopicResult duplicate() {
            AddPartitionsToTxnTopicResult _duplicate = new AddPartitionsToTxnTopicResult();
            _duplicate.name = this.name;
            AddPartitionsToTxnPartitionResultCollection newResults = new AddPartitionsToTxnPartitionResultCollection(this.results.size());
            for (AddPartitionsToTxnPartitionResult _element : this.results) {
                newResults.add(_element.duplicate());
            }
            _duplicate.results = newResults;
            return _duplicate;
        }

        public String toString() {
            return "AddPartitionsToTxnTopicResult(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", results=" + MessageUtil.deepToString(this.results.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public AddPartitionsToTxnPartitionResultCollection results() {
            return this.results;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public AddPartitionsToTxnTopicResult setName(String v) {
            this.name = v;
            return this;
        }

        public AddPartitionsToTxnTopicResult setResults(AddPartitionsToTxnPartitionResultCollection v) {
            this.results = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("results", new ArrayOf(AddPartitionsToTxnPartitionResult.SCHEMA_0), "The results for each partition")));
            SCHEMA_3 = new Schema(new Field("name", Type.COMPACT_STRING, "The topic name."), new Field("results", new CompactArrayOf(AddPartitionsToTxnPartitionResult.SCHEMA_3), "The results for each partition"), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }
}

