/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.Serializable;
import java.util.function.Supplier;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.HelpProcedure$;
import org.apache.spark.sql.hudi.command.procedures.HoodieProcedures$;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001\u0002\n\u0014\u0001\tBQ\u0001\r\u0001\u0005\u0002EBqa\r\u0001C\u0002\u0013%A\u0007\u0003\u0004?\u0001\u0001\u0006I!\u000e\u0005\b\u007f\u0001\u0011\r\u0011\"\u0003A\u0011\u00199\u0005\u0001)A\u0005\u0003\")\u0001\n\u0001C!\u0013\")Q\u000b\u0001C\u0001i!)a\u000b\u0001C\u0001\u0001\")q\u000b\u0001C!1\")1\u000e\u0001C\u0001Y\")q\u000e\u0001C!a\u001e)\u0011o\u0005E\u0001e\u001a)!c\u0005E\u0001g\")\u0001'\u0004C\u0001o\"9\u00010\u0004b\u0001\n\u0003I\bbBA\u0002\u001b\u0001\u0006IA\u001f\u0005\b\u0003\u000biA\u0011AA\u0004\u00055AU\r\u001c9Qe>\u001cW\rZ;sK*\u0011A#F\u0001\u000baJ|7-\u001a3ve\u0016\u001c(B\u0001\f\u0018\u0003\u001d\u0019w.\\7b]\u0012T!\u0001G\r\u0002\t!,H-\u001b\u0006\u00035m\t1a]9m\u0015\taR$A\u0003ta\u0006\u00148N\u0003\u0002\u001f?\u00051\u0011\r]1dQ\u0016T\u0011\u0001I\u0001\u0004_J<7\u0001A\n\u0005\u0001\r:#\u0006\u0005\u0002%K5\t1#\u0003\u0002''\ti!)Y:f!J|7-\u001a3ve\u0016\u0004\"\u0001\n\u0015\n\u0005%\u001a\"\u0001\u0005)s_\u000e,G-\u001e:f\u0005VLG\u000eZ3s!\tYc&D\u0001-\u0015\ti3$\u0001\u0005j]R,'O\\1m\u0013\tyCFA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005\u0011\u0004C\u0001\u0013\u0001\u0003)\u0001\u0016IU!N\u000bR+%kU\u000b\u0002kA\u0019a'O\u001e\u000e\u0003]R\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003u]\u0012Q!\u0011:sCf\u0004\"\u0001\n\u001f\n\u0005u\u001a\"A\u0005)s_\u000e,G-\u001e:f!\u0006\u0014\u0018-\\3uKJ\f1\u0002U!S\u00036+E+\u0012*TA\u0005Yq*\u0016+Q+R{F+\u0017)F+\u0005\t\u0005C\u0001\"F\u001b\u0005\u0019%B\u0001#\u001a\u0003\u0015!\u0018\u0010]3t\u0013\t15I\u0001\u0006TiJ,8\r\u001e+za\u0016\fAbT+U!V#v\fV-Q\u000b\u0002\n1\u0002Z3tGJL\u0007\u000f^5p]V\t!\n\u0005\u0002L%:\u0011A\n\u0015\t\u0003\u001b^j\u0011A\u0014\u0006\u0003\u001f\u0006\na\u0001\u0010:p_Rt\u0014BA)8\u0003\u0019\u0001&/\u001a3fM&\u00111\u000b\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005E;\u0014A\u00039be\u0006lW\r^3sg\u0006Qq.\u001e;qkR$\u0016\u0010]3\u0002\t\r\fG\u000e\u001c\u000b\u00033\u001a\u00042AW0c\u001d\tYVL\u0004\u0002N9&\t\u0001(\u0003\u0002_o\u00059\u0001/Y2lC\u001e,\u0017B\u00011b\u0005\r\u0019V-\u001d\u0006\u0003=^\u0002\"a\u00193\u000e\u0003eI!!Z\r\u0003\u0007I{w\u000fC\u0003h\u0013\u0001\u0007\u0001.\u0001\u0003be\u001e\u001c\bC\u0001\u0013j\u0013\tQ7CA\u0007Qe>\u001cW\rZ;sK\u0006\u0013xm]\u0001\rY\u0016tw\r\u001e5G_Jl\u0017\r\u001e\u000b\u0003\u00156DQA\u001c\u0006A\u0002)\u000baa\u001d;sS:<\u0017!\u00022vS2$W#\u0001\u001a\u0002\u001b!+G\u000e\u001d)s_\u000e,G-\u001e:f!\t!Sb\u0005\u0002\u000eiB\u0011a'^\u0005\u0003m^\u0012a!\u00118z%\u00164G#\u0001:\u0002\t9\u000bU*R\u000b\u0002uB\u001910!\u0001\u000e\u0003qT!! @\u0002\t1\fgn\u001a\u0006\u0002\u007f\u0006!!.\u0019<b\u0013\t\u0019F0A\u0003O\u00036+\u0005%A\u0004ck&dG-\u001a:\u0016\u0005\u0005%\u0001#BA\u0006\u0003+9SBAA\u0007\u0015\u0011\ty!!\u0005\u0002\u0011\u0019,hn\u0019;j_:T1!a\u0005\u007f\u0003\u0011)H/\u001b7\n\t\u0005]\u0011Q\u0002\u0002\t'V\u0004\b\u000f\\5fe\u0002")
public class HelpProcedure
extends BaseProcedure
implements ProcedureBuilder,
Logging {
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Supplier<ProcedureBuilder> builder() {
        return HelpProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return HelpProcedure$.MODULE$.NAME();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public String description() {
        return "The procedure help command allows you to view all the commands currently provided, as well as their parameters and output fields.";
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args2) {
        Seq seq;
        super.checkArgs(this.PARAMETERS(), args2);
        String line = "\n";
        String tab = "\t";
        if (args2.map().isEmpty()) {
            Map<String, Supplier<ProcedureBuilder>> procedures = HoodieProcedures$.MODULE$.procedures();
            scala.collection.mutable.StringBuilder result = new scala.collection.mutable.StringBuilder();
            result.append("synopsis").append(line).append(tab).append("call [command]([key1]=>[value1],[key2]=>[value2])").append(line);
            result.append("commands and description").append(line);
            ((IterableLike)procedures.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._1(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)procedure -> {
                BoxedUnit boxedUnit;
                String name = (String)procedure._1();
                Option builderSupplier = Option$.MODULE$.apply(procedure._2());
                if (builderSupplier.isDefined()) {
                    Procedure procedure2 = ((ProcedureBuilder)((Supplier)builderSupplier.get()).get()).build();
                    boxedUnit = result.append(tab).append(name).append(tab).append(procedure2.description()).append(line);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            });
            result.append("You can use 'call help(cmd=>[command])' to view the detailed parameters of the command").append(line);
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{result.toString()}))}));
        } else {
            Option<Object> cmdOpt = this.getArgValueOrDefault(args2, this.PARAMETERS()[0]);
            Predef$.MODULE$.assert(cmdOpt.isDefined(), (Function0 & Serializable & scala.Serializable)() -> "The cmd parameter is required");
            String cmd = (String)cmdOpt.get();
            Map<String, Supplier<ProcedureBuilder>> procedures = HoodieProcedures$.MODULE$.procedures();
            Option builderSupplier = procedures.get((Object)cmd.trim());
            if (builderSupplier.isEmpty()) {
                throw new HoodieException(new StringBuilder(36).append("can not find ").append(cmd).append(" command in procedures.").toString());
            }
            Procedure procedure2 = ((ProcedureBuilder)((Supplier)builderSupplier.get()).get()).build();
            scala.collection.mutable.StringBuilder result = new scala.collection.mutable.StringBuilder();
            result.append("parameters:").append(line);
            result.append(tab).append(this.lengthFormat("param")).append(tab).append(this.lengthFormat("type_name")).append(tab).append(this.lengthFormat("default_value")).append(tab).append(this.lengthFormat("required")).append(line);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])procedure2.parameters())).foreach((Function1 & Serializable & scala.Serializable)param -> result.append(tab).append(this.lengthFormat(param.name())).append(tab).append(this.lengthFormat(param.dataType().typeName())).append(tab).append(this.lengthFormat(String.valueOf(param.default()))).append(tab).append(this.lengthFormat(((Object)BoxesRunTime.boxToBoolean((boolean)param.required())).toString())).append(line));
            result.append("outputType:").append(line);
            result.append(tab).append(this.lengthFormat("name")).append(tab).append(this.lengthFormat("type_name")).append(tab).append(this.lengthFormat("nullable")).append(tab).append(this.lengthFormat("metadata")).append(line);
            procedure2.outputType().map((Function1 & Serializable & scala.Serializable)field -> result.append(tab).append(this.lengthFormat(field.name())).append(tab).append(this.lengthFormat(field.dataType().typeName())).append(tab).append(this.lengthFormat(((Object)BoxesRunTime.boxToBoolean((boolean)field.nullable())).toString())).append(tab).append(this.lengthFormat(field.metadata().toString())).append(line), Seq$.MODULE$.canBuildFrom());
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{result.toString()}))}));
        }
        return seq;
    }

    public String lengthFormat(String string) {
        return String.format("%-30s", string);
    }

    @Override
    public HelpProcedure build() {
        return new HelpProcedure();
    }

    public HelpProcedure() {
        Logging.$init$((Logging)this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.optional(0, "cmd", DataTypes.StringType, ProcedureParameter$.MODULE$.optional$default$4())});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("result", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
    }
}

