/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.Serializable;
import java.util.function.Supplier;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.DeDupeType$;
import org.apache.spark.sql.hudi.DedupeSparkJob;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.RepairDeduplicateProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001\u0002\t\u0012\u0001\u0001BQA\f\u0001\u0005\u0002=Bq!\r\u0001C\u0002\u0013%!\u0007\u0003\u0004=\u0001\u0001\u0006Ia\r\u0005\b{\u0001\u0011\r\u0011\"\u0003?\u0011\u0019)\u0005\u0001)A\u0005\u007f!)a\t\u0001C\u0001e!)q\t\u0001C\u0001}!)\u0001\n\u0001C!\u0013\")q\f\u0001C!A\u001e)A-\u0005E\u0001K\u001a)\u0001#\u0005E\u0001M\")af\u0003C\u0001U\"91n\u0003b\u0001\n\u0003a\u0007BB;\fA\u0003%Q\u000eC\u0003w\u0017\u0011\u0005qO\u0001\u000eSKB\f\u0017N\u001d#fIV\u0004H.[2bi\u0016\u0004&o\\2fIV\u0014XM\u0003\u0002\u0013'\u0005Q\u0001O]8dK\u0012,(/Z:\u000b\u0005Q)\u0012aB2p[6\fg\u000e\u001a\u0006\u0003-]\tA\u0001[;eS*\u0011\u0001$G\u0001\u0004gFd'B\u0001\u000e\u001c\u0003\u0015\u0019\b/\u0019:l\u0015\taR$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002=\u0005\u0019qN]4\u0004\u0001M!\u0001!I\u0013)!\t\u00113%D\u0001\u0012\u0013\t!\u0013CA\u0007CCN,\u0007K]8dK\u0012,(/\u001a\t\u0003E\u0019J!aJ\t\u0003!A\u0013xnY3ekJ,')^5mI\u0016\u0014\bCA\u0015-\u001b\u0005Q#BA\u0016\u001a\u0003!Ig\u000e^3s]\u0006d\u0017BA\u0017+\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#\u0001\u0019\u0011\u0005\t\u0002\u0011A\u0003)B%\u0006kU\tV#S'V\t1\u0007E\u00025oej\u0011!\u000e\u0006\u0002m\u0005)1oY1mC&\u0011\u0001(\u000e\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003EiJ!aO\t\u0003%A\u0013xnY3ekJ,\u0007+\u0019:b[\u0016$XM]\u0001\f!\u0006\u0013\u0016)T#U\u000bJ\u001b\u0006%A\u0006P+R\u0003V\u000bV0U3B+U#A \u0011\u0005\u0001\u001bU\"A!\u000b\u0005\t;\u0012!\u0002;za\u0016\u001c\u0018B\u0001#B\u0005)\u0019FO];diRK\b/Z\u0001\r\u001fV#\u0006+\u0016+`)f\u0003V\tI\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\u0018AC8viB,H\u000fV=qK\u0006!1-\u00197m)\tQ%\fE\u0002L'Zs!\u0001T)\u000f\u00055\u0003V\"\u0001(\u000b\u0005={\u0012A\u0002\u001fs_>$h(C\u00017\u0013\t\u0011V'A\u0004qC\u000e\\\u0017mZ3\n\u0005Q+&aA*fc*\u0011!+\u000e\t\u0003/bk\u0011aF\u0005\u00033^\u00111AU8x\u0011\u0015Y\u0006\u00021\u0001]\u0003\u0011\t'oZ:\u0011\u0005\tj\u0016B\u00010\u0012\u00055\u0001&o\\2fIV\u0014X-\u0011:hg\u0006)!-^5mIV\t\u0011\r\u0005\u0002#E&\u00111-\u0005\u0002\n!J|7-\u001a3ve\u0016\f!DU3qC&\u0014H)\u001a3va2L7-\u0019;f!J|7-\u001a3ve\u0016\u0004\"AI\u0006\u0014\u0005-9\u0007C\u0001\u001bi\u0013\tIWG\u0001\u0004B]f\u0014VM\u001a\u000b\u0002K\u0006!a*Q'F+\u0005i\u0007C\u00018t\u001b\u0005y'B\u00019r\u0003\u0011a\u0017M\\4\u000b\u0003I\fAA[1wC&\u0011Ao\u001c\u0002\u0007'R\u0014\u0018N\\4\u0002\u000b9\u000bU*\u0012\u0011\u0002\u000f\t,\u0018\u000e\u001c3feV\t\u0001\u0010E\u0002z}\u0016j\u0011A\u001f\u0006\u0003wr\f\u0001BZ;oGRLwN\u001c\u0006\u0003{F\fA!\u001e;jY&\u0011qP\u001f\u0002\t'V\u0004\b\u000f\\5fe\u0002")
public class RepairDeduplicateProcedure
extends BaseProcedure
implements ProcedureBuilder,
Logging {
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Supplier<ProcedureBuilder> builder() {
        return RepairDeduplicateProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return RepairDeduplicateProcedure$.MODULE$.NAME();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args2) {
        super.checkArgs(this.PARAMETERS(), args2);
        Option<Object> tableName = this.getArgValueOrDefault(args2, this.PARAMETERS()[0]);
        String duplicatedPartitionPath = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[1]).get();
        String repairedOutputPath = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[2]).get();
        boolean dryRun = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args2, this.PARAMETERS()[3]).get());
        String dedupeType = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[4]).get();
        if (!DeDupeType$.MODULE$.values().contains(DeDupeType$.MODULE$.withName(dedupeType))) {
            throw new IllegalArgumentException("Please provide valid dedupe type!");
        }
        String basePath = this.getBasePath(tableName, this.getBasePath$default$2());
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            DedupeSparkJob job = new DedupeSparkJob(basePath, duplicatedPartitionPath, repairedOutputPath, this.spark().sqlContext(), FSUtils.getFs(basePath, this.jsc().hadoopConfiguration()), DeDupeType$.MODULE$.withName(dedupeType));
            job.fixDuplicates(dryRun);
        });
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw new HoodieException("Deduplication failed!", e);
            }
            throw new MatchError((Object)try_);
        }
        Seq seq = dryRun ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(31).append("Deduplicated files placed in: ").append(repairedOutputPath).append(".").toString()}))})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(31).append("Deduplicated files placed in: ").append(duplicatedPartitionPath).append(".").toString()}))}));
        return seq;
    }

    @Override
    public Procedure build() {
        return new RepairDeduplicateProcedure();
    }

    public RepairDeduplicateProcedure() {
        Logging.$init$((Logging)this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType), ProcedureParameter$.MODULE$.required(1, "duplicated_partition_path", DataTypes.StringType), ProcedureParameter$.MODULE$.required(2, "repaired_output_path", DataTypes.StringType), ProcedureParameter$.MODULE$.optional(3, "dry_run", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)true)), ProcedureParameter$.MODULE$.optional(4, "dedupe_type", DataTypes.StringType, "insert_type")});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("result", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
    }
}

