/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.utilities.DummySchemaProvider;
import org.apache.hudi.utilities.SparkAvroSchemaProvider;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.hudi.utilities.schema.SchemaPostProcessor;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.schema.SchemaProviderWithPostProcessor;
import org.apache.hudi.utilities.schema.SparkAvroPostProcessor;
import org.apache.hudi.utilities.testutils.UtilitiesTestBase;
import org.apache.hudi.utilities.transform.FlatteningTransformer;
import org.apache.spark.api.java.JavaSparkContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSchemaPostProcessor
extends UtilitiesTestBase {
    private TypedProperties properties = new TypedProperties();
    private static String ORIGINAL_SCHEMA = "{\"name\":\"t3_biz_operation_t_driver\",\"type\":\"record\",\"fields\":[{\"name\":\"ums_id_\",\"type\":[\"null\",\"string\"],\"default\":null},{\"name\":\"ums_ts_\",\"type\":[\"null\",\"string\"],\"default\":null}]}";
    private static String RESULT_SCHEMA = "{\"type\":\"record\",\"name\":\"hoodie_source\",\"namespace\":\"hoodie.source\",\"fields\":[{\"name\":\"ums_id_\",\"type\":[\"string\",\"null\"]},{\"name\":\"ums_ts_\",\"type\":[\"string\",\"null\"]}]}";

    @Test
    public void testPostProcessor() throws IOException {
        this.properties.put((Object)"hoodie.deltastreamer.schemaprovider.schema_post_processor", (Object)DummySchemaPostProcessor.class.getName());
        SchemaProviderWithPostProcessor provider = UtilHelpers.wrapSchemaProviderWithPostProcessor((SchemaProvider)UtilHelpers.createSchemaProvider((String)DummySchemaProvider.class.getName(), (TypedProperties)this.properties, (JavaSparkContext)this.jsc), (TypedProperties)this.properties, (JavaSparkContext)this.jsc, null);
        Schema schema = provider.getSourceSchema();
        Assertions.assertEquals((Object)schema.getType(), (Object)Schema.Type.RECORD);
        Assertions.assertEquals((Object)schema.getName(), (Object)"test");
        Assertions.assertNotNull((Object)schema.getField("testString"));
    }

    @Test
    public void testSparkAvro() throws IOException {
        this.properties.put((Object)"hoodie.deltastreamer.schemaprovider.schema_post_processor", (Object)SparkAvroPostProcessor.class.getName());
        ArrayList<String> transformerClassNames = new ArrayList<String>();
        transformerClassNames.add(FlatteningTransformer.class.getName());
        SchemaProviderWithPostProcessor provider = UtilHelpers.wrapSchemaProviderWithPostProcessor((SchemaProvider)UtilHelpers.createSchemaProvider((String)SparkAvroSchemaProvider.class.getName(), (TypedProperties)this.properties, (JavaSparkContext)this.jsc), (TypedProperties)this.properties, (JavaSparkContext)this.jsc, transformerClassNames);
        Schema schema = provider.getSourceSchema();
        Assertions.assertEquals((Object)schema.getType(), (Object)Schema.Type.RECORD);
        Assertions.assertEquals((Object)schema.getName(), (Object)"hoodie_source");
        Assertions.assertEquals((Object)schema.getNamespace(), (Object)"hoodie.source");
        Assertions.assertNotNull((Object)schema.getField("day"));
    }

    @Test
    public void testSparkAvroSchema() throws IOException {
        SparkAvroPostProcessor processor = new SparkAvroPostProcessor(this.properties, null);
        Schema schema = new Schema.Parser().parse(ORIGINAL_SCHEMA);
        Assertions.assertEquals((Object)processor.processSchema(schema).toString(), (Object)RESULT_SCHEMA);
    }

    public static class DummySchemaPostProcessor
    extends SchemaPostProcessor {
        public DummySchemaPostProcessor(TypedProperties props, JavaSparkContext jssc) {
            super(props, jssc);
        }

        public Schema processSchema(Schema schema) {
            return (Schema)SchemaBuilder.record((String)"test").fields().optionalString("testString").endRecord();
        }
    }
}

