/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.hudi.utilities.transform.ChainedTransformer;
import org.apache.hudi.utilities.transform.Transformer;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public class TestUtilHelpers {

    @Nested
    public class TestCreateTransformer {
        @Test
        public void testCreateTransformerNotPresent() throws IOException {
            Assertions.assertFalse((boolean)UtilHelpers.createTransformer(null).isPresent());
        }

        @Test
        public void testCreateTransformerLoadOneClass() throws IOException {
            Transformer transformer = (Transformer)UtilHelpers.createTransformer(Collections.singletonList(TransformerFoo.class.getName())).get();
            Assertions.assertTrue((boolean)(transformer instanceof ChainedTransformer));
            List transformerNames = ((ChainedTransformer)transformer).getTransformersNames();
            Assertions.assertEquals((int)1, (int)transformerNames.size());
            Assertions.assertEquals((Object)TransformerFoo.class.getName(), transformerNames.get(0));
        }

        @Test
        public void testCreateTransformerLoadMultipleClasses() throws IOException {
            List<String> classNames = Arrays.asList(TransformerFoo.class.getName(), TransformerBar.class.getName());
            Transformer transformer = (Transformer)UtilHelpers.createTransformer(classNames).get();
            Assertions.assertTrue((boolean)(transformer instanceof ChainedTransformer));
            List transformerNames = ((ChainedTransformer)transformer).getTransformersNames();
            Assertions.assertEquals((int)2, (int)transformerNames.size());
            Assertions.assertEquals((Object)TransformerFoo.class.getName(), transformerNames.get(0));
            Assertions.assertEquals((Object)TransformerBar.class.getName(), transformerNames.get(1));
        }

        @Test
        public void testCreateTransformerThrowsException() throws IOException {
            Exception e = (Exception)Assertions.assertThrows(IOException.class, () -> UtilHelpers.createTransformer(Arrays.asList("foo", "bar")));
            Assertions.assertEquals((Object)"Could not load transformer class(es) [foo, bar]", (Object)e.getMessage());
        }
    }

    public static class TransformerBar
    implements Transformer {
        public Dataset apply(JavaSparkContext jsc, SparkSession sparkSession, Dataset<Row> rowDataset, TypedProperties properties) {
            return null;
        }
    }

    public static class TransformerFoo
    implements Transformer {
        public Dataset apply(JavaSparkContext jsc, SparkSession sparkSession, Dataset<Row> rowDataset, TypedProperties properties) {
            return null;
        }
    }
}

