/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.checkpointing;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.utilities.checkpointing.InitialCheckPointProvider;
import org.apache.hudi.utilities.checkpointing.KafkaConnectHdfsProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestKafkaConnectHdfsProvider
extends HoodieCommonTestHarness {
    @Test
    public void testValidKafkaConnectPath() throws Exception {
        Path topicPath = this.tempDir.resolve("topic1");
        Files.createDirectories(topicPath, new FileAttribute[0]);
        new File(topicPath + "/year=2016/month=05/day=01/").mkdirs();
        new File(topicPath + "/year=2016/month=05/day=02/").mkdirs();
        new File(topicPath + "/TMP").mkdirs();
        new File(topicPath + "/TMP/topic1+0+301+400.parquet").createNewFile();
        new File(topicPath + "/year=2016/month=05/day=01/topic1+0+100+200.parquet").createNewFile();
        new File(topicPath + "/year=2016/month=05/day=01/topic1+1+100+200.parquet").createNewFile();
        new File(topicPath + "/year=2016/month=05/day=02/topic1+0+201+300.parquet").createNewFile();
        new File(topicPath + "/year=2016/month=05/day=01/random_snappy_1.parquet").createNewFile();
        new File(topicPath + "/year=2016/month=05/day=02/random_snappy_2.parquet").createNewFile();
        TypedProperties props = new TypedProperties();
        props.put((Object)"hoodie.deltastreamer.checkpoint.provider.path", (Object)topicPath.toString());
        KafkaConnectHdfsProvider provider = new KafkaConnectHdfsProvider(props);
        provider.init(HoodieTestUtils.getDefaultHadoopConf());
        Assertions.assertEquals((Object)"topic1,0:300,1:200", (Object)provider.getCheckpoint());
    }

    @Test
    public void testMissingPartition() throws Exception {
        Path topicPath = this.tempDir.resolve("topic2");
        Files.createDirectories(topicPath, new FileAttribute[0]);
        new File(topicPath + "/year=2016/month=05/day=01/").mkdirs();
        new File(topicPath + "/year=2016/month=05/day=02/").mkdirs();
        new File(topicPath + "/year=2016/month=05/day=01/topic1+0+100+200.parquet").createNewFile();
        new File(topicPath + "/year=2016/month=05/day=01/topic1+2+100+200.parquet").createNewFile();
        new File(topicPath + "/year=2016/month=05/day=02/topic1+0+201+300.parquet").createNewFile();
        TypedProperties props = new TypedProperties();
        props.put((Object)"hoodie.deltastreamer.checkpoint.provider.path", (Object)topicPath.toString());
        KafkaConnectHdfsProvider provider = new KafkaConnectHdfsProvider(props);
        provider.init(HoodieTestUtils.getDefaultHadoopConf());
        Assertions.assertThrows(HoodieException.class, () -> ((InitialCheckPointProvider)provider).getCheckpoint());
    }
}

