/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.deltastreamer;

import java.util.Map;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.utilities.deltastreamer.HoodieDeltaStreamer;
import org.apache.hudi.utilities.deltastreamer.SchedulerConfGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSchedulerConfGenerator {
    @Test
    public void testGenerateSparkSchedulingConf() throws Exception {
        HoodieDeltaStreamer.Config cfg = new HoodieDeltaStreamer.Config();
        Map configs = SchedulerConfGenerator.getSparkSchedulingConfigs((HoodieDeltaStreamer.Config)cfg);
        Assertions.assertNull(configs.get("spark.scheduler.allocation.file"), (String)"spark.scheduler.mode not set");
        System.setProperty("spark.scheduler.mode", "FAIR");
        cfg.continuousMode = false;
        configs = SchedulerConfGenerator.getSparkSchedulingConfigs((HoodieDeltaStreamer.Config)cfg);
        Assertions.assertNull(configs.get("spark.scheduler.allocation.file"), (String)"continuousMode is false");
        cfg.continuousMode = true;
        cfg.tableType = HoodieTableType.COPY_ON_WRITE.name();
        configs = SchedulerConfGenerator.getSparkSchedulingConfigs((HoodieDeltaStreamer.Config)cfg);
        Assertions.assertNull(configs.get("spark.scheduler.allocation.file"), (String)"table type is not MERGE_ON_READ");
        cfg.tableType = HoodieTableType.MERGE_ON_READ.name();
        configs = SchedulerConfGenerator.getSparkSchedulingConfigs((HoodieDeltaStreamer.Config)cfg);
        Assertions.assertNotNull(configs.get("spark.scheduler.allocation.file"), (String)"all satisfies");
    }
}

