/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.functional;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.payload.AWSDmsAvroPayload;
import org.apache.hudi.testutils.FunctionalTestHarness;
import org.apache.hudi.utilities.transform.AWSDmsTransformer;
import org.apache.spark.sql.Dataset;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="functional")
public class TestAWSDatabaseMigrationServiceSource
extends FunctionalTestHarness {
    @Test
    public void testPayload() throws IOException {
        Schema schema = Schema.createRecord(Arrays.asList(new Schema.Field("id", Schema.create((Schema.Type)Schema.Type.STRING), "", null), new Schema.Field("ts", Schema.create((Schema.Type)Schema.Type.LONG), "", null), new Schema.Field("Op", Schema.create((Schema.Type)Schema.Type.STRING), "", null)));
        GenericData.Record record = new GenericData.Record(schema);
        record.put("id", (Object)"1");
        record.put("Op", (Object)"");
        record.put("ts", (Object)0L);
        AWSDmsAvroPayload payload = new AWSDmsAvroPayload((GenericRecord)record, (Comparable)record.get("ts"));
        Assertions.assertTrue((boolean)payload.combineAndGetUpdateValue(null, schema).isPresent());
        record.put("Op", (Object)"I");
        payload = new AWSDmsAvroPayload((GenericRecord)record, (Comparable)record.get("ts"));
        Assertions.assertTrue((boolean)payload.combineAndGetUpdateValue(null, schema).isPresent());
        record.put("Op", (Object)"D");
        payload = new AWSDmsAvroPayload((GenericRecord)record, (Comparable)record.get("ts"));
        Assertions.assertFalse((boolean)payload.combineAndGetUpdateValue(null, schema).isPresent());
    }

    @Test
    public void testTransformer() {
        AWSDmsTransformer transformer = new AWSDmsTransformer();
        Dataset inputFrame = this.spark().createDataFrame(Arrays.asList(new Record("1", 3433L), new Record("2", 3433L)), Record.class);
        Dataset outputFrame = transformer.apply(this.jsc(), this.spark(), inputFrame, null);
        Assertions.assertTrue((boolean)Arrays.stream(outputFrame.schema().fields()).map(f -> f.name()).anyMatch(n -> n.equals("Op")));
        Assertions.assertTrue((boolean)outputFrame.select("Op", new String[0]).collectAsList().stream().allMatch(r -> r.getString(0).equals("")));
    }

    static class Record
    implements Serializable {
        String id;
        long ts;

        Record(String id, long ts) {
            this.id = id;
            this.ts = ts;
        }
    }
}

