/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.functional;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.testutils.FunctionalTestHarness;
import org.apache.hudi.utilities.HoodieSnapshotCopier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="functional")
public class TestHoodieSnapshotCopier
extends FunctionalTestHarness {
    private static final String TEST_WRITE_TOKEN = "1-0-1";
    private String basePath;
    private String outputPath;
    private FileSystem fs;

    @BeforeEach
    public void init() throws IOException {
        String rootPath = "file://" + this.tempDir.toString();
        this.basePath = rootPath + "/" + "raw_trips";
        this.outputPath = rootPath + "/output";
        Configuration hadoopConf = HoodieTestUtils.getDefaultHadoopConf();
        this.fs = FSUtils.getFs((String)this.basePath, (Configuration)hadoopConf);
        HoodieTestUtils.init((Configuration)hadoopConf, (String)this.basePath);
    }

    @Test
    public void testEmptySnapshotCopy() throws IOException {
        Assertions.assertEquals((int)this.fs.listStatus(new Path(this.basePath)).length, (int)1);
        Assertions.assertFalse((boolean)this.fs.exists(new Path(this.outputPath)));
        HoodieSnapshotCopier copier = new HoodieSnapshotCopier();
        copier.snapshot(this.jsc(), this.basePath, this.outputPath, true, false, false);
        Assertions.assertEquals((int)this.fs.listStatus(new Path(this.basePath)).length, (int)1);
        Assertions.assertFalse((boolean)this.fs.exists(new Path(this.outputPath + "/_SUCCESS")));
    }

    public void testSnapshotCopy() throws Exception {
        String commitTime1 = "20160501010101";
        String commitTime2 = "20160502020601";
        String commitTime3 = "20160506030611";
        new File(this.basePath + "/.hoodie").mkdirs();
        new File(this.basePath + "/.hoodie/hoodie.properties").createNewFile();
        new File(this.basePath + "/.hoodie/" + commitTime1 + ".commit").createNewFile();
        new File(this.basePath + "/.hoodie/" + commitTime2 + ".commit").createNewFile();
        new File(this.basePath + "/.hoodie/" + commitTime3 + ".inflight").createNewFile();
        new File(this.basePath + "/2016/05/01/").mkdirs();
        new File(this.basePath + "/2016/05/02/").mkdirs();
        new File(this.basePath + "/2016/05/06/").mkdirs();
        HoodieTestDataGenerator.writePartitionMetadata((FileSystem)this.fs, (String[])new String[]{"2016/05/01", "2016/05/02", "2016/05/06"}, (String)this.basePath);
        File file11 = new File(this.basePath + "/2016/05/01/" + FSUtils.makeDataFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)"id11"));
        file11.createNewFile();
        File file12 = new File(this.basePath + "/2016/05/02/" + FSUtils.makeDataFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)"id12"));
        file12.createNewFile();
        File file13 = new File(this.basePath + "/2016/05/06/" + FSUtils.makeDataFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)"id13"));
        file13.createNewFile();
        File file21 = new File(this.basePath + "/2016/05/01/" + FSUtils.makeDataFileName((String)commitTime2, (String)TEST_WRITE_TOKEN, (String)"id21"));
        file21.createNewFile();
        File file22 = new File(this.basePath + "/2016/05/02/" + FSUtils.makeDataFileName((String)commitTime2, (String)TEST_WRITE_TOKEN, (String)"id22"));
        file22.createNewFile();
        File file23 = new File(this.basePath + "/2016/05/06/" + FSUtils.makeDataFileName((String)commitTime2, (String)TEST_WRITE_TOKEN, (String)"id23"));
        file23.createNewFile();
        File file31 = new File(this.basePath + "/2016/05/01/" + FSUtils.makeDataFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)"id31"));
        file31.createNewFile();
        File file32 = new File(this.basePath + "/2016/05/02/" + FSUtils.makeDataFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)"id32"));
        file32.createNewFile();
        File file33 = new File(this.basePath + "/2016/05/06/" + FSUtils.makeDataFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)"id33"));
        file33.createNewFile();
        HoodieSnapshotCopier copier = new HoodieSnapshotCopier();
        copier.snapshot(this.jsc(), this.basePath, this.outputPath, false, false, false);
        Assertions.assertTrue((boolean)this.fs.exists(new Path(this.outputPath + "/2016/05/01/" + file11.getName())));
        Assertions.assertTrue((boolean)this.fs.exists(new Path(this.outputPath + "/2016/05/02/" + file12.getName())));
        Assertions.assertTrue((boolean)this.fs.exists(new Path(this.outputPath + "/2016/05/06/" + file13.getName())));
        Assertions.assertTrue((boolean)this.fs.exists(new Path(this.outputPath + "/2016/05/01/" + file21.getName())));
        Assertions.assertTrue((boolean)this.fs.exists(new Path(this.outputPath + "/2016/05/02/" + file22.getName())));
        Assertions.assertTrue((boolean)this.fs.exists(new Path(this.outputPath + "/2016/05/06/" + file23.getName())));
        Assertions.assertFalse((boolean)this.fs.exists(new Path(this.outputPath + "/2016/05/01/" + file31.getName())));
        Assertions.assertFalse((boolean)this.fs.exists(new Path(this.outputPath + "/2016/05/02/" + file32.getName())));
        Assertions.assertFalse((boolean)this.fs.exists(new Path(this.outputPath + "/2016/05/06/" + file33.getName())));
        Assertions.assertTrue((boolean)this.fs.exists(new Path(this.outputPath + "/.hoodie/" + commitTime1 + ".commit")));
        Assertions.assertTrue((boolean)this.fs.exists(new Path(this.outputPath + "/.hoodie/" + commitTime2 + ".commit")));
        Assertions.assertFalse((boolean)this.fs.exists(new Path(this.outputPath + "/.hoodie/" + commitTime3 + ".commit")));
        Assertions.assertFalse((boolean)this.fs.exists(new Path(this.outputPath + "/.hoodie/" + commitTime3 + ".inflight")));
        Assertions.assertTrue((boolean)this.fs.exists(new Path(this.outputPath + "/.hoodie/hoodie.properties")));
        Assertions.assertTrue((boolean)this.fs.exists(new Path(this.outputPath + "/_SUCCESS")));
    }
}

