/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.functional;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.testutils.FunctionalTestHarness;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.hudi.utilities.schema.JdbcbasedSchemaProvider;
import org.apache.hudi.utilities.testutils.UtilitiesTestBase;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaSparkContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="functional")
public class TestJdbcbasedSchemaProvider
extends FunctionalTestHarness {
    private static final Logger LOG = LogManager.getLogger(TestJdbcbasedSchemaProvider.class);
    private static final TypedProperties PROPS = new TypedProperties();

    @BeforeAll
    public static void init() {
        PROPS.setProperty("hoodie.deltastreamer.schemaprovider.source.schema.jdbc.connection.url", "jdbc:h2:mem:test_mem");
        PROPS.setProperty("hoodie.deltastreamer.schemaprovider.source.schema.jdbc.driver.type", "org.h2.Driver");
        PROPS.setProperty("hoodie.deltastreamer.schemaprovider.source.schema.jdbc.username", "sa");
        PROPS.setProperty("hoodie.deltastreamer.schemaprovider.source.schema.jdbc.password", "");
        PROPS.setProperty("hoodie.deltastreamer.schemaprovider.source.schema.jdbc.dbtable", "triprec");
        PROPS.setProperty("hoodie.deltastreamer.schemaprovider.source.schema.jdbc.timeout", "0");
        PROPS.setProperty("hoodie.deltastreamer.schemaprovider.source.schema.jdbc.nullable", "false");
    }

    @Test
    public void testJdbcbasedSchemaProvider() throws Exception {
        try {
            this.initH2Database();
            Schema sourceSchema = UtilHelpers.createSchemaProvider((String)JdbcbasedSchemaProvider.class.getName(), (TypedProperties)PROPS, (JavaSparkContext)this.jsc()).getSourceSchema();
            Assertions.assertEquals((Object)sourceSchema.toString().toUpperCase(), (Object)new Schema.Parser().parse(UtilitiesTestBase.Helpers.readFile("delta-streamer-config/source-jdbc.avsc")).toString().toUpperCase());
        }
        catch (HoodieException e) {
            LOG.error((Object)"Failed to get connection through jdbc. ", (Throwable)e);
        }
    }

    private void initH2Database() throws SQLException, IOException {
        Connection conn = DriverManager.getConnection("jdbc:h2:mem:test_mem", "sa", "");
        PreparedStatement ps = conn.prepareStatement(UtilitiesTestBase.Helpers.readFile("delta-streamer-config/triprec.sql"));
        ps.executeUpdate();
    }
}

