/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.utilities.schema.RowBasedSchemaProvider;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.InputBatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestInputBatch {
    @Test
    public void getSchemaProviderShouldThrowException() {
        InputBatch inputBatch = new InputBatch(Option.of((Object)"foo"), null, null);
        Throwable t = Assertions.assertThrows(HoodieException.class, () -> ((InputBatch)inputBatch).getSchemaProvider());
        Assertions.assertEquals((Object)"Please provide a valid schema provider class!", (Object)t.getMessage());
    }

    @Test
    public void getSchemaProviderShouldReturnNullSchemaProvider() {
        InputBatch inputBatch = new InputBatch(Option.empty(), null, null);
        SchemaProvider schemaProvider = inputBatch.getSchemaProvider();
        Assertions.assertTrue((boolean)(schemaProvider instanceof InputBatch.NullSchemaProvider));
    }

    @Test
    public void getSchemaProviderShouldReturnGivenSchemaProvider() {
        RowBasedSchemaProvider schemaProvider = new RowBasedSchemaProvider(null);
        InputBatch inputBatch = new InputBatch(Option.of((Object)"foo"), null, (SchemaProvider)schemaProvider);
        Assertions.assertSame((Object)schemaProvider, (Object)inputBatch.getSchemaProvider());
    }
}

