/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.ParquetDFSSource;
import org.apache.hudi.utilities.sources.Source;
import org.apache.hudi.utilities.testutils.UtilitiesTestBase;
import org.apache.hudi.utilities.testutils.sources.AbstractDFSSourceTestBase;
import org.junit.jupiter.api.BeforeEach;

public class TestParquetDFSSource
extends AbstractDFSSourceTestBase {
    @Override
    @BeforeEach
    public void setup() throws Exception {
        super.setup();
        this.dfsRoot = dfsBasePath + "/parquetFiles";
        this.fileSuffix = ".parquet";
    }

    @Override
    public Source prepareDFSSource() {
        TypedProperties props = new TypedProperties();
        props.setProperty("hoodie.deltastreamer.source.dfs.root", this.dfsRoot);
        return new ParquetDFSSource(props, this.jsc, this.sparkSession, (SchemaProvider)this.schemaProvider);
    }

    @Override
    public void writeNewDataToFile(List<HoodieRecord> records, Path path) throws IOException {
        UtilitiesTestBase.Helpers.saveParquetToDFS(UtilitiesTestBase.Helpers.toGenericRecords(records), path);
    }
}

