/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.testutils;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.server.HiveServer2;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.common.testutils.minicluster.HdfsTestService;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HoodieHiveClient;
import org.apache.hudi.hive.testutils.HiveTestService;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.hudi.utilities.sources.TestDataSource;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;

public class UtilitiesTestBase {
    protected static String dfsBasePath;
    protected static HdfsTestService hdfsTestService;
    protected static MiniDFSCluster dfsCluster;
    protected static DistributedFileSystem dfs;
    protected transient JavaSparkContext jsc = null;
    protected transient HoodieSparkEngineContext context = null;
    protected transient SparkSession sparkSession = null;
    protected transient SQLContext sqlContext;
    protected static HiveServer2 hiveServer;
    protected static HiveTestService hiveTestService;
    private static ObjectMapper mapper;

    @BeforeAll
    public static void initClass() throws Exception {
        Logger rootLogger = Logger.getRootLogger();
        rootLogger.setLevel(Level.ERROR);
        Logger.getLogger((String)"org.apache.spark").setLevel(Level.WARN);
        UtilitiesTestBase.initClass(true);
    }

    public static void initClass(boolean startHiveService) throws Exception {
        hdfsTestService = new HdfsTestService();
        dfsCluster = hdfsTestService.start(true);
        dfs = dfsCluster.getFileSystem();
        dfsBasePath = dfs.getWorkingDirectory().toString();
        dfs.mkdirs(new Path(dfsBasePath));
        if (startHiveService) {
            hiveTestService = new HiveTestService(hdfsTestService.getHadoopConf());
            hiveServer = hiveTestService.start();
            UtilitiesTestBase.clearHiveDb();
        }
    }

    @AfterAll
    public static void cleanupClass() {
        if (hdfsTestService != null) {
            hdfsTestService.stop();
        }
        if (hiveServer != null) {
            hiveServer.stop();
        }
        if (hiveTestService != null) {
            hiveTestService.stop();
        }
    }

    @BeforeEach
    public void setup() throws Exception {
        TestDataSource.initDataGen();
        this.jsc = UtilHelpers.buildSparkContext((String)(this.getClass().getName() + "-hoodie"), (String)"local[2]");
        this.context = new HoodieSparkEngineContext(this.jsc);
        this.sqlContext = new SQLContext(this.jsc);
        this.sparkSession = SparkSession.builder().config(this.jsc.getConf()).getOrCreate();
    }

    @AfterEach
    public void teardown() throws Exception {
        TestDataSource.resetDataGen();
        if (this.jsc != null) {
            this.jsc.stop();
        }
        if (this.context != null) {
            this.context = null;
        }
    }

    protected static HiveSyncConfig getHiveSyncConfig(String basePath, String tableName) {
        HiveSyncConfig hiveSyncConfig = new HiveSyncConfig();
        hiveSyncConfig.jdbcUrl = "jdbc:hive2://127.0.0.1:9999/";
        hiveSyncConfig.hiveUser = "";
        hiveSyncConfig.hivePass = "";
        hiveSyncConfig.databaseName = "testdb1";
        hiveSyncConfig.tableName = tableName;
        hiveSyncConfig.basePath = basePath;
        hiveSyncConfig.assumeDatePartitioning = false;
        hiveSyncConfig.usePreApacheInputFormat = false;
        hiveSyncConfig.partitionFields = CollectionUtils.createImmutableList((Object[])new String[]{"datestr"});
        return hiveSyncConfig;
    }

    private static void clearHiveDb() throws IOException {
        HiveConf hiveConf = new HiveConf(true);
        HiveSyncConfig hiveSyncConfig = UtilitiesTestBase.getHiveSyncConfig("/dummy", "dummy");
        hiveConf.addResource((Configuration)hiveServer.getHiveConf());
        HoodieTableMetaClient.initTableType((Configuration)dfs.getConf(), (String)hiveSyncConfig.basePath, (HoodieTableType)HoodieTableType.COPY_ON_WRITE, (String)hiveSyncConfig.tableName, null);
        HoodieHiveClient client = new HoodieHiveClient(hiveSyncConfig, hiveConf, (FileSystem)dfs);
        client.updateHiveSQL("drop database if exists " + hiveSyncConfig.databaseName);
        client.updateHiveSQL("create database " + hiveSyncConfig.databaseName);
        client.close();
    }

    static {
        mapper = new ObjectMapper();
    }

    public static class Helpers {
        private static ClassLoader classLoader = Helpers.class.getClassLoader();

        public static String readFile(String testResourcePath) throws IOException {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(classLoader.getResourceAsStream(testResourcePath)));
            StringBuffer sb = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
            return sb.toString();
        }

        public static String readFileFromAbsolutePath(String absolutePathForResource) throws IOException {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(absolutePathForResource)));
            StringBuffer sb = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
            return sb.toString();
        }

        public static void copyToDFS(String testResourcePath, FileSystem fs, String targetPath) throws IOException {
            PrintStream os = new PrintStream((OutputStream)fs.create(new Path(targetPath), true));
            os.print(Helpers.readFile(testResourcePath));
            os.flush();
            os.close();
        }

        public static void copyToDFSFromAbsolutePath(String absolutePathForResource, FileSystem fs, String targetPath) throws IOException {
            PrintStream os = new PrintStream((OutputStream)fs.create(new Path(targetPath), true));
            os.print(Helpers.readFileFromAbsolutePath(absolutePathForResource));
            os.flush();
            os.close();
        }

        public static void savePropsToDFS(TypedProperties props, FileSystem fs, String targetPath) throws IOException {
            String[] lines = (String[])props.keySet().stream().map(k -> String.format("%s=%s", k, props.get(k))).toArray(String[]::new);
            Helpers.saveStringsToDFS(lines, fs, targetPath);
        }

        public static void saveStringsToDFS(String[] lines, FileSystem fs, String targetPath) throws IOException {
            PrintStream os = new PrintStream((OutputStream)fs.create(new Path(targetPath), true));
            for (String l : lines) {
                os.println(l);
            }
            os.flush();
            os.close();
        }

        public static void saveCsvToDFS(boolean hasHeader, char sep, String[] lines, FileSystem fs, String targetPath) throws IOException {
            CsvSchema.Builder csvSchemaBuilder = CsvSchema.builder();
            ArrayNode arrayNode = mapper.createArrayNode();
            Arrays.stream(lines).forEachOrdered(line -> {
                try {
                    arrayNode.add((JsonNode)mapper.readValue(line, ObjectNode.class));
                }
                catch (IOException e) {
                    throw new HoodieIOException("Error converting json records into CSV format: " + e.getMessage());
                }
            });
            arrayNode.get(0).fieldNames().forEachRemaining(arg_0 -> ((CsvSchema.Builder)csvSchemaBuilder).addColumn(arg_0));
            ObjectWriter csvObjWriter = new CsvMapper().writerFor(JsonNode.class).with((FormatSchema)csvSchemaBuilder.setUseHeader(hasHeader).setColumnSeparator(sep).build());
            PrintStream os = new PrintStream((OutputStream)fs.create(new Path(targetPath), true));
            csvObjWriter.writeValue((OutputStream)os, (Object)arrayNode);
            os.flush();
            os.close();
        }

        public static void saveParquetToDFS(List<GenericRecord> records, Path targetFile) throws IOException {
            try (ParquetWriter writer = ((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)AvroParquetWriter.builder((Path)targetFile).withSchema(HoodieTestDataGenerator.AVRO_SCHEMA).withConf(HoodieTestUtils.getDefaultHadoopConf())).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).build();){
                for (GenericRecord record : records) {
                    writer.write((Object)record);
                }
            }
        }

        public static TypedProperties setupSchemaOnDFS() throws IOException {
            return Helpers.setupSchemaOnDFS("delta-streamer-config", "source.avsc");
        }

        public static TypedProperties setupSchemaOnDFS(String scope, String filename) throws IOException {
            Helpers.copyToDFS(scope + "/" + filename, (FileSystem)dfs, dfsBasePath + "/" + filename);
            TypedProperties props = new TypedProperties();
            props.setProperty("hoodie.deltastreamer.schemaprovider.source.schema.file", dfsBasePath + "/" + filename);
            return props;
        }

        public static TypedProperties setupSchemaOnDFSWithAbsoluteScope(String scope, String filename) throws IOException {
            Helpers.copyToDFSFromAbsolutePath(scope + "/" + filename, (FileSystem)dfs, dfsBasePath + "/" + filename);
            TypedProperties props = new TypedProperties();
            props.setProperty("hoodie.deltastreamer.schemaprovider.source.schema.file", dfsBasePath + "/" + filename);
            return props;
        }

        public static GenericRecord toGenericRecord(HoodieRecord hoodieRecord) {
            try {
                Option recordOpt = hoodieRecord.getData().getInsertValue(HoodieTestDataGenerator.AVRO_SCHEMA);
                return (GenericRecord)recordOpt.get();
            }
            catch (IOException e) {
                return null;
            }
        }

        public static List<GenericRecord> toGenericRecords(List<HoodieRecord> hoodieRecords) {
            ArrayList<GenericRecord> records = new ArrayList<GenericRecord>();
            for (HoodieRecord hoodieRecord : hoodieRecords) {
                records.add(Helpers.toGenericRecord(hoodieRecord));
            }
            return records;
        }

        public static String toJsonString(HoodieRecord hr) {
            try {
                return ((RawTripTestPayload)hr.getData()).getJsonData();
            }
            catch (IOException ioe) {
                return null;
            }
        }

        public static String[] jsonifyRecords(List<HoodieRecord> records) {
            return (String[])records.stream().map(Helpers::toJsonString).toArray(String[]::new);
        }
    }
}

