/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.deltastreamer;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.DataSourceWriteOptions;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HiveSyncTool;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.hudi.utilities.deltastreamer.HoodieDeltaStreamer;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaSparkContext;

public class BootstrapExecutor
implements Serializable {
    private static final Logger LOG = LogManager.getLogger(BootstrapExecutor.class);
    private final HoodieDeltaStreamer.Config cfg;
    private transient SchemaProvider schemaProvider;
    private transient JavaSparkContext jssc;
    private final TypedProperties props;
    private final Configuration configuration;
    private final HoodieWriteConfig bootstrapConfig;
    private transient FileSystem fs;
    private String bootstrapBasePath;

    public BootstrapExecutor(HoodieDeltaStreamer.Config cfg, JavaSparkContext jssc, FileSystem fs, Configuration conf, TypedProperties properties) throws IOException {
        this.cfg = cfg;
        this.jssc = jssc;
        this.fs = fs;
        this.configuration = conf;
        this.props = properties;
        ValidationUtils.checkArgument((boolean)properties.containsKey((Object)HoodieTableConfig.BOOTSTRAP_BASE_PATH.key()), (String)(HoodieTableConfig.BOOTSTRAP_BASE_PATH.key() + " must be specified."));
        this.bootstrapBasePath = properties.getString(HoodieTableConfig.BOOTSTRAP_BASE_PATH.key());
        this.props.putIfAbsent((Object)DataSourceWriteOptions.PAYLOAD_CLASS_NAME().key(), DataSourceWriteOptions.PAYLOAD_CLASS_NAME().defaultValue());
        this.schemaProvider = UtilHelpers.createSchemaProvider(cfg.schemaProviderClassName, this.props, jssc);
        HoodieWriteConfig.Builder builder = HoodieWriteConfig.newBuilder().withPath(cfg.targetBasePath).withCompactionConfig(HoodieCompactionConfig.newBuilder().withInlineCompaction(Boolean.valueOf(false)).build()).forTable(cfg.targetTableName).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.BLOOM).build()).withAutoCommit(true).withProps((Map)this.props);
        if (null != this.schemaProvider && null != this.schemaProvider.getTargetSchema()) {
            builder = builder.withSchema(this.schemaProvider.getTargetSchema().toString());
        }
        this.bootstrapConfig = builder.build();
        LOG.info((Object)("Created bootstrap executor with configs : " + this.bootstrapConfig.getProps()));
    }

    public void execute() throws IOException {
        this.initializeTable();
        try (SparkRDDWriteClient bootstrapClient = new SparkRDDWriteClient((HoodieEngineContext)new HoodieSparkEngineContext(this.jssc), this.bootstrapConfig);){
            HashMap<String, String> checkpointCommitMetadata = new HashMap<String, String>();
            checkpointCommitMetadata.put("deltastreamer.checkpoint.key", this.cfg.checkpoint);
            if (this.cfg.checkpoint != null) {
                checkpointCommitMetadata.put("deltastreamer.checkpoint.reset_key", this.cfg.checkpoint);
            }
            bootstrapClient.bootstrap(Option.of(checkpointCommitMetadata));
            this.syncHive();
        }
    }

    private void syncHive() {
        if (this.cfg.enableHiveSync.booleanValue()) {
            HiveSyncConfig hiveSyncConfig = DataSourceUtils.buildHiveSyncConfig((TypedProperties)this.props, (String)this.cfg.targetBasePath, (String)this.cfg.baseFileFormat);
            LOG.info((Object)("Syncing target hoodie table with hive table(" + hiveSyncConfig.tableName + "). Hive metastore URL :" + hiveSyncConfig.jdbcUrl + ", basePath :" + this.cfg.targetBasePath));
            new HiveSyncTool(hiveSyncConfig, new HiveConf(this.configuration, HiveConf.class), this.fs).syncHoodieTable();
        }
    }

    private void initializeTable() throws IOException {
        if (this.fs.exists(new Path(this.cfg.targetBasePath))) {
            throw new HoodieException("target base path already exists at " + this.cfg.targetBasePath + ". Cannot bootstrap data on top of an existing table");
        }
        HoodieTableMetaClient.withPropertyBuilder().setTableType(this.cfg.tableType).setTableName(this.cfg.targetTableName).setArchiveLogFolder((String)HoodieTableConfig.ARCHIVELOG_FOLDER.defaultValue()).setPayloadClassName(this.cfg.payloadClassName).setBaseFileFormat(this.cfg.baseFileFormat).setBootstrapIndexClass(this.cfg.bootstrapIndexClass).setBootstrapBasePath(this.bootstrapBasePath).initTable(new Configuration(this.jssc.hadoopConfiguration()), this.cfg.targetBasePath);
    }

    public HoodieWriteConfig getBootstrapConfig() {
        return this.bootstrapConfig;
    }
}

